/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zip;

import io.intino.alexandria.logger.Logger;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zip {
    private static final int BUFFER_SIZE = 4096;
    private final File file;
    private final Map<Path, FileSystem> filesystems = new HashMap<Path, FileSystem>();

    public Zip(File file) {
        this.file = file;
    }

    public Zip create() throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.file));
        zipOutputStream.close();
        return this;
    }

    public List<String> entries() throws IOException {
        ZipFile zipFile = new ZipFile(this.file);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        ArrayList<String> entries = new ArrayList<String>();
        while (zipEntries.hasMoreElements()) {
            entries.add(zipEntries.nextElement().getName());
        }
        zipFile.close();
        return entries;
    }

    public boolean exists(String filePath) throws IOException {
        ZipFile zipFile = new ZipFile(this.file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (!filePath.equals(ze.getName())) continue;
            zipFile.close();
            return true;
        }
        zipFile.close();
        return false;
    }

    public String read(String filePath) throws IOException {
        ZipFile zipFile = new ZipFile(this.file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!filePath.equals(entry.getName())) continue;
            String text = new String(zipFile.getInputStream(entry).readAllBytes(), StandardCharsets.UTF_8);
            zipFile.close();
            return text;
        }
        zipFile.close();
        return null;
    }

    public void write(String filePath, String value, StandardOpenOption ... options) throws IOException {
        Path path;
        if (!this.file.exists()) {
            this.create();
        }
        if (!this.filesystems.containsKey(path = Paths.get(this.file.getAbsolutePath(), new String[0]).toRealPath(new LinkOption[0])) || !this.filesystems.get(path).isOpen()) {
            this.filesystems.put(path, Zip.newFileSystem(path));
        }
        try (FileSystem fs = this.filesystems.get(path);){
            Path parent = fs.getPath(filePath, new String[0]).getParent();
            if (parent != null && Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(fs.getPath(filePath, new String[0]), options);){
                writer.write(value);
            }
        }
    }

    public void write(Map<String, String> entries) throws IOException {
        if (!this.file.exists()) {
            this.create();
        }
        FileOutputStream fos = new FileOutputStream(this.file);
        ZipOutputStream zos = new ZipOutputStream(fos);
        entries.forEach((key, value) -> {
            try {
                zos.putNextEntry(new ZipEntry((String)key));
                zos.write(value.getBytes());
                zos.closeEntry();
            }
            catch (IOException e) {
                Logger.error(e);
            }
        });
        zos.close();
    }

    public void write(String filePath, InputStream stream, StandardOpenOption ... options) throws IOException {
        Path path;
        if (!this.file.exists()) {
            this.create();
        }
        if (!this.filesystems.containsKey(path = Paths.get(this.file.getAbsolutePath(), new String[0]).toRealPath(new LinkOption[0])) || !this.filesystems.get(path).isOpen()) {
            this.filesystems.put(path, Zip.newFileSystem(path));
        }
        try (FileSystem fs = this.filesystems.get(path);){
            Path parent = fs.getPath(filePath, new String[0]).getParent();
            if (parent != null && Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(fs.getPath(filePath, new String[0]), stream.readAllBytes(), (OpenOption[])options);
        }
        stream.close();
    }

    public void unzip(String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zin = new ZipInputStream(new FileInputStream(this.file));
        Zip.unzip(zin, destDirectory);
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public static void unzip(ZipInputStream zin, String destDirectory) throws IOException {
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                Zip.extractFile(zin, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zin.closeEntry();
            entry = zin.getNextEntry();
        }
        zin.close();
    }

    public static InputStream read(ZipFile zipFile, String filePath) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!filePath.equals(entry.getName())) continue;
            return zipFile.getInputStream(entry);
        }
        return null;
    }

    private static FileSystem newFileSystem(Path path) throws IOException {
        return FileSystems.newFileSystem(URI.create("jar:" + path.toUri()), Collections.singletonMap("create", "true"), ClassLoader.getSystemClassLoader());
    }
}

