/*
 * Decompiled with CFR 0.152.
 */
package io.intino;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Configuration {
    default public Configuration init() {
        return null;
    }

    default public boolean isSuitable() {
        return false;
    }

    default public boolean isReloading() {
        return false;
    }

    default public void reload() {
    }

    public Artifact artifact();

    public List<Server> servers();

    public List<RunConfiguration> runConfigurations();

    public List<Repository> repositories();

    public static interface Parameter
    extends ConfigurationNode {
        public String name();

        public String value();

        public String description();
    }

    public static interface ConfigurationNode {
        public Configuration root();

        public ConfigurationNode owner();
    }

    public static interface Server {
        public String name();

        public Type type();

        public static enum Type {
            Dev,
            Pre,
            Pro,
            Demo;

        }
    }

    public static interface Repository
    extends ConfigurationNode {
        public String identifier();

        public String url();

        public String user();

        public String password();

        public UpdatePolicy updatePolicy();

        public static interface Snapshot
        extends Repository {
        }

        public static interface Release
        extends Repository {
        }

        public static enum UpdatePolicy {
            Always,
            Daily,
            Never;

        }
    }

    public static interface RunConfiguration
    extends ConfigurationNode {
        public String name();

        public String mainClass();

        public String vmOptions();

        public List<Argument> arguments();

        default public Map<String, String> finalArguments() {
            HashMap<String, String> arguments = new HashMap<String, String>();
            this.arguments().forEach(a -> arguments.put(a.name(), a.value()));
            Artifact artifact = this.root().artifact();
            artifact.parameters().stream().filter(p -> !arguments.containsKey(p.name())).filter(p -> p.value() != null).forEach(p -> arguments.put(p.name(), p.value()));
            return arguments;
        }

        public static interface Argument
        extends Parameter {
            @Override
            public String name();

            @Override
            public String value();

            @Override
            default public String description() {
                return "";
            }
        }
    }

    public static interface WebDependency {
    }

    public static interface Deployment {
        public Server server();

        public RunConfiguration runConfiguration();

        public List<String> bugTrackingUsers();

        public Requirements requirements();

        public static interface Requirements {
            public int minHdd();

            public int minMemory();

            public int maxMemory();

            public String jvmVersion();

            public Sync sync();

            public static interface Sync {
                public Map<String, String> moduleServer();
            }
        }
    }

    public static interface Distribution {
        public Repository release();

        public Repository snapshot();

        public BitBucketDistribution onBitbucket();

        public boolean distributeLanguage();

        public static interface BitBucketDistribution {
            public String owner();

            public String slugName();
        }
    }

    public static interface Artifact
    extends ConfigurationNode {
        public String groupId();

        public String name();

        public void name(String var1);

        public String version();

        public String description();

        public String url();

        public void version(String var1);

        public Code code();

        public Model model();

        public Box box();

        public Dependency.DataHub datahub();

        public Dependency.Archetype archetype();

        public List<Dependency> dependencies();

        public List<WebComponent> webComponents();

        public List<WebResolution> webResolutions();

        public List<WebArtifact> webArtifacts();

        public List<Plugin> plugins();

        public License license();

        public Scm scm();

        public List<Developer> developers();

        public QualityAnalytics qualityAnalytics();

        public List<Parameter> parameters();

        public Package packageConfiguration();

        public Distribution distribution();

        default public List<Deployment> deployments() {
            return Collections.emptyList();
        }

        public static interface Scm {
            public String url();

            public String connection();

            public String developerConnection();

            public String tag();
        }

        public static interface Package {
            public LinuxService linuxService();

            public Mode mode();

            public boolean isRunnable();

            public boolean createMavenPom();

            public boolean attachSources();

            public List<String> mavenPlugins();

            public boolean attachDoc();

            public boolean includeTests();

            public boolean signArtifactWithGpg();

            public String classpathPrefix();

            public String finalName();

            public String defaultJVMOptions();

            public String mainClass();

            public MacOs macOsConfiguration();

            public Windows windowsConfiguration();

            public static interface LinuxService {
                public String user();

                public RunConfiguration runConfiguration();

                public boolean restartOnFailure();

                public int managementPort();
            }

            public static interface Windows {
                public String icon();
            }

            public static interface MacOs {
                public String icon();

                public String resourceDirectory();
            }

            public static enum Mode {
                ModulesAndLibrariesExtracted,
                LibrariesLinkedByManifest,
                ModulesAndLibrariesLinkedByManifest;

            }
        }

        public static interface Plugin {
            public String artifact();

            public String pluginClass();

            default public Phase phase() {
                return Phase.PrePackage;
            }

            public static enum Phase {
                Export,
                PostCompilation,
                PrePackage,
                PostPackage,
                PostDistribution;

            }
        }

        public static interface WebArtifact {
            public String name();

            default public String identifier() {
                return this.groupId() + ":" + this.artifactId() + ":" + this.version();
            }

            public String groupId();

            public String artifactId();

            public String version();
        }

        public static interface WebResolution {
            public String name();

            public String version();
        }

        public static interface WebComponent {
            public String name();

            public String version();
        }

        public static interface Developer {
            public String name();

            public String email();

            public String organization();

            public String organizationUrl();
        }

        public static interface License {
            public LicenseType type();

            public static enum LicenseType {
                GLP,
                BSD,
                LGPL;

            }
        }

        public static interface Dependency {
            default public String identifier() {
                return this.groupId() + ":" + this.artifactId() + ":" + this.version();
            }

            default public String name() {
                return "Intino: " + this.identifier();
            }

            public String groupId();

            public String artifactId();

            public String version();

            public void version(String var1);

            public String scope();

            public List<Exclude> excludes();

            public String effectiveVersion();

            public void effectiveVersion(String var1);

            public boolean transitive();

            public boolean resolved();

            public void resolved(boolean var1);

            public boolean toModule();

            public void toModule(boolean var1);

            public static interface Web
            extends Dependency {
            }

            public static interface Archetype
            extends Dependency {
            }

            public static interface DataHub
            extends Dependency {
            }

            public static interface Provided
            extends Dependency {
            }

            public static interface Runtime
            extends Dependency {
            }

            public static interface Test
            extends Dependency {
            }

            public static interface Compile
            extends Dependency {
            }

            public static interface Exclude {
                public String groupId();

                public String artifactId();
            }
        }

        public static interface Box
        extends ConfigurationNode {
            public String language();

            public String version();

            public String effectiveVersion();

            public void effectiveVersion(String var1);

            public String targetPackage();
        }

        public static interface Code
        extends ConfigurationNode {
            public String generationPackage();

            default public String webDirectory() {
                return "lib";
            }

            default public String modelPackage() {
                return "model";
            }

            default public String boxPackage() {
                return "box";
            }

            public String nativeLanguage();
        }

        public static interface Model
        extends ConfigurationNode {
            public Language language();

            public String outLanguage();

            public String outLanguageVersion();

            public Level level();

            public String sdkVersion();

            public String sdk();

            public List<ExcludedPhases> excludedPhases();

            public static interface Language {
                public String name();

                public String version();

                public String effectiveVersion();

                public void effectiveVersion(String var1);

                public void version(String var1);

                public String generationPackage();
            }

            public static enum ExcludedPhases {
                ExcludeFrameworkCode,
                ExcludeLanguageCode;

            }

            public static enum Level {
                Solution,
                Product,
                Platform;


                public int compareLevelWith(Level type) {
                    return type.ordinal() - this.ordinal();
                }

                public boolean is(Level type, int level) {
                    return type.ordinal() == level;
                }

                public boolean isSolution() {
                    return Solution.equals((Object)this);
                }

                public boolean isProduct() {
                    return Product.equals((Object)this);
                }

                public boolean isPlatform() {
                    return Platform.equals((Object)this);
                }
            }
        }

        public static interface QualityAnalytics {
            public String url();

            public String token();
        }
    }
}

