/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio2packagejson;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.jcabi.aether.Aether;
import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zip.Zip;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class WebArtifactResolver {
    public static final String MAVEN_URL = "https://repo1.maven.org/maven2/";
    private final Configuration.Artifact artifact;
    private final List<Configuration.Repository> repositories;
    private final Map<String, Map.Entry<String, String>> credentials;
    private final File destination;

    public WebArtifactResolver(Configuration.Artifact artifact, List<Configuration.Repository> repositories, Map<String, Map.Entry<String, String>> credentials, File destination) {
        this.artifact = artifact;
        this.repositories = repositories;
        this.credentials = credentials;
        this.destination = destination;
    }

    public List<JsonObject> resolveArtifacts() {
        ArrayList<JsonObject> manifests = new ArrayList<JsonObject>();
        Aether aether = new Aether(this.collectRemotes(), new File(System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository"));
        for (Configuration.Artifact.WebArtifact artifact : this.artifact.webArtifacts()) {
            JsonObject jsonObject;
            File packageJson;
            List<Artifact> artifacts;
            if (this.isOverriding(artifact) || (artifacts = this.resolve(aether, artifact)).isEmpty() || (packageJson = this.extract(artifact, artifacts.get(0).getFile())) == null || (jsonObject = this.readPackageJson(packageJson)) == null) continue;
            jsonObject.addProperty("name", artifact.artifactId());
            manifests.add(jsonObject);
            this.write(jsonObject.toString(), packageJson);
        }
        return manifests;
    }

    public void extractArtifacts() {
        Aether aether = new Aether(this.collectRemotes(), new File(System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository"));
        for (Configuration.Artifact.WebArtifact artifact : this.artifact.webArtifacts()) {
            JsonObject jsonObject;
            File packageJson;
            List<Artifact> artifacts;
            if (this.isOverriding(artifact) || (artifacts = this.resolve(aether, artifact)).isEmpty() || (packageJson = this.extract(artifact, artifacts.get(0).getFile())) == null || (jsonObject = this.readPackageJson(packageJson)) == null) continue;
            jsonObject.addProperty("name", artifact.artifactId());
            this.write(jsonObject.toString(), packageJson);
        }
    }

    private boolean isOverriding(Configuration.Artifact.WebArtifact artifact) {
        File file = new File(this.destination, artifact.artifactId() + File.separator + "package.json");
        if (!file.exists()) {
            return false;
        }
        try {
            JsonObject element = this.readJson(file);
            return artifact.version().equals(element.get("version").getAsString());
        }
        catch (IOException e) {
            return false;
        }
    }

    private File extract(Configuration.Artifact.WebArtifact artifact, File jarFile) {
        try {
            File outputDir = new File(this.destination, artifact.name().toLowerCase());
            Zip.unzip((ZipInputStream)new ZipInputStream(new FileInputStream(jarFile)), (String)outputDir.getAbsolutePath());
            Files.delete(new File(outputDir, "META-INF").toPath());
            return new File(outputDir, "package.json");
        }
        catch (IOException e) {
            Logger.error((String)"Error extracting widgets", (Throwable)e);
            return null;
        }
    }

    private List<Artifact> resolve(Aether aether, Configuration.Artifact.WebArtifact artifact) {
        try {
            return aether.resolve((Artifact)new DefaultArtifact(artifact.groupId().toLowerCase(), artifact.artifactId().toLowerCase(), "sources", "jar", artifact.version()), "compile");
        }
        catch (DependencyResolutionException e) {
            Logger.warn((String)"Error resolving widgets");
            return Collections.emptyList();
        }
    }

    private JsonObject readPackageJson(File file) {
        try {
            return this.readJson(file);
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private JsonObject readJson(File file) throws IOException {
        return (JsonObject)new Gson().fromJson(new String(Files.readAllBytes(file.toPath())), JsonObject.class);
    }

    private Collection<RemoteRepository> collectRemotes() {
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
        remotes.add(new RemoteRepository("maven-central", "default", MAVEN_URL).setPolicy(false, new RepositoryPolicy().setEnabled(true).setUpdatePolicy("daily")));
        remotes.addAll(this.repositories.stream().map(this::repository).toList());
        return remotes;
    }

    private RemoteRepository repository(Configuration.Repository r) {
        RemoteRepository repository = new RemoteRepository(r.identifier(), "default", r.url()).setAuthentication(this.provideAuthentication(r.identifier()));
        if (r instanceof Configuration.Repository.Snapshot) {
            repository.setPolicy(true, new RepositoryPolicy().setEnabled(true).setUpdatePolicy("always"));
            repository.setPolicy(false, new RepositoryPolicy().setEnabled(false));
        } else {
            repository.setPolicy(true, new RepositoryPolicy().setEnabled(false).setUpdatePolicy("always"));
            repository.setPolicy(false, new RepositoryPolicy().setEnabled(true).setUpdatePolicy("daily"));
        }
        return repository;
    }

    private Authentication provideAuthentication(String mavenId) {
        Map.Entry<String, String> entry = this.credentials.get(mavenId);
        return entry != null ? new Authentication(entry.getKey(), entry.getValue()) : null;
    }

    private void write(String content, File destiny) {
        try {
            Files.writeString(destiny.toPath(), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
        }
    }
}

