/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio2packagejson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.legio2packagejson.Package_jsonTemplate;
import io.intino.legio2packagejson.WebArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;

public class PackageJsonCreator {
    private final Configuration.Artifact artifact;
    private final List<Configuration.Artifact.WebComponent> webComponents;
    private final List<Configuration.Artifact.WebResolution> resolutions;
    private final WebArtifactResolver webArtifactResolver;
    private Map<String, Map.Entry<String, String>> credentials;

    public PackageJsonCreator(Configuration conf, File credentialsFile, File destination) {
        this.artifact = conf.artifact();
        this.webComponents = this.artifact.webComponents();
        this.resolutions = this.artifact.webResolutions();
        this.loadCredentials(credentialsFile);
        this.webArtifactResolver = new WebArtifactResolver(this.artifact, conf.repositories(), this.credentials, destination);
    }

    public void createPackageFile(File rootDirectory) {
        this.write(new Package_jsonTemplate().render(this.packageFrame().toFrame()), new File(rootDirectory, "package.json"));
    }

    public void extractArtifacts() {
        if (SystemUtils.IS_OS_WINDOWS) {
            this.webArtifactResolver.extractArtifacts();
        }
    }

    private FrameBuilder packageFrame() {
        List<JsonObject> packages = this.webArtifactResolver.resolveArtifacts();
        FrameBuilder builder = this.baseFrame().add("package");
        if (SystemUtils.IS_OS_MAC_OSX) {
            builder.add("fsevents", (Object)"");
        }
        Map<String, String> dependencies = this.collectDependencies(packages);
        dependencies.forEach((key, value) -> builder.add("dependency", (Object)new FrameBuilder().add("name", key).add("version", value)));
        this.resolutions.forEach(resolution -> builder.add("resolution", (Object)this.resolutionFrameFrom((Configuration.Artifact.WebResolution)resolution)));
        packages.stream().map(this::resolutionFrameFrom).filter(Objects::nonNull).forEach(frames -> builder.add("resolution", frames));
        return builder;
    }

    private Map<String, String> collectDependencies(List<JsonObject> packages) {
        LinkedHashMap<String, String> dependencies = new LinkedHashMap<String, String>();
        this.webComponents.forEach(c -> dependencies.putIfAbsent(c.name(), c.version()));
        packages.forEach(p -> this.dependenciesFrom((JsonObject)p).forEach(dependencies::putIfAbsent));
        return dependencies;
    }

    private FrameBuilder baseFrame() {
        return new FrameBuilder().add("groupId", (Object)this.artifact.groupId()).add("artifactId", (Object)this.artifact.name()).add("version", (Object)this.artifact.version());
    }

    private Frame[] resolutionFrameFrom(JsonObject object) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        if (object.get("resolutions") == null) {
            return null;
        }
        JsonObject dependencies = object.get("resolutions").getAsJsonObject();
        for (Map.Entry entry : dependencies.entrySet()) {
            frames.add(new FrameBuilder().add("name", entry.getKey()).add("version", (Object)((JsonElement)entry.getValue()).toString().replaceAll("\"", "")).toFrame());
        }
        return frames.toArray(new Frame[0]);
    }

    private Frame resolutionFrameFrom(Configuration.Artifact.WebResolution resolution) {
        return new FrameBuilder().add("name", (Object)resolution.name()).add("version", (Object)resolution.version()).toFrame();
    }

    private Map<String, String> dependenciesFrom(JsonObject object) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (object.get("dependencies") == null) {
            return map;
        }
        JsonObject dependencies = object.get("dependencies").getAsJsonObject();
        for (Map.Entry entry : dependencies.entrySet()) {
            map.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        return map;
    }

    private void write(String content, File destiny) {
        try {
            Files.writeString(destiny.toPath(), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private void loadCredentials(File credentialsFile) {
        try (Stream<String> lines = Files.lines(credentialsFile.toPath());){
            this.credentials = lines.map(l -> l.split("\t")).collect(Collectors.toMap(f -> f[0], f -> new AbstractMap.SimpleEntry<String, String>(f[1], f[2])));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            this.credentials = new HashMap<String, Map.Entry<String, String>>();
        }
    }
}

