/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.parsing;

import io.intino.tara.Source;
import io.intino.tara.language.grammar.SyntaxException;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.grammar.TaraLexer;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.parser.GrammarErrorListener;
import io.intino.tara.processors.parser.antlr.ConstraintsModelGenerator;
import io.intino.tara.processors.parser.antlr.ModelGenerator;
import io.intino.tara.processors.parser.antlr.TaraErrorStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Parser {
    private static final Logger LOG = Logger.getGlobal();
    private final Source source;
    private final DefaultErrorStrategy errorHandler;

    public Parser(Source source, DefaultErrorStrategy errorStrategy) {
        this.source = source;
        this.errorHandler = errorStrategy;
    }

    public Parser(Source source) {
        this.source = source;
        this.errorHandler = new TaraErrorStrategy();
    }

    public CommonTokenStream tokens() throws SyntaxException {
        CommonTokenStream commonTokenStream;
        block9: {
            InputStream content = this.source.content();
            try {
                TaraLexer lexer = new TaraLexer((CharStream)CharStreams.fromString((String)new String(content.readAllBytes(), this.source.charset()), (String)this.source.uri().getPath()));
                lexer.reset();
                commonTokenStream = new CommonTokenStream((TokenSource)lexer);
                if (content == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage());
                    return null;
                }
                catch (RecognitionException e) {
                    this.throwError(e);
                    return null;
                }
            }
            content.close();
        }
        return commonTokenStream;
    }

    public TaraGrammar.RootContext parse(CommonTokenStream tokens) throws SyntaxException {
        try {
            TaraGrammar grammar = new TaraGrammar((TokenStream)tokens);
            grammar.setErrorHandler((ANTLRErrorStrategy)this.errorHandler);
            grammar.addErrorListener((ANTLRErrorListener)new GrammarErrorListener());
            return grammar.root();
        }
        catch (RecognitionException e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            this.throwError(e);
            return null;
        }
    }

    public Model convert(TaraGrammar.RootContext rootContext) throws SyntaxException {
        try {
            ParseTreeWalker walker = new ParseTreeWalker();
            ModelGenerator extractor = new ModelGenerator(this.source);
            walker.walk((ParseTreeListener)extractor, (ParseTree)rootContext);
            if (!extractor.getErrors().isEmpty()) {
                throw (SyntaxException)extractor.getErrors().get(0);
            }
            Model model = extractor.getModel();
            ConstraintsModelGenerator constraintsGenerator = new ConstraintsModelGenerator(this.source, rootContext);
            model.constraints(constraintsGenerator.walk());
            if (!constraintsGenerator.errors().isEmpty()) {
                throw (SyntaxException)constraintsGenerator.errors().get(0);
            }
            return model;
        }
        catch (RecognitionException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            return this.throwError(e);
        }
    }

    private Model throwError(RecognitionException e) throws SyntaxException {
        org.antlr.v4.runtime.Parser recognizer = (org.antlr.v4.runtime.Parser)e.getRecognizer();
        Token token = recognizer.getCurrentToken();
        throw new SyntaxException("Syntax error in " + String.valueOf(this.source.uri()), this.source.uri(), token.getLine(), token.getCharPositionInLine(), this.getExpectedTokens(recognizer));
    }

    private String getExpectedTokens(org.antlr.v4.runtime.Parser recognizer) {
        try {
            return recognizer.getExpectedTokens().toString(recognizer.getVocabulary());
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            return "";
        }
    }
}

