/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.fix;

import io.intino.ls.codeinsight.DiagnosticContextInfo;
import io.intino.ls.codeinsight.fix.AddMetricFix;
import io.intino.ls.codeinsight.fix.AddRequiredElementFix;
import io.intino.ls.codeinsight.fix.AddRequiredFacetFix;
import io.intino.ls.codeinsight.fix.AddRequiredParameterFix;
import io.intino.ls.codeinsight.fix.RemoveElementFix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.CodeAction;

public class FixFactory {
    private static final Map<String, Builder[]> fixes = new HashMap<String, Builder[]>();

    private static Builder removeElementFix() {
        return new Builder(){

            public RemoveElementFix build(DiagnosticContextInfo info) {
                return new RemoveElementFix(info);
            }
        };
    }

    private static Builder addRequieredFacetFix() {
        return new Builder(){

            public AddRequiredFacetFix build(DiagnosticContextInfo info) {
                return new AddRequiredFacetFix(info);
            }
        };
    }

    private static Builder addRequiredElementFix() {
        return new Builder(){

            public AddRequiredElementFix build(DiagnosticContextInfo info) {
                return new AddRequiredElementFix(info);
            }
        };
    }

    private static Builder addRequiredParameterFix() {
        return new Builder(){

            public AddRequiredParameterFix build(DiagnosticContextInfo info) {
                return new AddRequiredParameterFix(info);
            }
        };
    }

    private static Builder addMetricFix() {
        return new Builder(){

            public AddMetricFix build(DiagnosticContextInfo info) {
                return new AddMetricFix(info);
            }
        };
    }

    private FixFactory() {
    }

    public static List<CodeAction> get(DiagnosticContextInfo info) {
        Builder[] builders = fixes.get(info.code());
        return builders == null ? List.of() : FixFactory.instanceFixes(builders, info);
    }

    private static List<CodeAction> instanceFixes(Builder[] builders, DiagnosticContextInfo info) {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        for (Builder builder : builders) {
            actions.add((CodeAction)builder.build(info));
        }
        return actions;
    }

    static {
        fixes.put("reject.type.not.exists", new Builder[]{FixFactory.removeElementFix()});
        fixes.put("required.parameter.in.context", new Builder[]{FixFactory.addRequiredParameterFix()});
        fixes.put("required.type.in.context", new Builder[]{FixFactory.addRequiredElementFix()});
        fixes.put("reject.instance.reference.variable", new Builder[]{FixFactory.removeElementFix()});
        fixes.put("reject.duplicate.variable", new Builder[]{FixFactory.removeElementFix()});
        fixes.put("reject.duplicate.entries", new Builder[]{FixFactory.removeElementFix()});
        fixes.put("reject.duplicated.facet", new Builder[]{FixFactory.removeElementFix()});
        fixes.put("reject.sub.of.instance", new Builder[]{FixFactory.removeElementFix()});
        fixes.put("reject.other.parameter.in.context", new Builder[]{FixFactory.removeElementFix()});
        fixes.put("reject.number.parameter.with.erroneous.metric", new Builder[]{FixFactory.addMetricFix()});
        fixes.put("reject.node.with.required.aspect.not.found", new Builder[]{FixFactory.addRequieredFacetFix()});
    }

    private static interface Builder<T extends CodeAction> {
        public <T extends CodeAction> T build(DiagnosticContextInfo var1);
    }
}

