/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls;

import io.intino.alexandria.logger.Logger;
import io.intino.ls.DocumentHelper;
import io.intino.ls.IntinoSemanticTokens;
import io.intino.ls.ModelUnit;
import io.intino.ls.codeinsight.DiagnosticContextInfo;
import io.intino.ls.codeinsight.DiagnosticService;
import io.intino.ls.codeinsight.ReferenceResolver;
import io.intino.ls.codeinsight.completion.CompletionContext;
import io.intino.ls.codeinsight.completion.CompletionService;
import io.intino.ls.codeinsight.completion.TreeUtils;
import io.intino.ls.codeinsight.fix.FixFactory;
import io.intino.ls.document.DocumentManager;
import io.intino.ls.document.DocumentSourceProvider;
import io.intino.ls.parsing.ParsingService;
import io.intino.tara.Language;
import io.intino.tara.Source;
import io.intino.tara.language.grammar.HighlightTaraLexer;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Element;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.rules.Size;
import io.intino.tara.model.rules.property.ReferenceRule;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DeclarationParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentDiagnosticParams;
import org.eclipse.lsp4j.DocumentDiagnosticReport;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.InlineValue;
import org.eclipse.lsp4j.InlineValueParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RelatedFullDocumentDiagnosticReport;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.TextDocumentService;

public class IntinoDocumentService
implements TextDocumentService {
    private final Language language;
    private final DocumentManager workspaceManager;
    private final DocumentSourceProvider documentSourceProvider;
    private final DiagnosticService diagnosticService;
    private final Map<URI, ModelUnit> models;
    private final AtomicReference<LanguageClient> client;
    private final ParsingService parsingService;
    private final CompletionService completionService;
    private final List<Consumer<URI>> changeListener = new ArrayList<Consumer<URI>>();

    public IntinoDocumentService(Language language, DocumentManager documentManager, DiagnosticService diagnosticService, Map<URI, ModelUnit> models, AtomicReference<LanguageClient> client) {
        this.language = language;
        this.workspaceManager = documentManager;
        this.documentSourceProvider = new DocumentSourceProvider(documentManager);
        this.diagnosticService = diagnosticService;
        this.parsingService = new ParsingService(models);
        this.completionService = new CompletionService(language, models);
        this.models = models;
        this.client = client;
        this.loadModels();
        documentManager.onChange((FileEvent e) -> {
            if (e.getType().equals((Object)FileChangeType.Deleted)) {
                models.remove(URI.create(IntinoDocumentService.normalize(e.getUri())));
            } else if (e.getType().equals((Object)FileChangeType.Created)) {
                this.didCreate((FileEvent)e);
            }
        });
    }

    private void didCreate(FileEvent e) {
        try {
            URI uri = URI.create(IntinoDocumentService.normalize(e.getUri()));
            String content = new String(this.workspaceManager.getDocumentText(uri).readAllBytes());
            this.parsingService.updateModel((Source)new Source.StringSource(uri.getPath(), content));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onChange(Consumer<URI> listener) {
        this.changeListener.add(listener);
    }

    private void loadModels() {
        this.documentSourceProvider.all().filter(s -> DocumentHelper.isTaraModel(s.uri().getPath())).forEach(u -> {
            try {
                this.parsingService.updateModel((Source)new Source.StringSource(u.uri().getPath(), new String(u.content().readAllBytes())));
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        });
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
        this.parsingService.updateModel((Source)new Source.StringSource(uri.getPath(), params.getTextDocument().getText()));
        this.notifyDiagnostics(uri, params.getTextDocument().getVersion());
    }

    public void didChange(DidChangeTextDocumentParams params) {
        try {
            URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
            InputStream doc = this.workspaceManager.getDocumentText(uri);
            Object content = this.applyChanges(doc != null ? new String(doc.readAllBytes()) : "", params.getContentChanges());
            if (((String)content).isEmpty()) {
                content = "dsl " + this.language.languageName() + "\n\n";
            }
            this.workspaceManager.upsertDocument(uri, this.language.languageName(), (String)(content == null ? "" : content));
            this.parsingService.updateModel((Source)new Source.StringSource(uri.getPath(), (String)content));
            this.notifyDiagnostics(uri, params.getTextDocument().getVersion());
            if (this.changeListener != null) {
                this.changeListener.forEach(l -> l.accept(uri));
            }
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }

    private void notifyDiagnostics(URI uri, int version) {
        List<Diagnostic> diagnostics = this.diagnosticService.analyzeWorkspace().stream().filter(d -> d.getSource().equals(uri.getPath())).toList();
        this.client.get().publishDiagnostics(new PublishDiagnosticsParams(uri.getPath(), diagnostics, Integer.valueOf(version)));
    }

    public void didClose(DidCloseTextDocumentParams params) {
    }

    public void didSave(DidSaveTextDocumentParams params) {
        String uri = IntinoDocumentService.normalize(params.getTextDocument().getUri());
        this.workspaceManager.upsertDocument(URI.create(uri), this.language.languageName(), params.getText());
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
        ModelUnit modelUnit = this.models.get(uri);
        if (modelUnit == null) {
            CompletableFuture.completedFuture(List.of());
        }
        return CompletableFuture.completedFuture(IntinoDocumentService.ranges(modelUnit));
    }

    private static List<FoldingRange> ranges(ModelUnit modelUnit) {
        ArrayList<FoldingRange> ranges = new ArrayList<FoldingRange>();
        if (modelUnit == null || modelUnit.model() == null) {
            return ranges;
        }
        List mograms = modelUnit.model().mograms();
        IntinoDocumentService.append(mograms, ranges);
        return ranges.stream().filter(r -> r != null).toList();
    }

    private static void append(List<Mogram> mograms, List<FoldingRange> ranges) {
        for (Mogram mogram : mograms) {
            ranges.add(IntinoDocumentService.range(mogram));
            IntinoDocumentService.append(mogram.mograms(), ranges);
        }
    }

    private static FoldingRange range(Mogram m) {
        if (m.textRange().startLine() == m.textRange().endLine() || m.elements().isEmpty()) {
            return null;
        }
        FoldingRange foldingRange = new FoldingRange(m.textRange().startLine() - 1, m.textRange().endLine() - 1);
        foldingRange.setKind("region");
        return foldingRange;
    }

    private String applyChanges(String content, List<TextDocumentContentChangeEvent> contentChanges) {
        StringBuilder sb = new StringBuilder(content);
        for (TextDocumentContentChangeEvent change : contentChanges) {
            if (change.getRange() != null) {
                int startOffset = this.getOffset(change.getRange().getStart(), content);
                int endOffset = this.getOffset(change.getRange().getEnd(), content);
                sb.replace(startOffset, endOffset, change.getText());
                continue;
            }
            sb = new StringBuilder(change.getText());
        }
        return sb.toString();
    }

    public CompletableFuture<DocumentDiagnosticReport> diagnostic(DocumentDiagnosticParams params) {
        try {
            return CompletableFuture.completedFuture(new DocumentDiagnosticReport(new RelatedFullDocumentDiagnosticReport(this.diagnosticService.analyzeWorkspace())));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private int getOffset(Position position, String content) {
        int offset = 0;
        int line = 0;
        int column = 0;
        for (char c : content.toCharArray()) {
            if (line == position.getLine() && column == position.getCharacter()) break;
            if (c == '\n') {
                ++line;
                column = 0;
            } else {
                ++column;
            }
            ++offset;
        }
        return offset;
    }

    public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
        try {
            String uri = params.getTextDocument().getUri();
            if (uri == null) {
                Logger.error((String)("Semantic tokens URI is null: " + params.getTextDocument().getUri()));
                return CompletableFuture.completedFuture(null);
            }
            SemanticTokens tokens = this.semanticTokens(URI.create(IntinoDocumentService.normalize(uri)));
            return CompletableFuture.completedFuture(tokens);
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return CompletableFuture.completedFuture(new SemanticTokens());
        }
    }

    private SemanticTokens semanticTokens(URI uri) throws IOException {
        ArrayList<IntinoSemanticTokens.SemanticToken> tokens = new ArrayList<IntinoSemanticTokens.SemanticToken>();
        try {
            HighlightTaraLexer lexer = new HighlightTaraLexer((CharStream)CharStreams.fromString((String)new String(this.workspaceManager.getDocumentText(uri).readAllBytes()), (String)uri.getPath()));
            lexer.reset();
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            tokenStream.fill();
            tokens.addAll(new IntinoSemanticTokens(List.of(this.language.lexicon())).semanticTokens(tokenStream));
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
        return new SemanticTokens(tokens.stream().flatMap(s -> s.raw().stream()).toList());
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
        String textDoc = this.contentOf(uri);
        Source.StringSource source = new Source.StringSource("model", textDoc);
        CompletionContext context = CompletionService.completionContextOf(params, this.language, source);
        if (context == null) {
            return CompletableFuture.completedFuture(Either.forRight((Object)new CompletionList()));
        }
        List<CompletionItem> items = this.completionService.propose(context);
        return CompletableFuture.completedFuture(Either.forRight((Object)new CompletionList(false, items)));
    }

    private String contentOf(URI uri) {
        try {
            return new String(this.workspaceManager.getDocumentText(uri).readAllBytes());
        }
        catch (IOException e) {
            return null;
        }
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        return CompletableFuture.completedFuture(new Hover());
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
        ModelUnit modelUnit = this.models.get(uri);
        Position position = IntinoDocumentService.fixPosition(params.getPosition());
        Token token = TreeUtils.findToken(modelUnit.tokens(), position.getLine(), position.getCharacter());
        ParserRuleContext ctx = token == null ? null : TreeUtils.findRuleContainingToken((ParserRuleContext)modelUnit.tree(), token);
        Mogram container = TreeUtils.getMogramContainerOn(modelUnit.model(), position);
        String facet = this.facet(params, container, ctx);
        List constraints = this.language.constraints((String)container.types().getFirst());
        return CompletableFuture.completedFuture(this.map(facet == null ? (String)container.types().getFirst() : facet, this.collectParameterConstraints(constraints, facet)));
    }

    private SignatureHelp map(String mogram, List<Constraint.Property> constraints) {
        SignatureInformation information = new SignatureInformation(mogram);
        information.setParameters(constraints.stream().map(c -> new ParameterInformation(c.name(), this.parameterInfo((Constraint.Property)c))).toList());
        information.setActiveParameter(Integer.valueOf(0));
        SignatureHelp help = new SignatureHelp(List.of(information), Integer.valueOf(0), Integer.valueOf(0));
        return help;
    }

    private String parameterInfo(Constraint.Property constraint) {
        return Primitive.REFERENCE.equals((Object)constraint.type()) ? this.asReferenceParameter(constraint) : this.asWordParameter(constraint);
    }

    private String asWordParameter(Constraint.Property constraint) {
        return constraint.type().getName().toLowerCase() + this.size(constraint) + constraint.name();
    }

    private String asReferenceParameter(Constraint.Property constraint) {
        return this.referenceTypes(constraint) + this.size(constraint) + constraint.name();
    }

    private String referenceTypes(Constraint.Property constraint) {
        ReferenceRule rule = (ReferenceRule)constraint.rule(ReferenceRule.class);
        if (rule == null) {
            return "Reference";
        }
        return rule.allowedReferences().size() > 1 ? "{" + String.join((CharSequence)", ", rule.allowedReferences()) + "}" : (String)rule.allowedReferences().getFirst();
    }

    private String size(Constraint.Property constraint) {
        Size size = (Size)constraint.rule(Size.class);
        return "[" + size.min() + ".." + String.valueOf(size.max() == Integer.MAX_VALUE ? "*" : Integer.valueOf(size.max())) + "] ";
    }

    private List<Constraint.Property> collectParameterConstraints(List<Constraint> coreConstraints, String facet) {
        List<Constraint> scopeConstraints = coreConstraints;
        if (facet != null) {
            scopeConstraints = this.collectFacetParameterConstraints(coreConstraints, facet);
        }
        return scopeConstraints == null ? List.of() : scopeConstraints.stream().filter(constraint -> constraint instanceof Constraint.Property).map(constraint -> (Constraint.Property)constraint).toList();
    }

    private String facet(SignatureHelpParams params, Mogram container, ParserRuleContext ctx) {
        TaraGrammar.FacetContext facetContext = TreeUtils.contextByType(ctx, TaraGrammar.FacetContext.class);
        if (facetContext == null) {
            return null;
        }
        String facetType = facetContext.metaidentifier().getText();
        return container.appliedFacets().stream().filter(f -> f.type().equals(facetType)).map(f -> f.fullType()).findFirst().orElse(null);
    }

    private List<Constraint> collectFacetParameterConstraints(List<Constraint> constraints, String type) {
        return constraints.stream().filter(c -> c instanceof Constraint.Facet && ((Constraint.Facet)c).type().equals(type)).map(c -> ((Constraint.Facet)c).constraints()).findFirst().orElse(List.of());
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(DeclarationParams params) {
        URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
        ModelUnit modelUnit = this.models.get(uri);
        Position position = IntinoDocumentService.fixPosition(params.getPosition());
        Element element = new ReferenceResolver(this.models, modelUnit, this.language).resolveToDeclaration(uri, position);
        return CompletableFuture.completedFuture(Either.forRight(List.of(new LocationLink())));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        ParserRuleContext ctx;
        URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
        ModelUnit modelUnit = this.models.get(uri);
        Position position = IntinoDocumentService.fixPosition(params.getPosition());
        Token token = TreeUtils.findToken(modelUnit.tokens(), position.getLine(), position.getCharacter());
        ParserRuleContext parserRuleContext = ctx = token == null ? null : TreeUtils.findRuleContainingToken((ParserRuleContext)modelUnit.tree(), token);
        if (!(ctx instanceof TaraGrammar.IdentifierKeyContext)) {
            return CompletableFuture.completedFuture(Either.forLeft(List.of()));
        }
        Mogram container = TreeUtils.getMogramContainerOn(modelUnit.model(), position);
        List<TaraGrammar.IdentifierKeyContext> path = this.path((TaraGrammar.IdentifierKeyContext)ctx);
        if (path.isEmpty()) {
            return CompletableFuture.completedFuture(Either.forLeft(List.of()));
        }
        Element element = new ReferenceResolver(this.models, modelUnit, this.language).resolve(container, path);
        if (element == null) {
            return CompletableFuture.completedFuture(Either.forLeft(List.of()));
        }
        Range targetRange = this.rangeOf(element);
        return CompletableFuture.completedFuture(Either.forLeft(List.of(new Location(element.source().getPath(), targetRange))));
    }

    private List<TaraGrammar.IdentifierKeyContext> path(TaraGrammar.IdentifierKeyContext ctx) {
        TaraGrammar.IdentifierReferenceContext reference = TreeUtils.contextByType((ParserRuleContext)ctx, TaraGrammar.IdentifierReferenceContext.class);
        if (reference == null) {
            return List.of();
        }
        List identifiers = reference.hierarchy().stream().map(h -> h.identifierKey()).collect(Collectors.toList());
        identifiers.add(reference.identifierKey());
        return identifiers.subList(0, identifiers.indexOf(ctx) + 1);
    }

    private static Position fixPosition(Position position) {
        position.setLine(position.getLine() + 1);
        return position;
    }

    private Range rangeOf(Element element) {
        Element.TextRange textRange = element.textRange();
        return new Range(new Position(element.textRange().startLine() - 1, textRange.startColumn()), new Position(textRange.endLine() - 1, textRange.endColumn()));
    }

    private Range rangeOf(Token element) {
        return new Range(new Position(element.getLine() - 1, element.getCharPositionInLine()), new Position(element.getLine() - 1, element.getCharPositionInLine() + element.getText().length()));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return super.references(params);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
        ArrayList<Either> actions = new ArrayList<Either>();
        for (Diagnostic diagnostic : params.getContext().getDiagnostics()) {
            DiagnosticContextInfo info = this.getInfo(uri, diagnostic);
            if (info == null) continue;
            List<CodeAction> codeActions = FixFactory.get(info);
            actions.addAll(codeActions.stream().map(e -> Either.forRight((Object)e)).toList());
        }
        return CompletableFuture.completedFuture(actions);
    }

    private DiagnosticContextInfo getInfo(URI uri, Diagnostic diagnostic) {
        ModelUnit modelUnit = this.models.get(uri);
        Position position = IntinoDocumentService.fixPosition(diagnostic.getRange().getStart());
        Token token = TreeUtils.findToken(modelUnit.tokens(), position.getLine(), position.getCharacter());
        ParserRuleContext ctx = token == null || modelUnit.tree() == null ? null : TreeUtils.findRuleContainingToken((ParserRuleContext)modelUnit.tree(), token);
        Mogram container = TreeUtils.getMogramContainerOn(modelUnit.model(), position);
        return new DiagnosticContextInfo(uri, diagnostic.getData() != null ? diagnostic.getData().toString().replace("\"", "") : null, new String[0], this.language, position, container, TreeUtils.elementOnPosition(container, ctx, position), token, ctx);
    }

    public CompletableFuture<CodeAction> resolveCodeAction(CodeAction unresolved) {
        return super.resolveCodeAction(unresolved);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
        Position position = IntinoDocumentService.fixPosition(params.getPosition());
        ModelUnit modelUnit = this.models.get(uri);
        Token token = TreeUtils.findToken(modelUnit.tokens(), position.getLine(), position.getCharacter());
        Mogram container = TreeUtils.getMogramContainerOn(modelUnit.model(), position);
        String newName = params.getNewName();
        return CompletableFuture.completedFuture(new WorkspaceEdit(Map.of()));
    }

    public CompletableFuture<List<InlayHint>> inlayHint(InlayHintParams params) {
        return super.inlayHint(params);
    }

    public CompletableFuture<InlayHint> resolveInlayHint(InlayHint unresolved) {
        return super.resolveInlayHint(unresolved);
    }

    public CompletableFuture<List<InlineValue>> inlineValue(InlineValueParams params) {
        return super.inlineValue(params);
    }

    public void setTrace(SetTraceParams params) {
    }

    public static String normalize(String uri) {
        return uri.replace("file:///", "");
    }
}

