/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.document;

import io.intino.ls.SourceProvider;
import io.intino.ls.document.DocumentManager;
import io.intino.tara.Source;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.stream.Stream;

public class DocumentSourceProvider
implements SourceProvider {
    private final DocumentManager documentManager;

    public DocumentSourceProvider(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    @Override
    public Stream<Source> all() {
        return this.documentManager.all().stream().map(this::get);
    }

    @Override
    public Source get(final URI uri) {
        return new Source(){

            public URI uri() {
                return uri;
            }

            public Charset charset() {
                return Charset.defaultCharset();
            }

            public InputStream content() {
                return DocumentSourceProvider.this.documentManager.getDocumentText(uri);
            }

            public boolean dirty() {
                return false;
            }
        };
    }
}

