/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.completion;

import io.intino.ls.codeinsight.completion.CompletionContext;
import io.intino.ls.codeinsight.completion.TreeUtils;
import io.intino.tara.language.grammar.TaraGrammar;
import java.util.function.Predicate;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

class ContextFilters {
    public static final Predicate<CompletionContext> afterIs = new AfterIsFilter().and(new InFacetFilter());
    public static final Predicate<CompletionContext> afterAs = new AfterElementTypeFitFilter(7);
    public static final Predicate<CompletionContext> afterDef = new AfterDefFitFilter(4);
    public static final Predicate<CompletionContext> afterNewLineInBody = new AfterNewLineInBodyFilter();
    public static final Predicate<CompletionContext> afterNewLine = new AfterNewLineRootFilter();
    public static final Predicate<CompletionContext> afterEquals = new AfterEqualsFilter();
    public static final Predicate<CompletionContext> afterMogramIdentifier = new AfterElementTypeFitFilter(64);
    public static final Predicate<CompletionContext> inParameters = new InParameters().and(afterEquals.negate());
    public static final Predicate<CompletionContext> inReference = new InIdenfierReference();

    private ContextFilters() {
    }

    private static boolean isCandidate(Object element, ParserRuleContext context) {
        return element instanceof ParserRuleContext && context != null && ContextFilters.prevSibling(context) != null;
    }

    private static ParseTree prevSibling(ParserRuleContext ctx) {
        if (ctx == null || ctx.parent == null) {
            return null;
        }
        int indexOfCurrentChildNode = ctx.getParent().children.indexOf(ctx);
        return indexOfCurrentChildNode <= 0 ? null : ctx.parent.getChild(indexOfCurrentChildNode - 1);
    }

    private static ParseTree prevSibling(ParserRuleContext ctx, Token token) {
        if (ctx == null || ctx.parent == null) {
            return null;
        }
        ParseTree childNode = ctx.children.stream().filter(t -> {
            TerminalNode tn;
            return t instanceof TerminalNode && (tn = (TerminalNode)t).getSymbol().equals((Object)token);
        }).findFirst().orElse(null);
        if (childNode == null) {
            return null;
        }
        int i = ctx.children.indexOf(childNode);
        return i <= 0 ? null : (ParseTree)ctx.children.get(i - 1);
    }

    private static boolean acceptableParent(Object element, ParserRuleContext context) {
        return context.getParent() != null;
    }

    private static boolean in(ParserRuleContext context, Class<? extends ParserRuleContext> target) {
        for (ParserRuleContext parent = context.getParent(); parent != null; parent = parent.getParent()) {
            if (!target.isInstance(parent)) continue;
            return true;
        }
        return false;
    }

    private static boolean inAnnotations(ParserRuleContext context) {
        for (ParserRuleContext parent = context.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TaraGrammar.AnnotationsContext)) continue;
            return true;
        }
        return false;
    }

    private static boolean previousNewLine(ParserRuleContext context) {
        return ContextFilters.prevSibling(context) != null && (ContextFilters.is((ParseTree)context, 66) || context instanceof TaraGrammar.ImportsContext || context instanceof TaraGrammar.DslDeclarationContext);
    }

    private static boolean previousNewLineIndent(ParserRuleContext context) {
        return ContextFilters.prevSibling(context) != null && ContextFilters.is((ParseTree)context, 71);
    }

    private static boolean is(ParseTree context, int type) {
        return true;
    }

    private static class AfterIsFilter
    implements Predicate<CompletionContext> {
        private AfterIsFilter() {
        }

        @Override
        public boolean test(CompletionContext context) {
            return this.isAcceptable(context.tokenOnPosition(), context.ruleOnPosition()) && ContextFilters.in(context.ruleOnPosition(), TaraGrammar.SignatureContext.class) && this.afterIs(context.ruleOnPosition());
        }

        private boolean afterIs(ParserRuleContext context) {
            ParserRuleContext parent = context.getParent().getParent();
            return parent != null && this.hasPreviousIs(parent);
        }

        private boolean hasPreviousIs(ParserRuleContext parent) {
            ParseTree prevSibling = ContextFilters.prevSibling(parent);
            while (prevSibling != null) {
                if (ContextFilters.is(prevSibling, 9)) {
                    return true;
                }
                prevSibling = ContextFilters.prevSibling((ParserRuleContext)prevSibling);
            }
            return false;
        }

        private boolean isAcceptable(Object element, ParserRuleContext context) {
            return context != null && context instanceof ParserRuleContext && context.getParent() != null;
        }
    }

    private static class InFacetFilter
    implements Predicate<CompletionContext> {
        private InFacetFilter() {
        }

        @Override
        public boolean test(CompletionContext context) {
            return ContextFilters.acceptableParent(context.tokenOnPosition(), context.ruleOnPosition()) && TreeUtils.isIn(context.ruleOnPosition(), TaraGrammar.FacetsContext.class) && (!this.facet(context.ruleOnPosition()) || TreeUtils.getMogramContainerRuleOf(context.ruleOnPosition()) != null);
        }

        private boolean facet(ParserRuleContext context) {
            return context.getParent() instanceof TaraGrammar.MetaidentifierContext && !ContextFilters.inAnnotations(context);
        }
    }

    private static class AfterElementTypeFitFilter
    implements Predicate<CompletionContext> {
        int type;

        private AfterElementTypeFitFilter(int type) {
            this.type = type;
        }

        @Override
        public boolean test(CompletionContext context) {
            TerminalNode tn;
            if (context == null) {
                return false;
            }
            ParseTree prevSibling = ContextFilters.prevSibling(context.ruleOnPosition(), context.tokenOnPosition());
            return prevSibling instanceof TerminalNode && this.type == (tn = (TerminalNode)prevSibling).getSymbol().getType();
        }
    }

    private static class AfterDefFitFilter
    implements Predicate<CompletionContext> {
        int type;

        private AfterDefFitFilter(int type) {
            this.type = type;
        }

        @Override
        public boolean test(CompletionContext context) {
            TerminalNode tn;
            if (context == null || context.ruleOnPosition().getParent() == null || context.ruleOnPosition().getParent().getParent() == null) {
                return false;
            }
            ParserRuleContext parent = context.ruleOnPosition().getParent().getParent();
            int i = parent.children.indexOf(context.ruleOnPosition().getParent());
            if (i <= 0) {
                return false;
            }
            ParseTree parseTree = (ParseTree)parent.children.get(i - 1);
            return parseTree instanceof TerminalNode && this.type == (tn = (TerminalNode)parseTree).getSymbol().getType();
        }
    }

    private static class AfterNewLineInBodyFilter
    implements Predicate<CompletionContext> {
        private AfterNewLineInBodyFilter() {
        }

        @Override
        public boolean test(CompletionContext context) {
            return context.ruleOnPosition() != null && !(context.ruleOnPosition().getParent() instanceof TaraGrammar.FacetContext) && this.inBody(context.ruleOnPosition()) && this.afterNewLine(context.ruleOnPosition());
        }

        private boolean afterNewLine(ParserRuleContext context) {
            return ContextFilters.prevSibling(context) == null && ContextFilters.in(context, TaraGrammar.SignatureContext.class);
        }

        private boolean inBody(ParserRuleContext context) {
            return context instanceof TaraGrammar.MetaidentifierContext && ContextFilters.in(context, TaraGrammar.BodyContext.class) && !ContextFilters.inAnnotations(context);
        }
    }

    private static class AfterNewLineRootFilter
    implements Predicate<CompletionContext> {
        private AfterNewLineRootFilter() {
        }

        @Override
        public boolean test(CompletionContext context) {
            ParserRuleContext rule = context.ruleOnPosition();
            ParserRuleContext signature = rule.getParent();
            if (signature == null) {
                return false;
            }
            if (rule instanceof TaraGrammar.MetaidentifierContext && !afterAs.test(context) && !ContextFilters.inAnnotations(rule)) {
                return !TreeUtils.isIn(rule, TaraGrammar.BodyContext.class) && (ContextFilters.previousNewLine(signature.getParent()) || ContextFilters.previousNewLineIndent(rule));
            }
            return false;
        }
    }

    private static class AfterEqualsFilter
    implements Predicate<CompletionContext> {
        private AfterEqualsFilter() {
        }

        @Override
        public boolean test(CompletionContext context) {
            ParserRuleContext realContext = (ParserRuleContext)TreeUtils.contextByType(context.ruleOnPosition(), TaraGrammar.ValueContext.class);
            return ContextFilters.isCandidate(context.ruleOnPosition(), realContext) && ContextFilters.prevSibling(realContext) != null && this.isPreviousEquals(realContext);
        }

        private boolean isPreviousEquals(ParserRuleContext context) {
            TerminalNode t;
            ParseTree token = ContextFilters.prevSibling(context);
            return token instanceof TerminalNode && (t = (TerminalNode)token).getSymbol().getType() == 35;
        }
    }

    private static class InParameters
    implements Predicate<CompletionContext> {
        private InParameters() {
        }

        @Override
        public boolean test(CompletionContext context) {
            return ContextFilters.acceptableParent(context.mogramOnPosition(), context.ruleOnPosition()) && this.parameter(context.ruleOnPosition()) && TreeUtils.getMogramContainerRuleOf(context.ruleOnPosition()) != null;
        }

        private boolean parameter(ParserRuleContext context) {
            return ContextFilters.in(context, TaraGrammar.SignaturePropertyContext.class);
        }
    }

    private static class InIdenfierReference
    implements Predicate<CompletionContext> {
        private InIdenfierReference() {
        }

        @Override
        public boolean test(CompletionContext context) {
            for (ParserRuleContext rule = context.ruleOnPosition(); rule != null; rule = rule.getParent()) {
                if (!(rule instanceof TaraGrammar.IdentifierReferenceContext)) continue;
                return true;
            }
            return false;
        }
    }
}

