/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight;

import io.intino.ls.ModelUnit;
import io.intino.ls.codeinsight.completion.TreeUtils;
import io.intino.tara.Language;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.MogramReference;
import io.intino.tara.model.NamedReference;
import io.intino.tara.processors.model.MogramImpl;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.lsp4j.Position;

public class ReferenceResolver {
    private final Map<URI, ModelUnit> models;
    private final Language language;
    private final ModelUnit source;

    public ReferenceResolver(Map<URI, ModelUnit> models, ModelUnit source, Language language) {
        this.source = source;
        this.models = models;
        this.language = language;
    }

    public ReferenceResolver(Map<URI, ModelUnit> models, Language language) {
        this.models = models;
        this.source = models.isEmpty() ? null : models.values().iterator().next();
        this.language = language;
    }

    public Element resolve(Mogram mogram, List<TaraGrammar.IdentifierKeyContext> identifiers) {
        if (TreeUtils.contextByType((ParserRuleContext)identifiers.getFirst(), TaraGrammar.RuleValueContext.class) != null) {
            return this.models.values().stream().flatMap(m -> m.model().constraints().stream()).filter(c -> c.name().equals(((TaraGrammar.IdentifierKeyContext)identifiers.getFirst()).getText())).findFirst().orElse(null);
        }
        return this.resolve(mogram, (String[])identifiers.stream().map(p -> p.getText()).toArray(String[]::new));
    }

    public Mogram resolve(Mogram mogram, String[] path) {
        return this.selectFromOptions(mogram, path, this.findRoots(mogram, path));
    }

    private Mogram selectFromOptions(Mogram mogram, String[] path, Collection<Mogram> roots) {
        return this.resolve(path, this.sortRootsByFile(roots, mogram.source()));
    }

    private Collection<Mogram> sortRootsByFile(Collection<Mogram> roots, URI uri) {
        List<Mogram> mograms = roots.stream().filter(node -> node.source().equals(uri)).collect(Collectors.toList());
        roots.stream().filter(root -> !mograms.contains(root)).forEach(mograms::add);
        return mograms;
    }

    private Mogram resolve(String[] path, Collection<Mogram> roots) {
        if (roots.isEmpty()) {
            return null;
        }
        if (roots.size() == 1 && path.length == 1) {
            return roots.iterator().next();
        }
        for (Mogram root : roots) {
            Mogram candidate = this.resolvePathInMogram(path, root);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private Mogram resolvePathInMogram(String[] path, Mogram mogram) {
        Mogram reference = null;
        for (String name : path) {
            if (reference == null) {
                reference = this.areNamesake(mogram, name) ? mogram : null;
                continue;
            }
            List<Mogram> containedMograms = reference.mograms().stream().filter(m -> m.name().equals(name)).toList();
            if (containedMograms.isEmpty() && reference.parent() != null) {
                reference = ((Mogram)reference.parent().get()).mograms().stream().filter(m -> m.name().equals(name)).findFirst().orElse(null);
            } else {
                Mogram mogram2 = reference = containedMograms.isEmpty() ? null : containedMograms.get(0);
            }
            if (reference != null) continue;
            return null;
        }
        return reference;
    }

    public Element resolveToDeclaration(URI referenceUri, Position referencePosition) {
        MogramReference m;
        ModelUnit modelUnit = this.models.get(referenceUri);
        if (modelUnit == null) {
            return null;
        }
        Element rerefenceElement = ReferenceResolver.findMogramContainingToken((Element)modelUnit.model(), referencePosition);
        if (rerefenceElement == null) {
            return null;
        }
        if (rerefenceElement instanceof MogramReference && (m = (MogramReference)rerefenceElement).target().resolved()) {
            return (Element)m.target().get();
        }
        return null;
    }

    public static Element findMogramContainingToken(Element element, Position position) {
        if (ReferenceResolver.isInRange(element, position)) {
            if (element instanceof ElementContainer) {
                ElementContainer ec = (ElementContainer)element;
                for (Element e : ec.elements()) {
                    Element result = ReferenceResolver.findMogramContainingToken(e, position);
                    if (result == null) continue;
                    return result;
                }
            }
            if (element instanceof MogramReference) {
                MogramReference mr = (MogramReference)element;
                return element;
            }
        }
        return null;
    }

    private static boolean isInRange(Element mogram, Position position) {
        return mogram != null && mogram.textRange().startLine() <= position.getLine() && position.getLine() <= mogram.textRange().endLine();
    }

    private Collection<Mogram> findRoots(Mogram mogram, String[] path) {
        Collection<Mogram> roots = this.searchPossibleRoots((ElementContainer)mogram, path[0], false);
        if (!roots.isEmpty()) {
            return roots;
        }
        for (Mogram root : this.source.model().mograms()) {
            if (!ReferenceResolver.getNameWithoutExtension(new File(root.source().getPath()).getName()).equals(path[0]) || path.length == 1) continue;
            roots = this.searchPossibleRoots((ElementContainer)root, path[1], false);
            break;
        }
        return roots;
    }

    private Collection<Mogram> searchPossibleRoots(ElementContainer mogram, String name, boolean parent) {
        LinkedHashSet<Mogram> set = new LinkedHashSet<Mogram>();
        if (mogram instanceof MogramImpl && this.areNamesake((Mogram)mogram, name)) {
            set.add((Mogram)mogram);
        }
        this.addInContext(name, set, mogram, parent);
        this.addMogramSiblings(name, mogram, set);
        this.addRoots(name, set);
        return set;
    }

    private void addInContext(String name, Set<Mogram> set, ElementContainer mogram, boolean parent) {
        this.checkSiblings(name, set, mogram);
        for (ElementContainer container = mogram.container(); container != null; container = container.container()) {
            Mogram m;
            NamedReference parentMogram;
            if (container instanceof MogramImpl && this.areNamesake((Mogram)container, name)) {
                set.add((Mogram)container);
            }
            this.checkSiblings(name, set, container);
            if (!parent || !(mogram instanceof Mogram) || (parentMogram = (m = (Mogram)mogram).parent()) == null || !parentMogram.resolved()) continue;
            this.collectParentElements(name, set, container, (Mogram)parentMogram.get());
        }
    }

    private void addRoots(String name, Set<Mogram> set) {
        set.addAll(this.source.model().mograms().stream().filter(node -> this.areNamesake((Mogram)node, name)).toList());
    }

    private void addMogramSiblings(String identifier, ElementContainer container, Set<Mogram> set) {
        if (container == null) {
            return;
        }
        set.addAll(container.mograms().stream().filter(node -> this.areNamesake((Mogram)node, identifier)).toList());
    }

    private void checkSiblings(String name, Set<Mogram> set, ElementContainer container) {
        container.siblings().stream().filter(sibling -> sibling instanceof MogramImpl && this.areNamesake((Mogram)sibling, name)).forEach(set::add);
    }

    private void collectParentElements(String identifier, Set<Mogram> set, ElementContainer container, Mogram parent) {
        set.addAll(parent.mograms().stream().filter(sibling -> this.areNamesake((Mogram)sibling, identifier) && !sibling.equals((Object)container)).toList());
    }

    public static String getNameWithoutExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    private boolean areNamesake(Mogram mogram, String name) {
        return name.equals(mogram.name());
    }
}

