/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls;

import io.intino.ls.BuildResult;
import io.intino.ls.IntinoDocumentService;
import io.intino.ls.IntinoSemanticTokens;
import io.intino.ls.IntinoWorkspaceService;
import io.intino.ls.ModelUnit;
import io.intino.ls.codeinsight.DiagnosticService;
import io.intino.ls.document.DocumentManager;
import io.intino.tara.Language;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DiagnosticRegistrationOptions;
import org.eclipse.lsp4j.FileOperationFilter;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationPattern;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkDoneProgressCancelParams;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;

public class IntinoLanguageServer
implements LanguageServer,
LanguageClientAware {
    private final Map<URI, ModelUnit> models;
    public HashMap<Object, Object> expectedRequests = new HashMap();
    private final DiagnosticService diagnosticService;
    private final IntinoDocumentService documentService;
    private final IntinoWorkspaceService workspaceService;
    private AtomicReference<LanguageClient> client = new AtomicReference<Object>(null);

    public IntinoLanguageServer(Language language, DocumentManager documentManager) {
        this.models = new HashMap<URI, ModelUnit>();
        this.diagnosticService = new DiagnosticService(documentManager, language, this.models);
        this.documentService = new IntinoDocumentService(language, documentManager, this.diagnosticService, this.models, this.client);
        this.workspaceService = new IntinoWorkspaceService(language, documentManager, this.diagnosticService);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setSemanticTokensProvider(IntinoLanguageServer.semanticTokensWithRegistrationOptions());
        capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
        capabilities.setCompletionProvider(new CompletionOptions(Boolean.valueOf(false), List.of(".")));
        capabilities.setDiagnosticProvider(new DiagnosticRegistrationOptions(true, false));
        SignatureHelpOptions helpOptions = new SignatureHelpOptions();
        helpOptions.setTriggerCharacters(List.of("("));
        helpOptions.setRetriggerCharacters(List.of(","));
        helpOptions.setWorkDoneProgress(Boolean.valueOf(true));
        capabilities.setSignatureHelpProvider(helpOptions);
        capabilities.setFoldingRangeProvider(Boolean.valueOf(true));
        capabilities.setCodeActionProvider(Boolean.valueOf(true));
        capabilities.setTypeHierarchyProvider(Boolean.valueOf(true));
        capabilities.setDefinitionProvider(Boolean.valueOf(true));
        capabilities.setRenameProvider(Boolean.valueOf(true));
        WorkspaceServerCapabilities workspaceCaps = new WorkspaceServerCapabilities();
        WorkspaceFoldersOptions workspaceFolders = new WorkspaceFoldersOptions();
        workspaceFolders.setChangeNotifications(Boolean.valueOf(true));
        workspaceFolders.setSupported(Boolean.valueOf(true));
        workspaceCaps.setWorkspaceFolders(workspaceFolders);
        FileOperationsServerCapabilities fileCaps = new FileOperationsServerCapabilities();
        FileOperationOptions fileOptions = new FileOperationOptions();
        FileOperationFilter fileFilter = new FileOperationFilter();
        fileFilter.setPattern(new FileOperationPattern("*.tara"));
        fileOptions.setFilters(List.of(fileFilter));
        fileCaps.setDidCreate(fileOptions);
        capabilities.setWorkspace(workspaceCaps);
        capabilities.setWorkspaceSymbolProvider(Boolean.valueOf(true));
        return CompletableFuture.completedFuture(new InitializeResult(capabilities));
    }

    private static SemanticTokensWithRegistrationOptions semanticTokensWithRegistrationOptions() {
        SemanticTokensLegend legend = new SemanticTokensLegend(IntinoSemanticTokens.tokenTypes, IntinoSemanticTokens.tokenModifiers);
        return new SemanticTokensWithRegistrationOptions(legend, Boolean.valueOf(true));
    }

    public DiagnosticService getDiagnosticService() {
        return this.diagnosticService;
    }

    public TextDocumentService getTextDocumentService() {
        return this.documentService;
    }

    public IntinoWorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public BuildResult build() {
        return new BuildResult();
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.completedFuture(null);
    }

    public void exit() {
    }

    public void initialized(InitializedParams params) {
        super.initialized(params);
    }

    public void cancelProgress(WorkDoneProgressCancelParams params) {
        super.cancelProgress(params);
    }

    public void connect(LanguageClient client) {
        this.client.set(client);
    }

    public void setTrace(SetTraceParams params) {
    }
}

