/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.completion;

import io.intino.ls.ModelUnit;
import io.intino.ls.codeinsight.ReferenceResolver;
import io.intino.ls.codeinsight.completion.TreeUtils;
import io.intino.tara.Language;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.rules.property.ReferenceRule;
import io.intino.tara.processors.Resolver;
import io.intino.tara.processors.model.Model;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;

class VariantsManager {
    private final Set<Mogram> variants = new LinkedHashSet<Mogram>();
    private final Language language;
    private final Map<URI, ModelUnit> models;
    private final ModelUnit modelUnit;
    private final TaraGrammar.IdentifierKeyContext myElement;
    private final Mogram mogram;
    private final List<TaraGrammar.IdentifierKeyContext> context;

    VariantsManager(Language language, Map<URI, ModelUnit> models, ModelUnit modelUnit, TaraGrammar.IdentifierKeyContext myElement, Mogram mogram) {
        this.language = language;
        this.models = models;
        this.modelUnit = modelUnit;
        this.myElement = myElement;
        this.mogram = mogram;
        this.context = this.solveIdentifierContext();
    }

    Set<Mogram> resolveVariants() {
        if (this.hasContext()) {
            this.addContextVariants();
        } else {
            this.addInModelVariants();
        }
        if (this.mogram == null || this.mogram.types().isEmpty()) {
            return this.variants;
        }
        if (this.isParentReference((TaraGrammar.IdentifierReferenceContext)this.myElement.getParent())) {
            return this.variants;
        }
        if (this.isParameterContext((ParserRuleContext)this.myElement) && this.isReferenceParameter((ParserRuleContext)this.myElement)) {
            return this.variants;
        }
        return Set.of();
    }

    private boolean isReferenceParameter(ParserRuleContext element) {
        new Resolver(this.language).resolve((ElementContainer)this.mogram);
        List<Constraint> constraints = this.constraintsOf(this.mogram);
        TaraGrammar.PropertyDescriptiveContext parameterRule = VariantsManager.propertyDescriptionContext(element);
        if (parameterRule == null) {
            parameterRule = VariantsManager.signaturePropertyContext(element);
        }
        if (constraints == null || parameterRule == null) {
            return false;
        }
        PropertyDescription parameter = this.propertyDescription(this.mogram, (ParserRuleContext)parameterRule);
        if (parameter == null) {
            return false;
        }
        Constraint.Property constraint = this.findConstraint(constraints, parameter);
        if (constraint == null && !this.mogram.appliedFacets().isEmpty()) {
            constraint = this.searchInFacets(this.mogram, constraints, (ParserRuleContext)parameterRule);
        }
        return constraint != null;
    }

    private static TaraGrammar.PropertyDescriptiveContext propertyDescriptionContext(ParserRuleContext element) {
        return TreeUtils.contextByType(element, TaraGrammar.PropertyDescriptiveContext.class);
    }

    private PropertyDescription propertyDescription(Mogram mogram, ParserRuleContext parameterRule) {
        return mogram.parameters().stream().filter(p -> p.values().stream().anyMatch(v -> v.toString().contains("Tara_Fake_Token"))).findFirst().orElse(null);
    }

    private ReferenceRule referenceRule(Constraint.Property constraint) {
        return constraint.rules().stream().filter(c -> c instanceof ReferenceRule).findFirst().orElse(null);
    }

    private Constraint.Property searchInFacets(Mogram mogram, List<Constraint> constraints, ParserRuleContext parameter) {
        for (Constraint c : constraints) {
            if (!(c instanceof Constraint.Facet) || this.facetOf((Constraint.Facet)c, mogram.appliedFacets()) == null) continue;
            return this.findConstraint(((Constraint.Facet)c).constraints(), this.propertyDescription(mogram, parameter));
        }
        return null;
    }

    private Facet facetOf(Constraint.Facet c, List<Facet> facets) {
        for (Facet facet : facets) {
            if (!facet.type().equals(c.type())) continue;
            return facet;
        }
        return null;
    }

    private Constraint.Property findConstraint(List<Constraint> constraints, PropertyDescription parameter) {
        return constraints.stream().filter(c -> {
            Constraint.Property p;
            return c instanceof Constraint.Property && (p = (Constraint.Property)c).type().equals((Object)Primitive.REFERENCE) && this.isConstraintOf(parameter, (Constraint.Property)c);
        }).findFirst().orElse(null);
    }

    private boolean isConstraintOf(PropertyDescription parameter, Constraint.Property constraint) {
        return constraint.name().equals(parameter.name()) || this.match(constraint, parameter);
    }

    public boolean match(Constraint.Property c, PropertyDescription parameter) {
        PropertyDescription expected = TreeUtils.findPropertyDescription(parameter.container().parameters(), c.facet(), c.name(), c.position());
        return parameter.equals((Object)expected);
    }

    private boolean isParameterContext(ParserRuleContext element) {
        return VariantsManager.propertyDescriptionContext(element) != null || VariantsManager.signaturePropertyContext(element) != null;
    }

    private static TaraGrammar.SignaturePropertyContext signaturePropertyContext(ParserRuleContext element) {
        return TreeUtils.contextByType(element, TaraGrammar.SignaturePropertyContext.class);
    }

    private List<Mogram> collectUnacceptableMograms(List<String> expectedTypes) {
        if (expectedTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return this.variants.stream().filter(variant -> !variant.types().isEmpty() && variant.types().stream().noneMatch(t -> expectedTypes.contains(t.split(":")[0]))).toList();
    }

    private boolean hasContext() {
        return !this.getContext().isEmpty();
    }

    private List<TaraGrammar.IdentifierKeyContext> getContext() {
        return ((TaraGrammar.IdentifierReferenceContext)this.myElement.getParent()).hierarchy().stream().map(e -> e.identifierKey()).collect(Collectors.toList());
    }

    private void addContextVariants() {
        List<TaraGrammar.IdentifierKeyContext> aContext = this.getContext();
        Mogram target = new ReferenceResolver(this.models, this.modelUnit, this.language).resolve(this.mogram, aContext);
        if (this.mogram == null) {
            return;
        }
        this.variants.addAll(target.components());
    }

    private void addInModelVariants() {
        if (this.modelUnit == null) {
            return;
        }
        this.modelUnit.model().components().stream().filter(m -> !m.isAnonymous()).filter(mogram -> !mogram.equals((Object)this.mogram)).forEach(mogram -> this.resolvePathFor((Mogram)mogram, this.context));
        this.addMainConcepts(this.modelUnit.model());
    }

    private void addMainConcepts(Model model) {
        model.mograms().stream().filter(m -> !m.isAnonymous()).filter(mogram -> !this.variants.contains(mogram) && !mogram.is(Annotation.Component) && !mogram.is(Annotation.Feature)).forEach(mogram -> this.resolvePathFor((Mogram)mogram, this.context));
    }

    private void resolvePathFor(Mogram mogram, List<TaraGrammar.IdentifierKeyContext> path) {
        List components = mogram.components();
        if (mogram == null || mogram.types().isEmpty()) {
            return;
        }
        if (path.isEmpty()) {
            this.variants.add(mogram);
        } else if (path.get(0).getText().equals(mogram.name())) {
            for (Mogram child : components) {
                this.resolvePathFor(child, path.subList(1, path.size()));
            }
        }
    }

    private List<TaraGrammar.IdentifierKeyContext> solveIdentifierContext() {
        return ((TaraGrammar.IdentifierReferenceContext)this.myElement.getParent()).hierarchy().stream().map(e -> e.identifierKey()).collect(Collectors.toList());
    }

    private boolean isParentReference(TaraGrammar.IdentifierReferenceContext reference) {
        return reference.getParent() instanceof TaraGrammar.SignatureContext;
    }

    public List<Constraint> constraintsOf(Mogram mogram) {
        if (this.language == null) {
            return null;
        }
        return this.language.constraints((String)mogram.types().getFirst());
    }
}

