/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.fix;

import io.intino.ls.codeinsight.DiagnosticContextInfo;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.rules.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;

public class RemoveElementFix
extends CodeAction {
    public RemoveElementFix(DiagnosticContextInfo info) {
        if (info.tokenOnPosition() == null || info.mogramOnPosition() == null) {
            return;
        }
        List<Constraint.Property> constraints = this.findConstraints(info).stream().filter(constraint -> constraint instanceof Constraint.Property && ((Size)((Constraint.Property)constraint).rule(Size.class)).isRequired()).map(constraint -> (Constraint.Property)constraint).collect(Collectors.toList());
        WorkspaceEdit edit = new WorkspaceEdit();
        edit.setChanges(Map.of(info.uri().toString(), List.of(this.positionateCursor())));
        this.setEdit(edit);
        this.setTitle("Remove element");
        this.setKind("quickfix");
        Command command = new Command(this.getTitle(), "editor.action.insertSnippet", List.of(Map.of("snippet", this.createTemplateFor(constraints))));
    }

    private TextEdit positionateCursor() {
        TextEdit dummyEdit = new TextEdit();
        dummyEdit.setRange(new Range(new Position(10, 4), new Position(10, 4)));
        dummyEdit.setNewText("");
        return dummyEdit;
    }

    public String getKind() {
        return "quickfix";
    }

    private String createTemplateFor(List<Constraint.Property> constraints) {
        return null;
    }

    private List<Constraint> findConstraints(DiagnosticContextInfo info) {
        Mogram mogram = info.mogramOnPosition();
        ArrayList<Constraint> constraintsOf = new ArrayList<Constraint>(info.language().constraints((String)mogram.types().getFirst()));
        ArrayList aspectConstraints = new ArrayList();
        List facets = mogram.types();
        for (Constraint c : constraintsOf) {
            if (!(c instanceof Constraint.Facet) || !facets.contains(((Constraint.Facet)c).type())) continue;
            aspectConstraints.addAll(((Constraint.Facet)c).constraints());
        }
        constraintsOf.addAll(aspectConstraints);
        return constraintsOf;
    }
}

