/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.completion;

import io.intino.ls.ModelUnit;
import io.intino.ls.codeinsight.ReferenceResolver;
import io.intino.ls.codeinsight.completion.TreeUtils;
import io.intino.tara.Language;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.Annotation;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.rules.property.ReferenceRule;
import io.intino.tara.processors.Resolver;
import io.intino.tara.processors.model.Model;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;

class VariantsManager {
    private final Set<Mogram> variants = new LinkedHashSet<Mogram>();
    private final Language language;
    private final Map<URI, ModelUnit> models;
    private final ModelUnit modelUnit;
    private final TaraGrammar.IdentifierKeyContext myElement;
    private final Mogram mogram;
    private final List<TaraGrammar.IdentifierKeyContext> context;

    VariantsManager(Language language, Map<URI, ModelUnit> models, ModelUnit modelUnit, TaraGrammar.IdentifierKeyContext myElement, Mogram mogram) {
        this.language = language;
        this.models = models;
        this.modelUnit = modelUnit;
        this.myElement = myElement;
        this.mogram = mogram;
        this.context = this.solveIdentifierContext();
    }

    Set<Mogram> resolveVariants() {
        if (this.hasContext()) {
            this.addContextVariants();
        } else {
            this.addInModelVariants();
        }
        Mogram mogram = TreeUtils.getMogramContainer(this.modelUnit.model(), (ParserRuleContext)this.myElement);
        if (mogram == null || mogram.types().isEmpty()) {
            return this.variants;
        }
        if (this.isParentReference((TaraGrammar.IdentifierReferenceContext)this.myElement.getParent())) {
            this.collectUnacceptableMograms(mogram.types()).forEach(this.variants::remove);
        } else if (this.isParameterReference((ParserRuleContext)this.myElement)) {
            this.collectUnacceptableMograms(this.filterTypes((ParserRuleContext)this.myElement)).forEach(this.variants::remove);
        }
        return this.variants;
    }

    private List<String> filterTypes(ParserRuleContext element) {
        Mogram mogram = TreeUtils.getMogramContainer(this.modelUnit.model(), element);
        new Resolver(this.language).resolve((ElementContainer)mogram);
        List<Constraint> constraints = this.constraintsOf(mogram);
        TaraGrammar.PropertyDescriptiveContext parameterRule = TreeUtils.contextByType(element, TaraGrammar.PropertyDescriptiveContext.class);
        if (constraints == null || parameterRule == null) {
            return Collections.emptyList();
        }
        Constraint.Property constraint = this.findParameter(constraints, this.propertyDescription(mogram, parameterRule));
        if (constraint == null && !mogram.appliedFacets().isEmpty()) {
            constraint = this.searchInFacets(mogram, constraints, parameterRule);
        }
        if (constraint == null || !constraint.type().equals((Object)Primitive.REFERENCE)) {
            return Collections.emptyList();
        }
        return this.referenceRule(constraint).allowedReferences();
    }

    private PropertyDescription propertyDescription(Mogram mogram, TaraGrammar.PropertyDescriptiveContext parameterRule) {
        return null;
    }

    private ReferenceRule referenceRule(Constraint.Property constraint) {
        return constraint.rules().stream().filter(c -> c instanceof ReferenceRule).findFirst().orElse(null);
    }

    private Constraint.Property searchInFacets(Mogram mogram, List<Constraint> constraints, TaraGrammar.PropertyDescriptiveContext parameter) {
        for (Constraint c : constraints) {
            if (!(c instanceof Constraint.Facet) || this.facetOf((Constraint.Facet)c, mogram.appliedFacets()) == null) continue;
            return this.findParameter(((Constraint.Facet)c).constraints(), this.propertyDescription(mogram, parameter));
        }
        return null;
    }

    private Facet facetOf(Constraint.Facet c, List<Facet> facets) {
        for (Facet facet : facets) {
            if (!facet.type().equals(c.type())) continue;
            return facet;
        }
        return null;
    }

    private Constraint.Property findParameter(List<Constraint> constraints, PropertyDescription parameter) {
        return constraints.stream().filter(c -> {
            Constraint.Property p;
            return c instanceof Constraint.Property && (p = (Constraint.Property)c).type().equals((Object)Primitive.REFERENCE) && this.isConstraintOf(parameter, (Constraint.Property)c);
        }).findFirst().orElse(null);
    }

    private boolean isConstraintOf(PropertyDescription parameter, Constraint.Property constraint) {
        return constraint.name().equals(parameter.name()) || this.match(constraint, parameter);
    }

    public boolean match(Constraint.Property c, PropertyDescription parameter) {
        PropertyDescription expected = TreeUtils.findPropertyDescription(parameter.container().parameters(), c.facet(), c.name(), c.position());
        return parameter.equals((Object)expected);
    }

    private boolean isParameterReference(ParserRuleContext element) {
        return TreeUtils.contextByType(element, TaraGrammar.PropertyDescriptiveContext.class) != null || TreeUtils.contextByType(element, TaraGrammar.SignaturePropertyContext.class) != null;
    }

    private List<Mogram> collectUnacceptableMograms(List<String> expectedTypes) {
        if (expectedTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return this.variants.stream().filter(variant -> !variant.types().isEmpty() && variant.types().stream().noneMatch(t -> expectedTypes.contains(t.split(":")[0]))).toList();
    }

    private boolean hasContext() {
        return !this.getContext().isEmpty();
    }

    private List<TaraGrammar.IdentifierKeyContext> getContext() {
        return ((TaraGrammar.IdentifierReferenceContext)this.myElement.getParent()).hierarchy().stream().map(e -> e.identifierKey()).collect(Collectors.toList());
    }

    private void addContextVariants() {
        List<TaraGrammar.IdentifierKeyContext> aContext = this.getContext();
        Mogram target = new ReferenceResolver(this.models, this.modelUnit, this.language).resolve(this.mogram, aContext);
        if (this.mogram == null) {
            return;
        }
        this.variants.addAll(target.components());
    }

    private void addInModelVariants() {
        if (this.modelUnit == null) {
            return;
        }
        this.modelUnit.model().components().stream().filter(mogram -> !mogram.equals((Object)TreeUtils.getMogramContainer(this.modelUnit.model(), (ParserRuleContext)this.myElement))).forEach(mogram -> this.resolvePathFor((Mogram)mogram, this.context));
        this.addMainConcepts(this.modelUnit.model());
    }

    private void addMainConcepts(Model model) {
        model.mograms().stream().filter(mogram -> !this.variants.contains(mogram) && !mogram.is(Annotation.Component) && !mogram.is(Annotation.Feature)).forEach(mogram -> this.resolvePathFor((Mogram)mogram, this.context));
    }

    private void resolvePathFor(Mogram mogram, List<TaraGrammar.IdentifierKeyContext> path) {
        List components = mogram.components();
        if (mogram == null || mogram.types().isEmpty()) {
            return;
        }
        if (path.isEmpty()) {
            this.variants.add(mogram);
        } else if (path.get(0).getText().equals(mogram.name())) {
            for (Mogram child : components) {
                this.resolvePathFor(child, path.subList(1, path.size()));
            }
        }
    }

    private List<TaraGrammar.IdentifierKeyContext> solveIdentifierContext() {
        return ((TaraGrammar.IdentifierReferenceContext)this.myElement.getParent()).hierarchy().stream().map(e -> e.identifierKey()).collect(Collectors.toList());
    }

    private boolean isParentReference(TaraGrammar.IdentifierReferenceContext reference) {
        return reference.getParent() instanceof TaraGrammar.SignatureContext;
    }

    public List<Constraint> constraintsOf(Mogram mogram) {
        if (this.language == null) {
            return null;
        }
        return this.language.constraints((String)mogram.types().getFirst());
    }
}

