/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.completion;

import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.processors.model.Model;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Position;

public class TreeUtils {
    public static <T> T contextByType(ParserRuleContext element, Class<T> contextClass) {
        for (ParserRuleContext parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (!contextClass.isInstance(parent)) continue;
            return (T)parent;
        }
        return null;
    }

    public static Element elementOnPosition(Mogram container, ParserRuleContext ctx, Position position) {
        if (container == null) {
            return null;
        }
        for (Element element : container.elements()) {
            if (element.textRange().startLine() != position.getLine()) continue;
            return element;
        }
        TaraGrammar.SignaturePropertyContext sigProperty = TreeUtils.contextByType(ctx, TaraGrammar.SignaturePropertyContext.class);
        if (sigProperty != null) {
            return container.parameters().stream().filter(pd -> sigProperty.IDENTIFIER() != null && pd.name().equals(sigProperty.IDENTIFIER().getText())).findFirst().orElse(null);
        }
        TaraGrammar.PropertyDescriptiveContext description = TreeUtils.contextByType(ctx, TaraGrammar.PropertyDescriptiveContext.class);
        if (description != null) {
            return container.parameters().stream().filter(pd -> description.IDENTIFIER() != null && pd.name().equals(description.IDENTIFIER().getText())).findFirst().orElse(null);
        }
        return null;
    }

    public static boolean isIn(ParserRuleContext element, Class<? extends ParserRuleContext> contextClass) {
        return TreeUtils.contextByType(element, contextClass) != null;
    }

    public static Mogram getMogramContainerOn(Model model, Position position) {
        return model.mograms().stream().map(element -> TreeUtils.findInElement((ElementContainer)element, position)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Mogram getMogramContainer(Model model, ParserRuleContext context) {
        return TreeUtils.getMogramContainerOn(model, new Position(context.getStart().getLine(), context.getStart().getCharPositionInLine()));
    }

    public static PropertyDescription findPropertyDescription(List<PropertyDescription> parameters, String facet, String name, int position) {
        for (PropertyDescription parameter : parameters) {
            if (parameter.name().isEmpty() || !parameter.name().equals(name)) continue;
            return parameter;
        }
        return TreeUtils.byPosition(parameters, facet, position);
    }

    private static PropertyDescription byPosition(List<PropertyDescription> parameters, String facet, int position) {
        for (PropertyDescription parameter : parameters) {
            if (!parameter.name().isEmpty() || !parameter.facet().equals(facet) || parameter.position() != position) continue;
            return parameter;
        }
        return null;
    }

    public static ParserRuleContext getMogramContainerRuleOf(ParserRuleContext context) {
        for (ParserRuleContext parent = context.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TaraGrammar.MogramContext)) continue;
            return parent;
        }
        return null;
    }

    public static ParseTree getPreviousSibling(ParserRuleContext ctx) {
        ParserRuleContext parent = ctx.getParent();
        if (parent == null) {
            return null;
        }
        List children = parent.children;
        if (children == null || children.size() < 2) {
            return null;
        }
        for (int i = 1; i < children.size(); ++i) {
            if (children.get(i) != ctx) continue;
            return (ParseTree)children.get(i - 1);
        }
        return null;
    }

    private static Mogram findInElement(ElementContainer element, Position position) {
        Element.TextRange range = element.textRange();
        if (!TreeUtils.contains(range, position)) {
            return null;
        }
        if (element.mograms().isEmpty()) {
            return (Mogram)element;
        }
        Mogram innerMogram = element.mograms().stream().map(mogram -> TreeUtils.findInElement((ElementContainer)mogram, position)).filter(Objects::nonNull).findFirst().orElse(null);
        if (innerMogram == null) {
            return (Mogram)element;
        }
        return innerMogram;
    }

    public static boolean contains(Element.TextRange range, Position position) {
        return TreeUtils.isBeforeOrEqual(new Position(range.startLine(), range.startColumn()), position) && TreeUtils.isBeforeOrEqual(position, new Position(range.endLine(), range.endColumn()));
    }

    private static boolean isBefore(Position p1, Position p2) {
        return p1.getLine() < p2.getLine() || p1.getLine() == p2.getLine() && p1.getCharacter() < p2.getCharacter();
    }

    private static boolean isBeforeOrEqual(Position p1, Position p2) {
        return p1.getLine() < p2.getLine() || p1.getLine() == p2.getLine() && p1.getCharacter() <= p2.getCharacter();
    }

    private static boolean isAfter(Position p1, Position p2) {
        return TreeUtils.isBefore(p2, p1);
    }

    public static Token findToken(TokenStream tokens, int line, int column) {
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.getLine() != line) continue;
            int tokenStart = token.getCharPositionInLine();
            int tokenEnd = tokenStart + token.getText().length();
            if (column < tokenStart || column >= tokenEnd) continue;
            return token;
        }
        return null;
    }

    public static ParserRuleContext findNodeContainingToken(ParserRuleContext ctx, Token token) {
        Token startToken = ctx.getStart();
        Token stopToken = ctx.getStop();
        if (token.getTokenIndex() >= startToken.getTokenIndex() && token.getTokenIndex() <= stopToken.getTokenIndex()) {
            for (int i = 0; i < ctx.getChildCount(); ++i) {
                ParserRuleContext result;
                ParseTree child = ctx.getChild(i);
                if (!(child instanceof ParserRuleContext) || (result = TreeUtils.findNodeContainingToken((ParserRuleContext)child, token)) == null) continue;
                return result;
            }
            return ctx;
        }
        return null;
    }
}

