/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.completion;

import io.intino.alexandria.logger.Logger;
import io.intino.ls.IntinoDocumentService;
import io.intino.ls.ModelUnit;
import io.intino.ls.codeinsight.completion.AnnotationCompletionProvider;
import io.intino.ls.codeinsight.completion.BodyCompletionProvider;
import io.intino.ls.codeinsight.completion.CompletionContext;
import io.intino.ls.codeinsight.completion.CompletionProvider;
import io.intino.ls.codeinsight.completion.CompletionUtils;
import io.intino.ls.codeinsight.completion.ContextFilters;
import io.intino.ls.codeinsight.completion.TreeUtils;
import io.intino.ls.codeinsight.completion.VariantsManager;
import io.intino.ls.parsing.CompletionErrorStrategy;
import io.intino.ls.parsing.Parser;
import io.intino.tara.Language;
import io.intino.tara.Source;
import io.intino.tara.language.grammar.SyntaxException;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.Valued;
import io.intino.tara.model.rules.property.WordRule;
import io.intino.tara.processors.Resolver;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.parser.antlr.ModelGenerator;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Position;

public class CompletionService {
    public static final String TARA_FAKE_TOKEN = "Tara_Fake_Token";
    private final Map<Predicate<CompletionContext>, CompletionProvider> map = new LinkedHashMap<Predicate<CompletionContext>, CompletionProvider>();
    private final Map<URI, ModelUnit> models;

    public CompletionService(Language language, Map<URI, ModelUnit> models) {
        this.models = models;
        this.map.put(ContextFilters.afterIs, (context, result) -> CompletionService.afterIs(context, result));
        this.map.put(ContextFilters.afterDef, (context, result) -> CompletionService.afterDef(result));
        this.map.put(ContextFilters.afterNewLineInBody, new BodyCompletionProvider(language));
        this.map.put(ContextFilters.afterAs, new AnnotationCompletionProvider());
        this.map.put(ContextFilters.afterNewLine, (context, result) -> CompletionService.afterNewLine(context, result));
        this.map.put(ContextFilters.afterEquals, (context, result) -> CompletionService.afterEquals(context, result));
        this.map.put(ContextFilters.afterMogramIdentifier, (context, result) -> CompletionService.afterMogramIdentifier(context, result));
        this.map.put(ContextFilters.inParameters, (context, result) -> CompletionService.inParameters(context, result));
        this.map.put(ContextFilters.inReference, (context, result) -> this.inReference(context, result));
    }

    public List<CompletionItem> propose(CompletionContext params) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        this.map.keySet().stream().filter(p -> p.test(params)).forEach(p -> this.map.get(p).addCompletions(params, items));
        return items;
    }

    private static void afterMogramIdentifier(CompletionContext context, List<CompletionItem> result) {
        Mogram mogram = context.mogramOnPosition();
        if (!(mogram instanceof Mogram)) {
            return;
        }
        Mogram m = mogram;
        if (m.level() != Level.M1) {
            result.addAll(List.of(CompletionProvider.create("extends ", CompletionItemKind.Keyword), CompletionProvider.create("as ", CompletionItemKind.Keyword)));
        } else if (!m.applicableFacets().isEmpty()) {
            result.add(CompletionProvider.create("is ", CompletionItemKind.Keyword));
        }
    }

    private void inReference(CompletionContext context, List<CompletionItem> result) {
        VariantsManager variantsManager = new VariantsManager(context.language(), this.models, this.models.get(context.uri()), (TaraGrammar.IdentifierKeyContext)context.ruleOnPosition(), context.mogramOnPosition());
        Set<Mogram> mograms = variantsManager.resolveVariants();
        mograms.forEach(m -> result.add(CompletionProvider.create(m.name(), CompletionItemKind.Reference)));
    }

    private static void afterEquals(CompletionContext context, List<CompletionItem> result) {
        Valued p;
        Element valued = context.elementOnPosition();
        ParserRuleContext rule = context.ruleOnPosition();
        if (valued == null) {
            return;
        }
        new Resolver(context.language()).resolve((ElementContainer)context.mogramOnPosition());
        if (valued instanceof Valued && Primitive.WORD.equals((Object)(p = (Valued)valued).type())) {
            if (p.rule(WordRule.class) != null) {
                ((WordRule)p.rule(WordRule.class)).words().forEach(w -> result.add(CompletionProvider.create(w, CompletionItemKind.Enum)));
            }
        } else if (valued instanceof Valued) {
            Valued pd = (Valued)valued;
            if (Primitive.REFERENCE.equals((Object)pd.type()) && !(rule.getParent() instanceof TaraGrammar.StringValueContext) && !(TreeUtils.getPreviousSibling(rule) instanceof TaraGrammar.HierarchyContext)) {
                result.add(CompletionProvider.createKeyword("empty"));
            } else if (Primitive.BOOLEAN.equals((Object)pd.type())) {
                result.addAll(List.of(CompletionProvider.createKeyword("true"), CompletionProvider.createKeyword("false")));
            }
        }
    }

    private static void afterNewLine(CompletionContext context, List<CompletionItem> result) {
        Mogram ec = context.mogramOnPosition() instanceof Mogram ? context.mogramOnPosition().container() : context.mogramOnPosition();
        result.addAll(new CompletionUtils(context).collectAllowedComponents((ElementContainer)ec));
    }

    private static void afterDef(List<CompletionItem> result) {
        for (Primitive primitive : Primitive.getPrimitives()) {
            String name = primitive.getName().toLowerCase();
            if (primitive.equals((Object)Primitive.WORD)) {
                result.add(CompletionProvider.create(name, name + ":{}", CompletionItemKind.Variable));
                continue;
            }
            result.add(CompletionProvider.create(name, CompletionItemKind.Variable));
        }
    }

    private static void afterIs(CompletionContext context, List<CompletionItem> result) {
        if (!(context.ruleOnPosition() instanceof TaraGrammar.MetaidentifierContext)) {
            return;
        }
        CompletionUtils completionUtils = new CompletionUtils(context);
        Mogram element = context.mogramOnPosition();
        if (element instanceof Mogram) {
            Mogram m = element;
            new Resolver(context.language()).resolve((ElementContainer)m);
            result.addAll(completionUtils.collectAllowedFacets(m));
        }
    }

    private static void inParameters(CompletionContext context, List<CompletionItem> result) {
        Mogram mogram = context.mogramOnPosition();
        if (mogram instanceof Mogram) {
            Mogram m = mogram;
            new Resolver(context.language()).resolve((ElementContainer)m);
            result.addAll(new CompletionUtils(context).collectSignatureParameters(m));
        }
    }

    public static CompletionContext completionContextOf(CompletionParams params, Language language, Source.StringSource originalDoc) {
        try {
            URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
            Position position = params.getPosition();
            position.setLine(position.getLine() + 1);
            String fakeDoc = new StringBuilder(originalDoc.stringContent()).insert(CompletionService.indexOf(position, originalDoc.stringContent()), TARA_FAKE_TOKEN).toString();
            Source.StringSource source = new Source.StringSource(originalDoc.uri().getPath(), fakeDoc);
            Parser parser = new Parser((Source)source, new CompletionErrorStrategy());
            CommonTokenStream tokens = parser.tokens();
            TaraGrammar.RootContext tree = parser.parse(tokens);
            Model model = CompletionService.convert(source, tree);
            Token token = TreeUtils.findToken((TokenStream)tokens, position.getLine(), params.getPosition().getCharacter());
            ParserRuleContext ctx = token == null ? null : TreeUtils.findNodeContainingToken((ParserRuleContext)tree, token);
            Mogram container = TreeUtils.getMogramContainerOn(model, params.getPosition());
            return new CompletionContext(uri, language, params.getPosition(), container, TreeUtils.elementOnPosition(container, ctx, params.getPosition()), token, ctx, params.getContext().getTriggerCharacter());
        }
        catch (SyntaxException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public static Model convert(Source.StringSource source, TaraGrammar.RootContext rootContext) throws SyntaxException {
        try {
            ModelGenerator extractor = new ModelGenerator((Source)source);
            new ParseTreeWalker().walk((ParseTreeListener)extractor, (ParseTree)rootContext);
            return extractor.getModel();
        }
        catch (RecognitionException e) {
            return null;
        }
    }

    private static int indexOf(Position position, String textDoc) {
        String[] lines = textDoc.split("\n", -1);
        if (position.getLine() < 1 || position.getLine() > lines.length) {
            return -1;
        }
        if (position.getCharacter() < 0 || position.getCharacter() > lines[position.getLine() - 1].length() + 1) {
            return -1;
        }
        int absoluteIndex = 0;
        for (int i = 0; i < position.getLine() - 1; ++i) {
            absoluteIndex += lines[i].length() + 1;
        }
        return absoluteIndex + position.getCharacter();
    }
}

