/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls;

import io.intino.alexandria.logger.Logger;
import io.intino.ls.codeinsight.DiagnosticService;
import io.intino.ls.document.DocumentManager;
import io.intino.tara.Language;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.lsp4j.CreateFilesParams;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.WorkspaceDiagnosticParams;
import org.eclipse.lsp4j.WorkspaceDiagnosticReport;
import org.eclipse.lsp4j.WorkspaceDocumentDiagnosticReport;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFullDocumentDiagnosticReport;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolLocation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.WorkspaceService;

public class IntinoWorkspaceService
implements WorkspaceService {
    private final Language language;
    private final DocumentManager documentManager;
    private final DiagnosticService diagnosticService;
    private Integer version;

    public IntinoWorkspaceService(Language language, DocumentManager documentManager, DiagnosticService diagnosticService) {
        this.language = language;
        this.documentManager = documentManager;
        this.diagnosticService = diagnosticService;
        this.version = 0;
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        List list = this.documentManager.all().stream().map(u -> new WorkspaceSymbol(u.getPath(), SymbolKind.File, Either.forRight((Object)new WorkspaceSymbolLocation(u.toString())))).collect(Collectors.toList());
        list.addAll(this.documentManager.folders().stream().map(u -> new WorkspaceSymbol(u.getPath(), SymbolKind.Package, Either.forRight((Object)new WorkspaceSymbolLocation(u.toString())))).toList());
        return CompletableFuture.completedFuture(Either.forRight(list));
    }

    public CompletableFuture<WorkspaceEdit> willCreateFiles(CreateFilesParams params) {
        return super.willCreateFiles(params);
    }

    public void didCreateFiles(CreateFilesParams params) {
        params.getFiles().forEach(f -> this.documentManager.upsertDocument(URI.create(f.getUri()), this.language.languageName(), "dsl " + this.language.languageName() + "\n\n"));
    }

    public CompletableFuture<WorkspaceEdit> willDeleteFiles(DeleteFilesParams params) {
        List<DeleteFile> list = params.getFiles().stream().map(f -> new DeleteFile(f.getUri())).toList();
        return CompletableFuture.completedFuture(new WorkspaceEdit(list.stream().map(Either::forRight).collect(Collectors.toList())));
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        try {
            String root = this.documentManager.root().getPath();
            params.getEvent().getAdded().forEach(folder -> new File(root, folder.getUri()).mkdirs());
            for (WorkspaceFolder folder2 : params.getEvent().getRemoved()) {
                FileUtils.deleteDirectory((File)new File(root, folder2.getUri()));
                this.removeContainedDocuments(folder2.getUri());
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void removeContainedDocuments(String uri) {
        this.documentManager.all().stream().filter(u -> u.getPath().startsWith(uri)).forEach(u -> this.documentManager.remove(URI.create(u.getPath())));
    }

    public InputStream content(URI uri) {
        return this.documentManager.getDocumentText(uri);
    }

    public void didDeleteFiles(DeleteFilesParams params) {
        params.getFiles().forEach(f -> this.documentManager.remove(URI.create(f.getUri())));
    }

    public void didRenameFiles(RenameFilesParams params) {
        params.getFiles().forEach(f -> this.documentManager.move(URI.create(f.getOldUri()), URI.create(f.getNewUri())));
    }

    public CompletableFuture<WorkspaceDiagnosticReport> diagnostic(WorkspaceDiagnosticParams params) {
        Map<String, List<Diagnostic>> result = this.diagnosticService.analyzeWorkspace().stream().collect(Collectors.groupingBy(Diagnostic::getSource));
        List<WorkspaceDocumentDiagnosticReport> reports = result.keySet().stream().map(k -> {
            this.version = this.version + 1;
            return new WorkspaceDocumentDiagnosticReport(new WorkspaceFullDocumentDiagnosticReport((List)result.get(k), k, this.version));
        }).toList();
        return CompletableFuture.completedFuture(new WorkspaceDiagnosticReport(reports));
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        System.out.println(params);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        System.out.println(params);
    }
}

