/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.document;

import io.intino.alexandria.logger.Logger;
import io.intino.ls.document.DocumentManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.eclipse.lsp4j.TextDocumentItem;

public class FileDocumentManager
implements DocumentManager {
    private final Object lock = new Object();
    private final File root;

    public FileDocumentManager(File root) throws IOException {
        this.root = root;
    }

    @Override
    public URI root() {
        return this.root.toURI();
    }

    @Override
    public List<URI> all() {
        return this.documents().keySet().stream().toList();
    }

    @Override
    public List<URI> folders() {
        return FileUtils.listFilesAndDirs((File)this.root, (IOFileFilter)this.fileFilter(), (IOFileFilter)this.fileFilter()).stream().filter(f -> !f.getPath().equals(this.root.getPath())).map(this::relativePath).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsertDocument(URI uri, String language, String content) {
        Object object = this.lock;
        synchronized (object) {
            try {
                File file = this.fileOf(uri);
                file.getParentFile().mkdirs();
                Files.writeString(file.toPath(), (CharSequence)content, new OpenOption[0]);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getDocumentText(URI uri) {
        Object object = this.lock;
        synchronized (object) {
            TextDocumentItem document = this.documents().get(uri);
            return document != null ? new ByteArrayInputStream(document.getText().getBytes()) : null;
        }
    }

    @Override
    public void move(URI oldUri, URI newUri) {
        try {
            File file = this.fileOf(oldUri);
            List<TextDocumentItem> textDocumentItems = this.documents().values().stream().filter(d -> d.getUri().startsWith(oldUri.getPath() + "/") || d.getUri().equals(oldUri.getPath())).toList();
            textDocumentItems.forEach(d -> this.move((TextDocumentItem)d, oldUri, newUri));
            if (file.isDirectory()) {
                Files.delete(file.toPath());
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void move(TextDocumentItem item, URI oldUri, URI newUri) {
        if (item != null) {
            try {
                URI uri = URI.create(item.getUri().replace(oldUri.getPath(), newUri.getPath()));
                File file = this.fileOf(uri);
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                Files.move(this.fileOf(URI.create(item.getUri())).toPath(), file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    @Override
    public void remove(URI uri) {
        File file = this.fileOf(uri);
        if (file.isFile()) {
            file.delete();
        } else {
            FileDocumentManager.removeDirectory(file);
        }
    }

    private static void removeDirectory(File file) {
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String content(File f) {
        try {
            return Files.readString(f.toPath());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    private File fileOf(URI uri) {
        return new File(this.root, uri.getPath());
    }

    private Map<URI, TextDocumentItem> documents() {
        return this.loadDocuments(this.root);
    }

    private Map<URI, TextDocumentItem> loadDocuments(File projectRoot) {
        return FileUtils.listFiles((File)projectRoot, null, (boolean)true).stream().filter(File::isFile).filter(f -> !f.getName().startsWith(".")).collect(Collectors.toMap(this::relativePath, this::documentItem, (a, b) -> a, ConcurrentHashMap::new));
    }

    private TextDocumentItem documentItem(File f) {
        return new TextDocumentItem(this.relativePath(f).getPath(), FileDocumentManager.languageOf(f), (int)f.lastModified(), this.content(f));
    }

    public static String languageOf(File f) {
        try {
            if (!f.exists()) {
                return "";
            }
            if (f.getName().endsWith(".tara")) {
                return Files.lines(f.toPath()).filter(l -> !l.trim().isEmpty()).findFirst().orElse("");
            }
            return FileDocumentManager.extensionOf(f);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    public static String extensionOf(File f) {
        String fileName = f.getName();
        int lastIndex = fileName.lastIndexOf(46);
        return lastIndex > 0 && lastIndex < fileName.length() - 1 ? fileName.substring(lastIndex + 1) : "";
    }

    private IOFileFilter fileFilter() {
        return new IOFileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && !file.getPath().equals(FileDocumentManager.this.root.getPath());
            }

            public boolean accept(File file, String s) {
                return true;
            }
        };
    }

    private URI relativePath(File f) {
        return URI.create(this.root.toPath().relativize(f.toPath()).toFile().getPath());
    }
}

