/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.completion;

import io.intino.alexandria.logger.Logger;
import io.intino.ls.IntinoDocumentService;
import io.intino.ls.codeinsight.completion.AnnotationCompletionProvider;
import io.intino.ls.codeinsight.completion.BodyCompletionProvider;
import io.intino.ls.codeinsight.completion.CompletionContext;
import io.intino.ls.codeinsight.completion.CompletionProvider;
import io.intino.ls.codeinsight.completion.CompletionUtils;
import io.intino.ls.codeinsight.completion.ContextFilters;
import io.intino.ls.codeinsight.completion.TreeUtils;
import io.intino.ls.parsing.CompletionErrorStrategy;
import io.intino.ls.parsing.Parser;
import io.intino.tara.Language;
import io.intino.tara.Source;
import io.intino.tara.language.grammar.SyntaxException;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Mogram;
import io.intino.tara.processors.Resolver;
import io.intino.tara.processors.model.Model;
import io.intino.tara.processors.parser.antlr.ModelGenerator;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Position;

public class CompletionService {
    public static final String TARA_FAKE_TOKEN = "Tara_Fake_Token";
    private final Map<Predicate<CompletionContext>, CompletionProvider> map = new LinkedHashMap<Predicate<CompletionContext>, CompletionProvider>();

    public CompletionService() {
        this.map.put(ContextFilters.afterIs, (context, result) -> {
            if (!(context.ruleOnPosition() instanceof TaraGrammar.MetaidentifierContext)) {
                return;
            }
            CompletionUtils completionUtils = new CompletionUtils(context);
            Element element = context.elementOnPosition();
            if (element instanceof Mogram) {
                Mogram m = (Mogram)element;
                result.addAll(completionUtils.collectAllowedFacets(m));
            }
        });
        this.map.put(ContextFilters.afterNewLineInBody, new BodyCompletionProvider());
        this.map.put(ContextFilters.afterAs, new AnnotationCompletionProvider());
        this.map.put(ContextFilters.afterNewLine, (context, result) -> {
            Element element = context.elementOnPosition();
            if (element instanceof Mogram) {
                Mogram m = (Mogram)element;
                if (((String)((Mogram)element).types().get(0)).equals(TARA_FAKE_TOKEN)) {
                    element = m.container();
                }
            }
            if (element instanceof ElementContainer) {
                ElementContainer ec = (ElementContainer)element;
                new Resolver(context.language()).resolve(ec);
                result.addAll(new CompletionUtils(context).collectAllowedComponents(ec));
            }
        });
        this.map.put(ContextFilters.afterMogramIdentifier, (context, result) -> {
            result.add(CompletionProvider.create("extends ", CompletionItemKind.Keyword));
            result.add(CompletionProvider.create("is ", CompletionItemKind.Keyword));
            result.add(CompletionProvider.create("as ", CompletionItemKind.Keyword));
        });
        this.map.put(ContextFilters.inParameters, (context, result) -> {
            Element patt0$temp = context.elementOnPosition();
            if (patt0$temp instanceof Mogram) {
                Mogram m = (Mogram)patt0$temp;
                new Resolver(context.language()).resolve((ElementContainer)m);
                result.addAll(new CompletionUtils(context).collectSignatureParameters(m));
            }
        });
    }

    public List<CompletionItem> propose(CompletionContext params) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        this.map.keySet().stream().filter(p -> p.test(params)).forEach(p -> this.map.get(p).addCompletions(params, items));
        return items;
    }

    public static CompletionContext completionContextOf(CompletionParams params, Language language, Source.StringSource originalDoc) {
        try {
            URI uri = URI.create(IntinoDocumentService.normalize(params.getTextDocument().getUri()));
            Position position = params.getPosition();
            position.setLine(position.getLine() + 1);
            String fakeDoc = new StringBuilder(originalDoc.stringContent()).insert(CompletionService.indexOf(position, originalDoc.stringContent()), TARA_FAKE_TOKEN).toString();
            Source.StringSource source = new Source.StringSource(originalDoc.uri().getPath(), fakeDoc);
            Parser parser = new Parser((Source)source, new CompletionErrorStrategy());
            CommonTokenStream tokens = parser.tokens();
            TaraGrammar.RootContext tree = parser.parse(tokens);
            Model model = CompletionService.convert(source, tree);
            Token token = TreeUtils.findToken((TokenStream)tokens, position.getLine(), params.getPosition().getCharacter());
            ParserRuleContext ctx = token == null ? null : TreeUtils.findNodeContainingToken((ParserRuleContext)tree, token);
            return new CompletionContext(uri, language, params.getPosition(), (Element)TreeUtils.getMogramContainerOn(model, params.getPosition()), token, ctx, params.getContext().getTriggerCharacter());
        }
        catch (SyntaxException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public static Model convert(Source.StringSource source, TaraGrammar.RootContext rootContext) throws SyntaxException {
        try {
            ModelGenerator extractor = new ModelGenerator((Source)source);
            new ParseTreeWalker().walk((ParseTreeListener)extractor, (ParseTree)rootContext);
            return extractor.getModel();
        }
        catch (RecognitionException e) {
            return null;
        }
    }

    private static int indexOf(Position position, String textDoc) {
        String[] lines = textDoc.split("\n", -1);
        if (position.getLine() < 1 || position.getLine() > lines.length) {
            return -1;
        }
        if (position.getCharacter() < 0 || position.getCharacter() > lines[position.getLine() - 1].length() + 1) {
            return -1;
        }
        int absoluteIndex = 0;
        for (int i = 0; i < position.getLine() - 1; ++i) {
            absoluteIndex += lines[i].length() + 1;
        }
        return absoluteIndex + position.getCharacter();
    }
}

