/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight;

import io.intino.ls.ModelUnit;
import io.intino.tara.Language;
import io.intino.tara.model.Element;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.MogramReference;
import java.net.URI;
import java.util.Map;
import org.eclipse.lsp4j.Position;

public class ReferenceResolver {
    private final Map<URI, ModelUnit> models;
    private final Language language;

    public ReferenceResolver(Map<URI, ModelUnit> models, Language language) {
        this.models = models;
        this.language = language;
    }

    public Element resolveToDeclaration(URI referenceUri, Position referencePosition) {
        MogramReference m;
        ModelUnit modelUnit = this.models.get(referenceUri);
        if (modelUnit == null) {
            return null;
        }
        Element rerefenceElement = ReferenceResolver.findMogramContainingToken((Element)modelUnit.model(), referencePosition);
        if (rerefenceElement == null) {
            return null;
        }
        if (rerefenceElement instanceof MogramReference && (m = (MogramReference)rerefenceElement).target().resolved()) {
            return (Element)m.target().get();
        }
        return null;
    }

    public static Element findMogramContainingToken(Element element, Position position) {
        if (ReferenceResolver.isInRange(element, position)) {
            if (element instanceof ElementContainer) {
                ElementContainer ec = (ElementContainer)element;
                for (Element e : ec.elements()) {
                    Element result = ReferenceResolver.findMogramContainingToken(e, position);
                    if (result == null) continue;
                    return result;
                }
            }
            if (element instanceof MogramReference) {
                MogramReference mr = (MogramReference)element;
                return element;
            }
        }
        return null;
    }

    private static boolean isInRange(Element mogram, Position position) {
        return mogram != null && mogram.textRange().startLine() <= position.getLine() && position.getLine() <= mogram.textRange().endLine();
    }
}

