/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.document;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.ssh.jsch.JschConfigSessionFactory;
import org.eclipse.jgit.transport.ssh.jsch.OpenSshConfig;
import org.eclipse.jgit.util.FS;

public class GitRepository {
    public static final String REMOTE = "origin";
    private final CredentialsProvider credentialsProvider;
    private final String branch;
    private final Git git;
    private static final CustomJschConfigSessionFactory sshFactory = new CustomJschConfigSessionFactory();
    private static final TransportConfigCallback configCallback;

    public GitRepository(File directory, String remoteUri, CredentialsProvider credentialsProvider, String branch) throws GitAPIException, URISyntaxException {
        this.credentialsProvider = credentialsProvider;
        this.branch = branch;
        this.git = new File(directory, ".git").exists() ? this.init(directory, remoteUri, branch) : this.clone(directory, remoteUri, branch);
    }

    private Git clone(File directory, String remoteUri, String branch) throws GitAPIException {
        Logger.debug((String)("Cloning repository " + remoteUri + " : " + branch));
        return ((CloneCommand)((CloneCommand)Git.cloneRepository().setCredentialsProvider(this.credentialsProvider)).setTransportConfigCallback(configCallback)).setDirectory(directory).setURI(remoteUri).setRemote(REMOTE).setNoTags().setBranch(branch).call();
    }

    private Git init(File directory, String remoteUri, String branch) throws GitAPIException, URISyntaxException {
        if (remoteUri == null) {
            return null;
        }
        Git git = Git.init().setDirectory(directory).setInitialBranch(branch).call();
        git.remoteSetUrl().setRemoteName(REMOTE).setRemoteUri(new URIish(remoteUri)).call();
        ((FetchCommand)git.fetch().setCredentialsProvider(this.credentialsProvider)).setRemote(REMOTE).call();
        return git;
    }

    public PullResult checkoutAndPull() {
        this.checkout(this.branch);
        return this.pull();
    }

    public RevCommit commit(String user) throws GitAPIException {
        Logger.debug((String)"Commiting...");
        return this.git.commit().setMessage("Commit done by " + user).setCredentialsProvider(this.credentialsProvider).setAuthor(new PersonIdent("Tu Nombre", "tu-email@ejemplo.com")).call();
    }

    public PullResult pull() {
        try {
            Logger.debug((String)"Pulling repository...");
            org.eclipse.jgit.api.PullResult result = ((PullCommand)this.git.pull().setCredentialsProvider(this.credentialsProvider)).setRebase(true).setRemote(REMOTE).call();
            if (result.isSuccessful() && result.getRebaseResult().getStatus().equals((Object)RebaseResult.Status.FAST_FORWARD)) {
                return PullResult.FAST_FORWARD;
            }
            Logger.debug((String)"Repository pulled successfully");
            return PullResult.UP_TO_DATE;
        }
        catch (GitAPIException e) {
            Logger.error((Throwable)e);
            return PullResult.UP_TO_DATE;
        }
    }

    public List<PushResult> push() {
        try {
            Logger.debug((String)"Pushing changes to remote repository...");
            Iterable result = ((PushCommand)this.git.push().setCredentialsProvider(this.credentialsProvider)).setRemote(REMOTE).call();
            return StreamSupport.stream(result.spliterator(), false).toList();
        }
        catch (GitAPIException e) {
            Logger.error((Throwable)e);
            return List.of();
        }
    }

    public GitRepository checkout(String branch) {
        try {
            ((FetchCommand)((FetchCommand)this.git.fetch().setCredentialsProvider(this.credentialsProvider)).setTransportConfigCallback(configCallback)).call();
            Logger.debug((String)("Checking out to branch " + branch));
            List call = this.git.branchList().call();
            this.git.checkout().setCreateBranch(call.stream().noneMatch(b -> b.getName().endsWith("/" + branch))).setName(branch).call();
            Logger.debug((String)("Repository checked out to " + branch + " successfully"));
        }
        catch (GitAPIException e) {
            Logger.error((Throwable)e);
        }
        return this;
    }

    static {
        SshSessionFactory.setInstance((SshSessionFactory)sshFactory);
        configCallback = transport -> {
            if (transport instanceof SshTransport) {
                SshTransport t = (SshTransport)transport;
                t.setSshSessionFactory((SshSessionFactory)sshFactory);
            }
        };
    }

    public static enum PullResult {
        UP_TO_DATE,
        FAST_FORWARD;

    }

    public static class CustomJschConfigSessionFactory
    extends JschConfigSessionFactory {
        protected void configure(OpenSshConfig.Host host, Session session) {
            session.setConfig("StrictHostKeyChecking", "false");
            session.setConfig("StrictHostKeyChecking", "no");
        }

        protected JSch createDefaultJSch(FS fs) throws JSchException {
            JSch defaultJSch = super.createDefaultJSch(fs);
            defaultJSch.removeAllIdentity();
            File home = fs.userHome();
            try {
                defaultJSch.addIdentity(new File(home, ".ssh/id_rsa").getAbsolutePath());
                defaultJSch.setKnownHosts(new File(home, ".ssh/known_hosts").getAbsolutePath());
                File config = new File(home, ".ssh/config");
                if (config.exists()) {
                    defaultJSch.setConfigRepository((ConfigRepository)OpenSSHConfig.parseFile((String)config.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
            return defaultJSch;
        }
    }
}

