/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.restful.core;

import io.intino.konos.Resource;
import io.intino.konos.restful.RestfulApi;
import io.intino.konos.restful.core.Signer;
import io.intino.konos.restful.exceptions.RestfulFailure;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.HttpClientBuilder;

public class RestfulAccessor
implements RestfulApi {
    @Override
    public RestfulApi.Response get(URL url, String path) throws RestfulFailure {
        return this.get(url, path, Collections.emptyMap());
    }

    @Override
    public RestfulApi.Response get(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doGet(url, path, this.parametersToNameValuePairs(parameters));
    }

    @Override
    public Resource getResource(URL url, String path) throws RestfulFailure {
        return this.doGetFile(url, path, Collections.emptyList());
    }

    @Override
    public Resource getResource(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doGetFile(url, path, this.parametersToNameValuePairs(parameters));
    }

    @Override
    public RestfulApi.Response post(URL url, String path) throws RestfulFailure {
        return this.post(url, path, Collections.emptyMap());
    }

    @Override
    public RestfulApi.Response post(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doPost(url, path, this.entityOf(parameters));
    }

    @Override
    public RestfulApi.Response post(URL url, String path, Resource resource) throws RestfulFailure {
        return this.doPost(url, path, this.multipartEntityOf(resource));
    }

    @Override
    public RestfulApi.Response put(URL url, String path) throws RestfulFailure {
        return this.put(url, path, Collections.emptyMap());
    }

    @Override
    public RestfulApi.Response put(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doPut(url, path, this.entityOf(parameters));
    }

    @Override
    public RestfulApi.Response put(URL url, String path, Resource resource) throws RestfulFailure {
        return this.doPut(url, path, this.multipartEntityOf(resource));
    }

    @Override
    public RestfulApi.Response delete(URL url, String path) throws RestfulFailure {
        return this.doDelete(url, path, Collections.emptyList());
    }

    @Override
    public RestfulApi.Response delete(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doDelete(url, path, this.parametersToNameValuePairs(parameters));
    }

    @Override
    public RestfulApi.RestfulSecureConnection secure(final URL url, final URL certificate, final String password) {
        return new RestfulApi.RestfulSecureConnection(){

            @Override
            public RestfulApi.Response get(String path) throws RestfulFailure {
                return this.get(path, Collections.emptyMap());
            }

            @Override
            public RestfulApi.Response get(String path, Map<String, String> parameters) throws RestfulFailure {
                List getParameters = RestfulAccessor.this.parametersToNameValuePairs(parameters);
                getParameters.addAll(RestfulAccessor.this.parametersToNameValuePairs(RestfulAccessor.this.secureParameters(new HashMap<String, String>(parameters), certificate, password)));
                return RestfulAccessor.this.doGet(url, path, getParameters);
            }

            @Override
            public Resource getResource(String path) throws RestfulFailure {
                return RestfulAccessor.this.doGetFile(url, path, RestfulAccessor.this.parametersToNameValuePairs(RestfulAccessor.this.secureParameters(Collections.emptyMap(), certificate, password)));
            }

            @Override
            public Resource getResource(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestfulAccessor.this.doGetFile(url, path, RestfulAccessor.this.parametersToNameValuePairs(RestfulAccessor.this.secureParameters(parameters, certificate, password)));
            }

            @Override
            public RestfulApi.Response post(String path) throws RestfulFailure {
                return this.post(path, Collections.emptyMap());
            }

            @Override
            public RestfulApi.Response post(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestfulAccessor.this.doPost(url, path, this.entityOf(parameters));
            }

            @Override
            public RestfulApi.Response post(String path, Resource resource) throws RestfulFailure {
                return RestfulAccessor.this.doPost(url, path, RestfulAccessor.this.multipartEntityOf(resource));
            }

            @Override
            public RestfulApi.Response put(String path) throws RestfulFailure {
                return this.put(path, Collections.emptyMap());
            }

            @Override
            public RestfulApi.Response put(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestfulAccessor.this.doPut(url, path, this.entityOf(parameters));
            }

            @Override
            public RestfulApi.Response delete(String path) throws RestfulFailure {
                return this.delete(path, Collections.emptyMap());
            }

            @Override
            public RestfulApi.Response delete(String path, Map<String, String> parameters) throws RestfulFailure {
                List getParameters = RestfulAccessor.this.parametersToNameValuePairs(parameters);
                getParameters.addAll(RestfulAccessor.this.parametersToNameValuePairs(RestfulAccessor.this.secureParameters(new HashMap<String, String>(parameters), certificate, password)));
                return RestfulAccessor.this.doDelete(url, path, getParameters);
            }

            private HttpEntity entityOf(Map<String, String> parameters) throws RestfulFailure {
                try {
                    List entityParameters = RestfulAccessor.this.parametersToNameValuePairs(parameters);
                    entityParameters.addAll(RestfulAccessor.this.parametersToNameValuePairs(RestfulAccessor.this.secureParameters(new HashMap<String, String>(parameters), certificate, password)));
                    return new UrlEncodedFormEntity(entityParameters, "UTF-8");
                }
                catch (UnsupportedEncodingException exception) {
                    throw new RestfulFailure(exception.getMessage());
                }
            }
        };
    }

    private String pathUrl(URL url, String path) {
        String baseUrl = url.toString();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl + (path.startsWith("/") ? path : "/" + path);
    }

    private HttpClient client() {
        return HttpClientBuilder.create().build();
    }

    private RestfulApi.Response doGet(URL url, String path, List<NameValuePair> parameters) throws RestfulFailure {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.pathUrl(url, path)).setParameters(parameters);
            return this.executeMethod(url, (HttpRequestBase)new HttpGet(uriBuilder.build().toURL().toString()));
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
    }

    private Resource doGetFile(URL url, String path, List<NameValuePair> parameters) throws RestfulFailure {
        try {
            HttpResponse response;
            URIBuilder uriBuilder = new URIBuilder(this.pathUrl(url, path)).setParameters(parameters);
            try {
                response = this.client().execute((HttpUriRequest)new HttpGet(uriBuilder.build().toURL().toString()));
            }
            catch (IOException exception) {
                throw new RestfulFailure(exception.getMessage());
            }
            int status = response.getStatusLine().getStatusCode();
            if (status < 200 || status >= 300) {
                String errorMessage = response.containsHeader("error-message") ? response.getFirstHeader("error-message").getValue() : "";
                String format = String.format("%s => %d - %s", url, status, response.getStatusLine().getReasonPhrase() + ". " + errorMessage);
                throw new RestfulFailure(String.valueOf(status), format);
            }
            HttpEntity entity = response.getEntity();
            return new Resource(response.getFirstHeader("Content-Disposition").getValue(), entity.getContentType().getValue(), entity.getContent());
        }
        catch (IOException | URISyntaxException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
    }

    private RestfulApi.Response doPost(URL url, String path, HttpEntity entity) throws RestfulFailure {
        HttpPost post = new HttpPost(this.pathUrl(url, path));
        post.setEntity(entity);
        return this.executeMethod(url, (HttpRequestBase)post);
    }

    private RestfulApi.Response doPut(URL url, String path, HttpEntity entity) throws RestfulFailure {
        HttpPut put = new HttpPut(this.pathUrl(url, path));
        put.setEntity(entity);
        return this.executeMethod(url, (HttpRequestBase)put);
    }

    private RestfulApi.Response doDelete(URL url, String path, List<NameValuePair> parameters) throws RestfulFailure {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.pathUrl(url, path)).setParameters(parameters);
            return this.executeMethod(url, (HttpRequestBase)new HttpDelete(uriBuilder.build().toURL().toString()));
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
    }

    private RestfulApi.Response executeMethod(URL url, HttpRequestBase method) throws RestfulFailure {
        HttpResponse response;
        try {
            response = this.client().execute((HttpUriRequest)method);
        }
        catch (IOException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
        int status = response.getStatusLine().getStatusCode();
        if (status < 200 || status >= 300) {
            String errorMessage = response.containsHeader("error-message") ? response.getFirstHeader("error-message").getValue() : "";
            String format = String.format("%s => %d - %s", url, status, response.getStatusLine().getReasonPhrase() + ". " + errorMessage);
            throw new RestfulFailure(String.valueOf(status), format);
        }
        return this.responseOf(response);
    }

    private HttpEntity entityOf(Map<String, String> parameters) throws RestfulFailure {
        try {
            return new UrlEncodedFormEntity(this.parametersToNameValuePairs(parameters), "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
    }

    private HttpEntity multipartEntityOf(Resource resource) throws RestfulFailure {
        return this.multipartEntityOf(resource, null, null);
    }

    private HttpEntity multipartEntityOf(Resource resource, URL certificate, String password) throws RestfulFailure {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setContentType(ContentType.MULTIPART_FORM_DATA);
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.setCharset(Charset.forName("UTF-8"));
        this.addContent(entityBuilder, resource);
        this.addParameters(entityBuilder, resource);
        this.addSecureParameters(certificate, password, entityBuilder, resource);
        return entityBuilder.build();
    }

    private List<NameValuePair> parametersToNameValuePairs(Map<String, String> parameters) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        parameters.forEach((name, value) -> result.add(new NameValuePair((String)name, (String)value){
            final /* synthetic */ String val$name;
            final /* synthetic */ String val$value;
            {
                this.val$name = string;
                this.val$value = string2;
            }

            public String getName() {
                return this.val$name;
            }

            public String getValue() {
                return this.val$value;
            }
        }));
        return result;
    }

    private void addContent(MultipartEntityBuilder builder, Resource resource) throws RestfulFailure {
        builder.addPart("content", (ContentBody)new InputStreamBody(resource.content(), resource.contentType()));
    }

    private void addParameters(MultipartEntityBuilder builder, Resource resource) throws RestfulFailure {
        resource.parameters().entrySet().forEach(param -> builder.addPart((String)param.getKey(), (ContentBody)new StringBody((String)param.getValue(), ContentType.APPLICATION_JSON)));
    }

    private void addSecureParameters(URL certificate, String password, MultipartEntityBuilder entityBuilder, Resource resource) throws RestfulFailure {
        if (certificate == null) {
            return;
        }
        try {
            Map<String, String> secureParameters = this.secureParameters(this.parametersOf(resource), certificate, password);
            secureParameters.forEach((name, value) -> entityBuilder.addTextBody(name, value, ContentType.TEXT_PLAIN));
        }
        catch (Exception exception) {
            throw new RestfulFailure(String.format("Could not sign with certificate: %s", certificate.toString()));
        }
    }

    private Map<String, String> parametersOf(final Resource resource) {
        return new HashMap<String, String>(){
            {
                this.put("contentType", resource.contentType());
                resource.parameters().entrySet().forEach((? super T entry) -> {
                    String cfr_ignored_0 = (String)this.put(entry.getKey(), entry.getValue());
                });
            }
        };
    }

    private Map<String, String> secureParameters(Map<String, String> parameters, URL certificate, String password) throws RestfulFailure {
        if (certificate == null) {
            return Collections.emptyMap();
        }
        try {
            Signer signer = new Signer();
            long timestamp = new Date().getTime();
            String hash = signer.hash(parameters, timestamp);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("timestamp", String.valueOf(timestamp));
            result.put("hash", hash);
            result.put("signature", signer.sign(hash, certificate, password));
            return result;
        }
        catch (Exception exception) {
            throw new RestfulFailure(String.format("Could not sign with certificate: %s", certificate.toString()));
        }
    }

    private RestfulApi.Response responseOf(final HttpResponse response) {
        return new RestfulApi.Response(){

            @Override
            public String content() {
                try {
                    if (response == null) {
                        return null;
                    }
                    return this.stringContentOf(response.getEntity().getContent());
                }
                catch (IOException e) {
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String stringContentOf(InputStream input) {
                BufferedReader buffer = null;
                StringBuilder sb = new StringBuilder();
                try {
                    String line;
                    buffer = new BufferedReader(new InputStreamReader(input));
                    while ((line = buffer.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (buffer != null) {
                        try {
                            buffer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return sb.toString();
            }
        };
    }
}

