/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.filesproxy.core;

import io.intino.konos.filesproxy.FilesApi;
import io.intino.konos.filesproxy.exceptions.FilesApiFailure;
import io.intino.konos.restful.RestfulApi;
import io.intino.konos.restful.core.Resource;
import io.intino.konos.restful.core.RestfulAccessor;
import io.intino.konos.restful.exceptions.RestfulFailure;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public class FilesAccessor
implements FilesApi {
    private final String basePath;
    private RestfulApi client;

    public FilesAccessor() {
        this("/file");
    }

    public FilesAccessor(String basePath) {
        this.basePath = this.normalize(basePath);
        this.client = new RestfulAccessor();
    }

    @Override
    public FilesApi.Connection connect(String url) {
        return this.connect(url, null, null);
    }

    @Override
    public FilesApi.Connection connect(final String url, final URL certificate, final String password) {
        return new FilesApi.Connection(){
            private RestfulApi.RestfulSecureConnection connection = null;

            @Override
            public String upload(Resource resource) throws FilesApiFailure {
                return this.upload("", resource);
            }

            @Override
            public String upload(String path, Resource resource) throws FilesApiFailure {
                try {
                    RestfulApi.Response response = this.secure().post(this.pathOf(path), resource);
                    return response.content();
                }
                catch (RestfulFailure error) {
                    throw new FilesApiFailure(error.getMessage());
                }
            }

            @Override
            public String upload(InputStream content, String contentType) throws FilesApiFailure {
                return this.upload(this.resourceOf(content, contentType, Collections.emptyMap()));
            }

            @Override
            public String upload(String path, InputStream content, String contentType) throws FilesApiFailure {
                return this.upload(path, this.resourceOf(content, contentType, Collections.emptyMap()));
            }

            @Override
            public String upload(InputStream content, String contentType, Map<String, String> parameters) throws FilesApiFailure {
                return this.upload(this.resourceOf(content, contentType, parameters));
            }

            @Override
            public String upload(String path, InputStream content, String contentType, Map<String, String> parameters) throws FilesApiFailure {
                return this.upload(path, this.resourceOf(content, contentType, parameters));
            }

            @Override
            public Resource download(String id) throws FilesApiFailure {
                return this.download("", id);
            }

            @Override
            public Resource download(String path, String id) throws FilesApiFailure {
                try {
                    return this.secure().getResource(String.format("%s/%s", this.pathOf(path), id));
                }
                catch (RestfulFailure error) {
                    throw new FilesApiFailure(error.getMessage());
                }
            }

            private RestfulApi.RestfulSecureConnection secure() throws FilesApiFailure {
                try {
                    if (this.connection == null) {
                        this.connection = FilesAccessor.this.client.secure(new URL(url), certificate, password);
                    }
                    return this.connection;
                }
                catch (MalformedURLException error) {
                    throw new FilesApiFailure(error.getMessage());
                }
            }

            private Resource resourceOf(InputStream content, String contentType, Map<String, String> parameters) {
                Resource resource = new Resource(content, contentType);
                parameters.entrySet().forEach(entry -> resource.addParameter((String)entry.getKey(), (String)entry.getValue()));
                return resource;
            }

            private String pathOf(String path) {
                String result = FilesAccessor.this.basePath + (path.startsWith("/") ? path : "/" + path);
                if (result.endsWith("/")) {
                    result = result.substring(0, result.length() - 1);
                }
                return result;
            }
        };
    }

    private String normalize(String basePath) {
        String path;
        String string = path = basePath.endsWith("/") ? basePath.substring(0, basePath.length() - 1) : basePath;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }
}

