/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.rest.spark;

import io.intino.konos.alexandria.rest.spark.RequestAdapter;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;

class SparkReader {
    SparkReader() {
    }

    static <T> T read(String object, Type type) {
        Class rawType = (Class)((ParameterizedType)type).getRawType();
        if (Collection.class.isAssignableFrom(rawType)) {
            return SparkReader.readList(object, type);
        }
        return SparkReader.read(object, rawType);
    }

    private static <T> T readList(String object, Type type) {
        return RequestAdapter.adaptFromJSON(object, type);
    }

    static <T> T read(String object, Class<T> type) {
        if (type.isAssignableFrom(Error.class) || Collection.class.isAssignableFrom(type)) {
            return RequestAdapter.adaptFromJSON(object, type);
        }
        if (type.isAssignableFrom(byte[].class)) {
            return (T)SparkReader.readBytes(object);
        }
        return RequestAdapter.adapt(object, type);
    }

    static <T> T read(Object object, Class<T> type) {
        return (T)(type.isAssignableFrom(InputStream.class) ? object : null);
    }

    private static byte[] readBytes(String object) {
        return object.getBytes(Charset.forName("UTF-8"));
    }
}

