/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.rest;

import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.rest.security.AlexandriaSecurityManager;
import io.intino.konos.alexandria.rest.security.NullSecurityManager;
import io.intino.konos.alexandria.rest.spark.PushService;
import io.intino.konos.alexandria.rest.spark.SparkManager;
import io.intino.konos.alexandria.rest.spark.SparkRouter;
import java.util.function.Consumer;
import spark.Service;

public class AlexandriaSpark<R extends SparkRouter> {
    private AlexandriaSecurityManager securityManager = new NullSecurityManager();
    protected final String webDirectory;
    protected PushService pushService;
    protected static final String WebDirectory = "/www";
    protected Service service;
    protected int port;

    public AlexandriaSpark(int port) {
        this(port, WebDirectory);
    }

    public AlexandriaSpark(int port, String webDirectory) {
        this.port = port;
        this.webDirectory = webDirectory;
        this.service = Service.ignite();
        this.configureStaticFiles();
        this.service.port(this.port);
    }

    public AlexandriaSpark start() {
        this.service.init();
        return this;
    }

    public void stop() {
        if (this.service != null) {
            this.service.stop();
        }
        this.service = null;
    }

    public String webDirectory() {
        return this.webDirectory;
    }

    public void secure(AlexandriaSecurityManager manager) {
        this.securityManager = manager;
    }

    public R route(String path) {
        R router = this.createRouter(path);
        ((SparkRouter)router).inject(this.pushService);
        ((SparkRouter)router).whenRegisterPushService(this.pushServiceConsumer());
        ((SparkRouter)router).whenValidate(manager -> this.securityManager.check(manager.fromQuery("hash", String.class), manager.fromQuery("signature", String.class)));
        return router;
    }

    private Consumer<PushService> pushServiceConsumer() {
        return pushService -> {
            this.pushService = pushService;
        };
    }

    protected R createRouter(String path) {
        return (R)new SparkRouter(this.service, path);
    }

    protected void configureStaticFiles() {
        if (this.isInClasspath(this.webDirectory)) {
            this.service.staticFileLocation(this.webDirectory);
        } else {
            this.service.externalStaticFileLocation(this.webDirectory);
        }
    }

    private boolean isInClasspath(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path) != null;
    }

    public static interface ResourceCaller<SM extends SparkManager> {
        public void call(SM var1) throws AlexandriaException;
    }
}

