/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.rest.spark;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.intino.konos.alexandria.Error;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class ResponseAdapter {
    public static String adapt(Object object) {
        if (object instanceof java.lang.Error) {
            return ResponseAdapter.adaptError((Error)object);
        }
        if (object instanceof Collection) {
            return ResponseAdapter.jsonArray((Collection)object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return ResponseAdapter.toJson(object).toString();
    }

    private static String jsonArray(Collection<Object> objects) {
        JsonArray result = new JsonArray();
        for (Object value : objects) {
            result.add(ResponseAdapter.toJson(value));
        }
        return result.toString();
    }

    private static JsonElement toJson(Object value) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Instant.class, (instant, type, context) -> new JsonPrimitive((Number)instant.toEpochMilli())).registerTypeAdapter(Date.class, (date, type, context) -> new JsonPrimitive((Number)date.getTime()));
        return gsonBuilder.create().toJsonTree(value);
    }

    private static String adaptError(Error error) {
        JsonObject object = new JsonObject();
        object.addProperty("code", error.code());
        object.addProperty("label", error.label());
        ResponseAdapter.adaptParameters(object, error.parameters());
        return object.toString();
    }

    private static void adaptParameters(JsonObject object, Map<String, String> parameters) {
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            object.addProperty(parameter.getKey(), parameter.getValue());
        }
    }
}

