/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.rest.security;

import io.intino.konos.alexandria.rest.security.AlexandriaSecurityManager;
import io.intino.konos.alexandria.rest.security.CertificateVerifier;
import java.io.File;
import org.apache.commons.codec.binary.Base64;

public class DefaultSecurityManager
implements AlexandriaSecurityManager {
    private final File certificateStore;
    private final String password;

    public DefaultSecurityManager(File certificateStore, String password) {
        this.certificateStore = certificateStore;
        this.password = password;
    }

    @Override
    public boolean check(String hash, String signature) {
        try {
            byte[] signatureBytes = Base64.decodeBase64((String)signature);
            String originalContent = CertificateVerifier.getOriginalContentFromSignature(signatureBytes);
            return originalContent != null && hash.equals(originalContent) && CertificateVerifier.checkRootCertificate(signatureBytes, this.certificateStore, CertificateVerifier.TYPE_PKCS.PKCS7, this.password);
        }
        catch (Exception e) {
            return false;
        }
    }
}

