/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.rest.spark;

import io.intino.konos.alexandria.rest.pushservice.Client;
import io.intino.konos.alexandria.rest.pushservice.Session;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class SparkSession<C extends Client>
implements Session<C> {
    private final Map<String, C> clientsMap = new HashMap<String, C>();
    private final String id;
    private String currentClient;
    private Function<String, String> loginListener;
    private Consumer<Boolean> logoutListener;

    public SparkSession(String id) {
        this.id = id;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public List<C> clients() {
        return (List)this.clientsMap.values();
    }

    @Override
    public C client(String id) {
        return (C)((Client)this.clientsMap.get(id));
    }

    @Override
    public C currentClient() {
        return (C)((Client)this.clientsMap.get(this.currentClient));
    }

    @Override
    public void currentClient(C client) {
        this.currentClient = client != null ? client.id() : null;
    }

    @Override
    public void add(C client) {
        this.clientsMap.put(client.id(), client);
    }

    @Override
    public void remove(C client) {
        if (!this.clientsMap.containsKey(client.id())) {
            return;
        }
        this.clientsMap.remove(client.id());
        this.currentClient = null;
    }

    @Override
    public void send(String message) {
        this.clientsMap.values().forEach(client -> client.send(message));
    }

    public void whenLogin(Function<String, String> listener) {
        this.loginListener = listener;
    }

    public void whenLogout(Consumer<Boolean> listener) {
        this.logoutListener = listener;
    }

    @Override
    public String login(String baseUrl) {
        if (this.loginListener != null) {
            return this.loginListener.apply(baseUrl);
        }
        return null;
    }

    @Override
    public void logout() {
        if (this.logoutListener != null) {
            this.logoutListener.accept(true);
        }
    }
}

