/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.rest.spark;

import io.intino.konos.alexandria.rest.spark.SparkReader;
import io.intino.konos.alexandria.rest.spark.SparkWriter;
import java.io.IOException;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.Part;
import spark.Request;
import spark.Response;

public class SparkManager {
    protected final Request request;
    protected final Response response;

    public SparkManager(Request request, Response response) {
        this.request = request;
        this.response = response;
        this.setUpMultipartConfiguration();
    }

    public void write(Object object) {
        new SparkWriter(this.response).write(object);
    }

    public void write(Object object, String name) {
        this.write(object, name, false);
    }

    public void write(Object object, String name, boolean embedded) {
        new SparkWriter(this.response).write(object, name, embedded);
    }

    public <T> T fromHeader(String name, Class<T> type) {
        return SparkReader.read(this.request.headers(name), type);
    }

    public <T> T fromQuery(String name, Class<T> type) {
        return SparkReader.read(this.request.queryParams(name), type);
    }

    public <T> T fromPath(String name, Class<T> type) {
        return SparkReader.read(this.request.params(name), type);
    }

    public <T> T fromBody(String name, Class<T> type) {
        return SparkReader.read(this.request.body(), type);
    }

    public <T> T fromForm(String name, Class<T> type) {
        return this.readPart(type);
    }

    private <T> T readPart(Class<T> type) {
        try {
            Part part = this.request.raw().getPart("content");
            if (part == null) {
                return null;
            }
            return SparkReader.read(part.getInputStream(), type);
        }
        catch (IOException | ServletException e) {
            return null;
        }
    }

    private void setUpMultipartConfiguration() {
        MultipartConfigElement multipartConfigElement = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
        this.request.raw().setAttribute("org.eclipse.jetty.multipartConfig", (Object)multipartConfigElement);
    }
}

