/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.rest.spark;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.intino.konos.alexandria.rest.pushservice.Client;
import io.intino.konos.alexandria.rest.pushservice.Message;
import io.intino.konos.alexandria.rest.pushservice.PushService;
import io.intino.konos.alexandria.rest.pushservice.Session;
import io.intino.konos.alexandria.rest.pushservice.SessionManager;
import io.intino.konos.alexandria.rest.spark.ResponseAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class PushService<S extends Session<C>, C extends Client>
implements io.intino.konos.alexandria.rest.pushservice.PushService<S, C> {
    protected final Queue<Function<C, Boolean>> openConnectionListeners = new ConcurrentLinkedQueue<Function<C, Boolean>>();
    private final Map<String, List<Consumer<Message>>> messageListeners = new HashMap<String, List<Consumer<Message>>>();
    protected final Map<String, List<Consumer<C>>> closeConnectionListeners = new HashMap<String, List<Consumer<C>>>();
    protected final SessionManager<S, C> sessionManager = new SessionManager();
    private static final JsonParser Parser = new JsonParser();

    @Override
    public void onOpen(Function<C, Boolean> consumer) {
        this.openConnectionListeners.add(consumer);
    }

    @Override
    public PushService.Connection onMessage(String clientId, Consumer<Message> consumer) {
        this.messageListeners.putIfAbsent(clientId, new ArrayList());
        this.messageListeners.get(clientId).add(consumer);
        return () -> {
            Map<String, List<Consumer<Message>>> map = this.messageListeners;
            synchronized (map) {
                this.messageListeners.get(clientId).remove(consumer);
            }
        };
    }

    @Override
    public PushService.ClosedConnection onClose(String clientId) {
        return consumer -> {
            this.closeConnectionListeners.putIfAbsent(clientId, new ArrayList());
            this.closeConnectionListeners.get(clientId).add(consumer);
        };
    }

    public abstract S createSession(String var1);

    public abstract C createClient(org.eclipse.jetty.websocket.api.Session var1);

    public synchronized void onOpen(C client) {
        this.registerClient(client);
        this.sessionManager.linkToThread(client);
        ArrayList acceptListeners = new ArrayList();
        this.openConnectionListeners.forEach(listener -> {
            Boolean acceptClient = (Boolean)listener.apply(client);
            if (acceptClient.booleanValue()) {
                acceptListeners.add(listener);
            }
        });
        acceptListeners.forEach(this.openConnectionListeners::remove);
        this.sessionManager.unlinkFromThread();
    }

    public void onMessage(C client, String message) {
        this.broadcastMessage(client, new Message(message));
    }

    public void onClose(C client) {
        this.sessionManager.unRegister(client);
        this.messageListeners.remove(client.id());
        if (this.closeConnectionListeners.containsKey(client.id())) {
            this.closeConnectionListeners.get(client.id()).forEach(clientConsumer -> clientConsumer.accept(client));
        }
        this.closeConnectionListeners.remove(client.id());
    }

    @Override
    public void pushBroadcast(final Message message) {
        this.sessionManager.sessions().stream().forEach(new Consumer<Session>(){

            @Override
            public void accept(Session session) {
                session.clients().forEach(new Consumer<Client>(){

                    @Override
                    public void accept(Client client) {
                        client.send(PushService.this.serializeMessage(message));
                    }
                });
            }
        });
    }

    @Override
    public void pushToSession(S session, Message message) {
        session.send(this.serializeMessage(message));
    }

    @Override
    public void pushToClient(C client, Message message) {
        client.send(this.serializeMessage(message));
    }

    @Override
    public void linkToThread(C client) {
        this.sessionManager.linkToThread(client);
    }

    @Override
    public void unlinkFromThread() {
        this.sessionManager.unlinkFromThread();
    }

    @Override
    public void unRegister(C client) {
        this.sessionManager.unRegister(client);
    }

    @Override
    public S session(String id) {
        this.registerSession(id);
        return this.sessionManager.session(id);
    }

    @Override
    public C client(String id) {
        return this.sessionManager.client(id);
    }

    @Override
    public C currentClient() {
        return this.sessionManager.currentClient();
    }

    private void broadcastMessage(C client, Message message) {
        this.messageListeners.get(client.id()).forEach(listener -> listener.accept(message));
    }

    private String serializeMessage(Message message) {
        JsonObject result = new JsonObject();
        Map<String, Object> parameters = message.parameters();
        result.addProperty("name", message.name());
        result.add("parameters", this.serializeMessageParameters(parameters));
        return result.toString();
    }

    private JsonElement serializeMessageParameters(Map<String, Object> parameters) {
        JsonObject result = new JsonObject();
        parameters.entrySet().forEach(p -> result.add((String)p.getKey(), this.serializeMessageParameter(p.getValue())));
        return result;
    }

    private JsonElement serializeMessageParameter(Object value) {
        String result = ResponseAdapter.adapt(value);
        try {
            return Parser.parse(result);
        }
        catch (Exception exception) {
            return new JsonPrimitive(result);
        }
    }

    private void registerSession(String sessionId) {
        if (this.sessionManager.session(sessionId) != null) {
            return;
        }
        this.sessionManager.register(this.createSession(sessionId));
    }

    private void registerClient(C client) {
        this.registerSession(client.sessionId());
        this.sessionManager.register(client);
    }
}

