/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.rest.pushservice;

import io.intino.konos.alexandria.rest.pushservice.Client;
import io.intino.konos.alexandria.rest.pushservice.Session;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SessionManager<S extends Session<C>, C extends Client> {
    private final Map<String, S> sessionMap = new HashMap<String, S>();
    private final Map<String, C> clientMap = new HashMap<String, C>();
    private final Map<Long, S> linkSessionMap = new HashMap<Long, S>();
    private final Map<Long, C> linkClientMap = new HashMap<Long, C>();

    public List<S> sessions() {
        return this.sessionMap.values().stream().collect(Collectors.toList());
    }

    public S session(String id) {
        return (S)(this.sessionMap.containsKey(id) ? (Session)this.sessionMap.get(id) : null);
    }

    public void register(S session) {
        this.sessionMap.putIfAbsent(session.id(), session);
    }

    public void unRegister(S session) {
        session.clients().forEach(client -> this.unRegister((C)client));
        this.sessionMap.remove(session.id());
    }

    public C client(String id) {
        return (C)((Client)this.clientMap.get(id));
    }

    public C client(String sessionId, String id) {
        return this.session(sessionId).client(id);
    }

    public C currentClient() {
        return (C)((Client)this.linkClientMap.get(Thread.currentThread().getId()));
    }

    public void register(C client) {
        this.clientMap.put(client.id(), client);
        this.session(client.sessionId()).add(client);
    }

    public void unRegister(C client) {
        client.destroy();
        this.clientMap.remove(client.id());
        this.session(client.sessionId()).remove(client);
    }

    public void linkToThread(C client) {
        long id = Thread.currentThread().getId();
        S session = this.session(client.sessionId());
        session.currentClient(client);
        this.linkSessionMap.put(id, session);
        this.linkClientMap.put(id, client);
    }

    public void unlinkFromThread() {
        long id = Thread.currentThread().getId();
        Session session = (Session)this.linkSessionMap.get(id);
        if (session != null) {
            session.currentClient(null);
        }
        this.linkSessionMap.remove(id);
        this.linkClientMap.remove(id);
    }
}

