/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.datalake;

import io.intino.konos.datalake.Datalake;
import io.intino.konos.datalake.MessageHandler;
import io.intino.ness.inl.Message;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReflowDispatcher {
    private final List<Datalake.Tank> tanks;
    private Map<String, MessageHandler> handlers;

    public ReflowDispatcher(List<Datalake.Tank> tanks, MessageHandler onBlock, MessageHandler onFinish) {
        this.tanks = tanks;
        this.handlers = tanks.stream().collect(Collectors.toMap(this::typeOf, t -> t::handle));
        this.handlers.put("endblock", onBlock);
        this.handlers.put("endreflow", onFinish);
    }

    private String typeOf(Datalake.Tank tank) {
        String name = tank.name().toLowerCase();
        return name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : name;
    }

    public void dispatch(Message message) {
        this.handlers.get(message.type().toLowerCase()).handle(message);
    }

    public List<Datalake.Tank> tanks() {
        return this.tanks;
    }
}

