package io.intino.konos.builder.codegeneration.services.ui.templates;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class ResourceTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("resource", "exposedDisplay")).output(literal("package ")).output(placeholder("package", "validPackage")).output(literal(".ui.resources;\n\nimport io.intino.alexandria.AbstractBox;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.exceptions.Unauthorized;\nimport io.intino.alexandria.ui.AlexandriaUiBox;\nimport ")).output(placeholder("package", "validPackage")).output(literal(".")).output(placeholder("box", "PascalCase")).output(literal("Box;\nimport ")).output(placeholder("package", "validPackage")).output(literal(".ui.pages.")).output(placeholder("name", "firstUpperCase")).output(literal("ProxyPage;\nimport io.intino.alexandria.Json;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.exceptions.Unauthorized;\nimport io.intino.alexandria.ui.Soul;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;\nimport io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;\nimport io.intino.alexandria.ui.services.push.UIClient;\nimport io.intino.alexandria.ui.services.push.UISession;\n\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class ")).output(placeholder("name", "firstUpperCase")).output(literal("ProxyResource extends io.intino.alexandria.ui.server.resources.ProxyResource {\n\tprivate final AlexandriaUiBox box;\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("ProxyResource(AlexandriaUiBox box, io.intino.alexandria.ui.server.AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tfillBrowser(manager, session());\n\t\tfillDeviceParameter();\n\t\t")).output(placeholder("render")).output(literal("\n\t}\n\n\tprivate void render() {\n\t\tUIClient client = client();\n\n\t\t")).output(placeholder("name", "firstUpperCase")).output(literal("ProxyPage page = new ")).output(placeholder("name", "firstUpperCase")).output(literal("ProxyPage();\n\t\tpage.session = session();\n\t\tpage.session.browser().onRedirect(location -> manager.redirect(location));\n\t\tpage.session.browser().requestUrl(manager.requestUrl());\n\t\tpage.session.whenLogin(new Function<String, String>() {\n\t\t\t@Override\n\t\t\tpublic String apply(String baseUrl) {\n\t\t\t\treturn ")).output(placeholder("name", "firstUpperCase")).output(literal("ProxyResource.this.authenticate(page.session, baseUrl);\n\t\t\t}\n\t\t});\n\t\tpage.session.whenLogout(b -> logout(page.session));\n\t\tpage.box = box;\n\t\tpage.clientId = client.id();\n\t\tpage.webDirectories = manager.webDirectories();\n\t\t")).output(expression().output(literal("page.googleApiKey = ")).output(placeholder("googleApiKey", "format")).output(literal(";"))).output(literal("\n\t\tpage.device = parameterValue(\"device\");\n\t\t")).output(placeholder("parameter").multiple("\n")).output(literal("\n\t\tif (!page.hasPermissions()) {\n\t\t\tmanager.redirect(page.redirectUrl());\n\t\t\treturn;\n\t\t}\n\n\t\tSoul soul = soul();\n\t\tif (soul != null) {\n\t\t\tpage.soul = soul;\n\t\t\tpage.execute();\n\t\t\treturn;\n\t\t}\n\n\t\tsoul = new Soul(page.session) {\n\t\t\t@Override\n\t\t\tpublic void personify() {\n\t\t\t\tSoul soul = this;\n\t\t\t\taddRegisterDisplayListener(display -> {\n\t\t\t\t\tdisplay.inject(notifier(page.session, client, display));\n\t\t\t\t\tdisplay.inject(page.session);\n\t\t\t\t\tdisplay.inject(soul);\n\t\t\t\t\tdisplay.inject(() -> soul);\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\t\t((UIClient)client).soul(soul);\n\t\tclient.cookies(manager.cookies());\n\t\tpage.soul = soul;\n\t\tpage.execute();\n\t\tbox.registerSoul(client.id(), soul);\n\t\tsoul.register(new io.intino.alexandria.ui.displays.DisplayRouter(box).id(\"__router__\"));\n\t\t//((")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher)box.routeManager().routeDispatcher()).dispatch")).output(placeholder("name", "firstUpperCase")).output(literal("(soul")).output(expression().output(literal(", ")).output(placeholder("parameter", "dispatch").multiple(", "))).output(literal(");\n\n\t\tmanager.pushService().onClose(page.clientId).execute(new Consumer<UIClient>() {\n\t\t\t@Override\n\t\t\tpublic void accept(io.intino.alexandria.ui.services.push.UIClient client) {\n\t\t\t\t((AbstractBox)box).soul(client.id()).ifPresent(s -> s.destroy());\n\t\t\t\tbox.unRegisterSoul(client.id());\n\t\t\t\tmanager.unRegister(client);\n\t\t\t}\n\t\t});\n\n\t\tmanager.write(\"OK\");\n\t}\n}")));
		rules.add(rule().condition(allTypes("render", "confidential")).output(literal("try {\n\tif (!isLogged(accessToken()))\n\t\tthrow new Unauthorized(\"user is not logged\");\n\n\tauthenticate(manager.session(manager.fromQuery(\"session\")), accessToken());\n\trender();\n} catch (CouldNotObtainInfo couldNotObtainInfo) {\n\tthrow new Unauthorized(\"user is not logged\");\n} catch (Throwable error) {\n\tthrow new Unauthorized(\"could not render component\");\n}")));
		rules.add(rule().condition(allTypes("render")).output(literal("render();")));
		rules.add(rule().condition(allTypes("resource", "static")).output(literal("package ")).output(placeholder("package", "validPackage")).output(literal(".ui.resources;\n\nimport ")).output(placeholder("package", "validPackage")).output(literal(".")).output(placeholder("box", "PascalCase")).output(literal("Box;\nimport ")).output(placeholder("package", "validPackage")).output(literal(".ui.pages.")).output(placeholder("name", "firstUpperCase")).output(literal("Page;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;\n\nimport java.util.Base64;\nimport java.util.UUID;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource extends io.intino.alexandria.ui.server.resources.")).output(expression().output(placeholder("editor"))).output(literal("Resource {\n\tprivate final ")).output(placeholder("box", "PascalCase")).output(literal("Box box;\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource(")).output(placeholder("box", "PascalCase")).output(literal("Box box, io.intino.alexandria.ui.server.AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tsuper.execute();\n\t\tfillDeviceParameter();\n\t\t")).output(expression().output(placeholder("confidential")).output(literal("\n")).output(literal("if (isLogged()) render();")).output(literal("\n")).output(literal("else authenticate();")).next(expression().output(literal("render();")))).output(literal("\n\t}\n\n\tprivate void render() {\n\t\tString clientId = UUID.randomUUID().toString();\n\t\t")).output(placeholder("name", "firstUpperCase")).output(literal("Page page = new ")).output(placeholder("name", "firstUpperCase")).output(literal("Page();\n\t\tpage.session = manager.currentSession();\n\t\tpage.session.browser().onRedirect(location -> manager.redirect(location));\n\t\tpage.session.browser().requestUrl(manager.requestUrl());\n\t\tpage.session.whenLogin(new Function<String, String>() {\n\t\t\t@Override\n\t\t\tpublic String apply(String baseUrl) {\n\t\t\t\treturn ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource.this.authenticate(page.session, baseUrl);\n\t\t\t}\n\t\t});\n\t\tpage.session.whenLogout(b -> logout(page.session));\n\t\tpage.box = box;\n\t\tpage.clientId = clientId;\n\t\tpage.webDirectories = manager.webDirectories();\n\t\t")).output(expression().output(literal("page.googleApiKey = ")).output(placeholder("googleApiKey", "format")).output(literal(";"))).output(literal("\n\t\tpage.device = parameterValue(\"device\");\n\t\tpage.token = parameterValue(\"token\");")).output(expression().output(literal("\n")).output(literal("")).output(placeholder("editor", "parameters"))).output(literal("\n\t\t")).output(placeholder("parameter").multiple("\n")).output(literal("\n\t\tif (!page.hasPermissions()) {\n\t\t\tmanager.redirect(page.redirectUrl());\n\t\t\treturn;\n\t\t}\n\n\t\tmanager.write(page.execute());\n\t}\n\n}")));
		rules.add(rule().condition(allTypes("resource", "asset")).output(literal("package ")).output(placeholder("package", "validPackage")).output(literal(".ui.resources;\n\nimport ")).output(placeholder("package", "validPackage")).output(literal(".")).output(placeholder("box", "PascalCase")).output(literal("Box;\nimport ")).output(placeholder("package", "validPackage")).output(literal(".ui.pages.")).output(placeholder("name", "firstUpperCase")).output(literal("Page;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;\n\nimport java.util.Base64;\nimport java.util.UUID;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource extends io.intino.alexandria.ui.server.resources.")).output(expression().output(placeholder("editor"))).output(literal("Resource {\n\tprivate final ")).output(placeholder("box", "PascalCase")).output(literal("Box box;\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource(")).output(placeholder("box", "PascalCase")).output(literal("Box box, io.intino.alexandria.ui.server.AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tsuper.execute();\n\t\tfillDeviceParameter();\n\t\t")).output(expression().output(placeholder("confidential")).output(literal("\n")).output(literal("if (isLogged()) render();")).output(literal("\n")).output(literal("else authenticate();")).next(expression().output(literal("render();")))).output(literal("\n\t}\n\n\tprivate void render() {\n\t\tString clientId = UUID.randomUUID().toString();\n\t\t")).output(placeholder("name", "firstUpperCase")).output(literal("Page page = new ")).output(placeholder("name", "firstUpperCase")).output(literal("Page();\n\t\tpage.session = manager.currentSession();\n\t\tpage.session.browser().onRedirect(location -> manager.redirect(location));\n\t\tpage.session.browser().requestUrl(manager.requestUrl());\n\t\tpage.session.whenLogin(new Function<String, String>() {\n\t\t\t@Override\n\t\t\tpublic String apply(String baseUrl) {\n\t\t\t\treturn ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource.this.authenticate(page.session, baseUrl);\n\t\t\t}\n\t\t});\n\t\tpage.session.whenLogout(b -> logout(page.session));\n\t\tpage.box = box;\n\t\tpage.clientId = clientId;\n\t\tpage.webDirectories = manager.webDirectories();\n\t\t")).output(expression().output(literal("page.googleApiKey = ")).output(placeholder("googleApiKey", "format")).output(literal(";"))).output(literal("\n\t\tpage.device = parameterValue(\"device\");\n\t\tpage.token = parameterValue(\"token\");")).output(expression().output(literal("\n")).output(literal("")).output(placeholder("editor", "parameters"))).output(literal("\n\t\t")).output(placeholder("parameter").multiple("\n")).output(literal("\n\t\tif (!page.hasPermissions()) {\n\t\t\tmanager.redirect(page.redirectUrl());\n\t\t\treturn;\n\t\t}\n\n\t\tmanager.write(page.execute());\n\t}\n\n}")));
		rules.add(rule().condition(allTypes("resource", "exposed")).output(literal("package ")).output(placeholder("package", "validPackage")).output(literal(".ui.resources;\n\n")).output(placeholder("page", "import")).output(literal("\nimport ")).output(placeholder("package", "validPackage")).output(literal(".ui.pages.")).output(placeholder("name", "firstUpperCase")).output(literal("Page;\nimport io.intino.alexandria.AbstractBox;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.ui.AlexandriaUiBox;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;\nimport io.intino.alexandria.ui.server.pages.UiPage;\nimport io.intino.alexandria.ui.services.push.UIClient;\n\nimport java.util.Base64;\nimport java.util.UUID;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource extends io.intino.alexandria.ui.server.resources.")).output(expression().output(placeholder("editor"))).output(literal("Resource {\n\tprivate final AlexandriaUiBox box;\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource(AlexandriaUiBox box, io.intino.alexandria.ui.server.AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tsuper.execute();\n\t\tfillDeviceParameter();\n\t\t")).output(expression().output(placeholder("confidential")).output(literal("\n")).output(literal("if (isLogged()) render();")).output(literal("\n")).output(literal("else authenticate();")).next(expression().output(literal("render();")))).output(literal("\n\t}\n\n\tprivate void render() {\n\t\tString clientId = UUID.randomUUID().toString();\n\t\tUiPage page = ")).output(placeholder("page", "instance")).output(literal(";\n\t\tpage.session = manager.currentSession();\n\t\tpage.session.browser().onRedirect(location -> manager.redirect(location));\n\t\tpage.session.browser().requestUrl(manager.requestUrl());\n\t\tpage.session.whenLogin(new Function<String, String>() {\n\t\t\t@Override\n\t\t\tpublic String apply(String baseUrl) {\n\t\t\t\treturn ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource.this.authenticate(page.session, baseUrl);\n\t\t\t}\n\t\t});\n\t\tpage.session.whenLogout(b -> logout(page.session));\n        ")).output(placeholder("page", "box")).output(literal("\n\t\tpage.clientId = clientId;\n\t\tpage.webDirectories = manager.webDirectories();\n\t\t")).output(expression().output(literal("page.googleApiKey = ")).output(placeholder("googleApiKey", "format")).output(literal(";"))).output(literal("\n\t\tpage.device = parameterValue(\"device\");\n\t\tpage.token = parameterValue(\"token\");")).output(expression().output(literal("\n")).output(literal("")).output(placeholder("editor", "parameters"))).output(literal("\n\t\t")).output(placeholder("parameter").multiple("\n")).output(literal("\n\t\tif (!page.hasPermissions()) {\n\t\t\tmanager.redirect(page.redirectUrl());\n\t\t\treturn;\n\t\t}\n\n\t\tmanager.pushService().onOpen(client -> {\n\t\t\tif (!client.id().equals(page.clientId))\n\t\t\t\treturn false;\n\n\t\t\tif (client.soul() != null && box.routeManager().routeDispatcher() instanceof ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher) {\n\t\t\t\t((")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher)box.routeManager().routeDispatcher()).dispatch")).output(placeholder("name", "firstUpperCase")).output(literal("(client.soul()")).output(expression().output(literal(", ")).output(placeholder("parameter", "dispatch").multiple(", "))).output(literal(");\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tio.intino.alexandria.ui.Soul soul = page.prepareSoul(client);\n\t\t\tsoul.onRedirect((location) -> manager.redirect(location));\n\t\t\tsoul.addRegisterDisplayListener(display -> {\n\t\t\t\tdisplay.inject(notifier(page.session, client, display));\n\t\t\t\tdisplay.inject(page.session);\n\t\t\t\tdisplay.inject(soul);\n\t\t\t\tdisplay.inject(() -> soul);\n\t\t\t});\n\t\t\t((UIClient)client).soul(soul);\n\t\t\tclient.cookies(manager.cookies());\n\n\t\t\tbox.registerSoul(clientId, soul);\n\t\t\tsoul.register(new io.intino.alexandria.ui.displays.DisplayRouter(box).id(\"__router__\"));\n\t\t\tif (box.routeManager().routeDispatcher() instanceof ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher)\n\t\t\t    ((")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher)box.routeManager().routeDispatcher()).dispatch")).output(placeholder("name", "firstUpperCase")).output(literal("(soul")).output(expression().output(literal(", ")).output(placeholder("parameter", "dispatch").multiple(", "))).output(literal(");\n\n\t\t\treturn true;\n\t\t});\n\n\t\tmanager.pushService().onClose(clientId).execute(new Consumer<io.intino.alexandria.ui.services.push.UIClient>() {\n\t\t\t@Override\n\t\t\tpublic void accept(io.intino.alexandria.ui.services.push.UIClient client) {\n\t\t\t\tif (client.soul() != null) client.soul().destroy();\n\t\t\t\tbox.unRegisterSoul(client.id());\n\t\t\t\tmanager.unRegister(client);\n\t\t\t}\n\t\t});\n\n\t\tmanager.write(page.execute());\n\t}\n\n}")));
		rules.add(rule().condition(allTypes("resource")).output(literal("package ")).output(placeholder("package", "validPackage")).output(literal(".ui.resources;\n\nimport ")).output(placeholder("package", "validPackage")).output(literal(".")).output(placeholder("box", "PascalCase")).output(literal("Box;\n")).output(placeholder("page", "import")).output(literal("\nimport ")).output(placeholder("package", "validPackage")).output(literal(".ui.pages.")).output(placeholder("name", "firstUpperCase")).output(literal("Page;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;\nimport io.intino.alexandria.ui.server.pages.UiPage;\nimport io.intino.alexandria.ui.services.push.UIClient;\n\nimport java.util.Base64;\nimport java.util.UUID;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource extends io.intino.alexandria.ui.server.resources.")).output(expression().output(placeholder("editor"))).output(literal("Resource {\n\tprivate final ")).output(placeholder("box", "PascalCase")).output(literal("Box box;\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource(")).output(placeholder("box", "PascalCase")).output(literal("Box box, io.intino.alexandria.ui.server.AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tsuper.execute();\n\t\tfillDeviceParameter();\n\t\t")).output(expression().output(placeholder("confidential")).output(literal("\n")).output(literal("if (isLogged()) render();")).output(literal("\n")).output(literal("else authenticate();")).next(expression().output(literal("render();")))).output(literal("\n\t}\n\n\tprivate void render() {\n\t\tString clientId = UUID.randomUUID().toString();\n\t\tUiPage page = ")).output(placeholder("page", "instance")).output(literal(";\n\t\tpage.session = manager.currentSession();\n\t\tpage.session.browser().onRedirect(location -> manager.redirect(location));\n\t\tpage.session.browser().requestUrl(manager.requestUrl());\n\t\tpage.session.whenLogin(new Function<String, String>() {\n\t\t\t@Override\n\t\t\tpublic String apply(String baseUrl) {\n\t\t\t\treturn ")).output(placeholder("name", "firstUpperCase")).output(literal("Resource.this.authenticate(page.session, baseUrl);\n\t\t\t}\n\t\t});\n\t\tpage.session.whenLogout(b -> logout(page.session));\n        ")).output(placeholder("page", "box")).output(literal("\n\t\tpage.clientId = clientId;\n\t\tpage.webDirectories = manager.webDirectories();\n\t\t")).output(expression().output(literal("page.googleApiKey = ")).output(placeholder("googleApiKey", "format")).output(literal(";"))).output(literal("\n\t\tpage.device = parameterValue(\"device\");\n\t\tpage.token = parameterValue(\"token\");")).output(expression().output(literal("\n")).output(literal("")).output(placeholder("editor", "parameters"))).output(literal("\n\t\t")).output(placeholder("parameter").multiple("\n")).output(literal("\n\t\tif (!page.hasPermissions()) {\n\t\t\tmanager.redirect(page.redirectUrl());\n\t\t\treturn;\n\t\t}\n\n\t\tmanager.pushService().onOpen(client -> {\n\t\t\tif (!client.id().equals(page.clientId))\n\t\t\t\treturn false;\n\n\t\t\tif (client.soul() != null && box.routeManager().routeDispatcher() instanceof ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher) {\n\t\t\t\t((")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher)box.routeManager().routeDispatcher()).dispatch")).output(placeholder("name", "firstUpperCase")).output(literal("(client.soul()")).output(expression().output(literal(", ")).output(placeholder("parameter", "dispatch").multiple(", "))).output(literal(");\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tio.intino.alexandria.ui.Soul soul = page.prepareSoul(client);\n\t\t\tsoul.onRedirect((location) -> manager.redirect(location));\n\t\t\tsoul.addRegisterDisplayListener(display -> {\n\t\t\t\tdisplay.inject(notifier(page.session, client, display));\n\t\t\t\tdisplay.inject(page.session);\n\t\t\t\tdisplay.inject(soul);\n\t\t\t\tdisplay.inject(() -> soul);\n\t\t\t});\n\t\t\t((UIClient)client).soul(soul);\n\t\t\tclient.cookies(manager.cookies());\n\n\t\t\tbox.registerSoul(clientId, soul);\n\t\t\tsoul.register(new io.intino.alexandria.ui.displays.DisplayRouter(box).id(\"__router__\"));\n\t\t\tif (box.routeManager().routeDispatcher() instanceof ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher)\n\t\t\t    ((")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.RouteDispatcher)box.routeManager().routeDispatcher()).dispatch")).output(placeholder("name", "firstUpperCase")).output(literal("(soul")).output(expression().output(literal(", ")).output(placeholder("parameter", "dispatch").multiple(", "))).output(literal(");\n\n\t\t\treturn true;\n\t\t});\n\n\t\tmanager.pushService().onClose(clientId).execute(new Consumer<io.intino.alexandria.ui.services.push.UIClient>() {\n\t\t\t@Override\n\t\t\tpublic void accept(io.intino.alexandria.ui.services.push.UIClient client) {\n\t\t\t\tbox.soul(client.id()).ifPresent(s -> s.destroy());\n\t\t\t\tbox.unRegisterSoul(client.id());\n\t\t\t\tmanager.unRegister(client);\n\t\t\t}\n\t\t});\n\n\t\tmanager.write(page.execute());\n\t}\n\n}")));
		rules.add(rule().condition(trigger("parameters")).output(literal("page.document = loadDocument();\npage.permission = loadPermission();")));
		rules.add(rule().condition(all(allTypes("parameter", "mobile"), trigger("dispatch"))).output(literal("page instanceof ")).output(placeholder("resource", "firstUpperCase")).output(literal("MobilePage ? ((")).output(placeholder("resource", "firstUpperCase")).output(literal("MobilePage)page).")).output(placeholder("name", "CamelCase")).output(literal(" : ((")).output(placeholder("resource", "firstUpperCase")).output(literal("Page)page).")).output(placeholder("name", "CamelCase")));
		rules.add(rule().condition(all(allTypes("parameter"), trigger("dispatch"))).output(literal("((")).output(placeholder("resource", "firstUpperCase")).output(literal("Page)page).")).output(placeholder("name", "CamelCase")));
		rules.add(rule().condition(allTypes("parameter", "mobile")).output(literal("if (page instanceof ")).output(placeholder("resource", "firstUpperCase")).output(literal("MobilePage) ((")).output(placeholder("resource", "firstUpperCase")).output(literal("MobilePage)page).")).output(placeholder("name", "CamelCase")).output(literal(" = parameterValue(\"")).output(placeholder("name")).output(literal("\");\nelse ((")).output(placeholder("resource", "firstUpperCase")).output(literal("Page)page).")).output(placeholder("name", "CamelCase")).output(literal(" = parameterValue(\"")).output(placeholder("name")).output(literal("\");")));
		rules.add(rule().condition(allTypes("parameter")).output(literal("((")).output(placeholder("resource", "firstUpperCase")).output(literal("Page)page).")).output(placeholder("name", "CamelCase")).output(literal(" = parameterValue(\"")).output(placeholder("name")).output(literal("\");")));
		rules.add(rule().condition(all(allTypes("googleApiKey"), trigger("format"))).output(literal("\"")).output(placeholder("name")).output(literal("\"")).output(expression().output(placeholder("custom").multiple(""))));
		rules.add(rule().condition(trigger("custom")).output(literal(".replace(\"{")).output(placeholder("")).output(literal("}\", box.configuration().get(\"")).output(placeholder("")).output(literal("\"))")));
		rules.add(rule().condition(all(allTypes("page", "mobile"), trigger("import"))).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.pages.")).output(placeholder("name", "firstUpperCase")).output(literal("MobilePage;")));
		rules.add(rule().condition(all(allTypes("page"), trigger("import"))));
		rules.add(rule().condition(all(allTypes("page", "mobile"), trigger("instance"))).output(literal("manager.fromQuery(\"device\") != null ? new ")).output(placeholder("name", "firstUpperCase")).output(literal("MobilePage() : new ")).output(placeholder("name", "firstUpperCase")).output(literal("Page()")));
		rules.add(rule().condition(all(allTypes("page"), trigger("instance"))).output(literal("new ")).output(placeholder("name", "firstUpperCase")).output(literal("Page()")));
		rules.add(rule().condition(all(allTypes("page", "mobile"), trigger("box"))).output(literal("if (page instanceof ")).output(placeholder("name", "firstUpperCase")).output(literal("MobilePage) ((")).output(placeholder("name", "firstUpperCase")).output(literal("MobilePage)page).box = box;\nelse ((")).output(placeholder("name", "firstUpperCase")).output(literal("Page)page).box = box;")));
		rules.add(rule().condition(all(allTypes("page"), trigger("box"))).output(literal("((")).output(placeholder("name", "firstUpperCase")).output(literal("Page)page).box = box;")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}