package io.intino.konos.builder.codegeneration.accessor.rest;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class RESTAccessorTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("accessor")).output(literal("package ")).output(placeholder("package", "ValidPackage")).output(literal(";\n\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.HashSet;\nimport java.util.HashMap;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.net.URL;\nimport java.lang.reflect.Type;\nimport com.google.gson.JsonSerializer;\nimport com.google.gson.JsonDeserializer;\nimport io.intino.alexandria.exceptions.*;\nimport io.intino.alexandria.restaccessor.RequestBuilder;\nimport io.intino.alexandria.restaccessor.core.RestAccessorNotifier;\nimport io.intino.alexandria.restaccessor.exceptions.RestfulFailure;\n\n")).output(placeholder("schemaImport")).output(literal("\n\npublic class ")).output(placeholder("name", "pascalCase")).output(literal("Accessor {\n\tprivate final URL url;\n\tprivate final RestAccessorNotifier notifier = new RestAccessorNotifier();\n\tprivate int timeoutMillis = 120 * 1_000;\n\tprivate io.intino.alexandria.restaccessor.OutBox outBox = null;\n\tprivate Map<String, String> additionalHeaders = new HashMap<>();\n\t")).output(placeholder("authentication", "field")).output(literal("\n\t")).output(placeholder("enumParameter").multiple("\n\n")).output(literal("\n\n\tpublic ")).output(placeholder("name", "pascalCase")).output(literal("Accessor(URL url")).output(expression().output(literal(", ")).output(placeholder("authentication", "parameter"))).output(literal(") {\n\t\tthis.url = url;\n\t\t")).output(placeholder("authentication", "assign")).output(literal("\n\t}\n\n\tpublic ")).output(placeholder("name", "pascalCase")).output(literal("Accessor(URL url, int timeoutMillis")).output(expression().output(literal(", ")).output(placeholder("authentication", "parameter"))).output(literal(") {\n\t\tthis.url = url;\n\t\tthis.timeoutMillis = timeoutMillis;\n\t\t")).output(placeholder("authentication", "assign")).output(literal("\n\t}\n\n\tpublic ")).output(placeholder("name", "pascalCase")).output(literal("Accessor(URL url, int timeoutMillis, java.io.File outBoxDirectory, int intervalRetrySeconds")).output(expression().output(literal(", ")).output(placeholder("authentication", "parameter"))).output(literal(") {\n\t\tthis.url = url;\n\t\tthis.timeoutMillis = timeoutMillis;\n\t\tthis.outBox = new io.intino.alexandria.restaccessor.OutBox(outBoxDirectory, intervalRetrySeconds);\n\t\t")).output(placeholder("authentication", "assign")).output(literal("\n\t}\n\n\tpublic void addCommonHeader(String name, String value) {\n\t\tadditionalHeaders.put(name, value);\n\t}\n\n\tpublic void addRequestSerializer(Type type, JsonSerializer<?> adapter) {\n\t\tio.intino.alexandria.restaccessor.adapters.RequestAdapter.addCustomAdapter(type, adapter);\n\t}\n\n\tpublic void addResponseDeserializer(Type type, JsonDeserializer<?> adapter) {\n\t\tio.intino.alexandria.restaccessor.adapters.ResponseAdapter.addCustomAdapter(type, adapter);\n\t}\n\n\t")).output(placeholder("resource").multiple("\n\n")).output(literal("\n\n\t")).output(placeholder("notification").multiple("\n\n")).output(literal("\n}")));
		rules.add(rule().condition(allTypes("resource")).output(literal("public ")).output(placeholder("response")).output(literal(" ")).output(placeholder("method", "firstLowerCase")).output(placeholder("name", "PascalCase")).output(literal("(")).output(placeholder("parameter", "signature").multiple(", ")).output(literal(") ")).output(placeholder("exceptionResponses", "declaration")).output(literal(" {\n\tRequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);\n\tadditionalHeaders.forEach((k,v) -> builder.headerParameter(k,v));\n\tRequestBuilder.Request request = builder\n\t\t")).output(expression().output(literal(".")).output(placeholder("auth"))).output(literal("\n\t\t")).output(expression().output(literal(".")).output(placeholder("parameter").multiple("\n."))).output(literal("\n\t\t.build(RequestBuilder.Method.")).output(placeholder("method", "upperCase")).output(literal(", ")).output(placeholder("path")).output(literal(");\n\ttry {\n\t\tio.intino.alexandria.restaccessor.Response response = request.execute();\n\t\t")).output(expression().output(placeholder("response", "return"))).output(literal("\n\t} catch (AlexandriaException e) {\n\t\t")).output(placeholder("exceptionResponses", "throws")).output(literal("\n\t\tif (outBox != null) outBox.push(request);\n\t\tthrow new InternalServerError(e.message());\n\t}\n}")));
		rules.add(rule().condition(all(allTypes("parameter", "query", "word"), trigger("parameter"))).output(literal("queryParameter(\"")).output(placeholder("name")).output(literal("\", ")).output(placeholder("name", "CamelCase")).output(literal(".name())")));
		rules.add(rule().condition(all(allTypes("parameter", "query"), trigger("parameter"))).output(literal("queryParameter(\"")).output(placeholder("name")).output(literal("\", ")).output(placeholder("name", "CamelCase")).output(literal(")")));
		rules.add(rule().condition(all(allTypes("parameter", "header", "word"), trigger("parameter"))).output(literal("headerParameter(\"")).output(placeholder("name")).output(literal("\", ")).output(placeholder("name", "CamelCase")).output(literal(".name())")));
		rules.add(rule().condition(all(allTypes("parameter", "header"), trigger("parameter"))).output(literal("headerParameter(\"")).output(placeholder("name")).output(literal("\", ")).output(placeholder("name", "CamelCase")).output(literal(")")));
		rules.add(rule().condition(all(all(not(allTypes("file")), allTypes("parameter", "body")), trigger("parameter"))).output(literal("entityPart(\"")).output(placeholder("name")).output(literal("\", ")).output(placeholder("name", "CamelCase")).output(literal(")")));
		rules.add(rule().condition(all(all(not(allTypes("file")), allTypes("parameter", "form")), trigger("parameter"))).output(literal("entityPart(\"")).output(placeholder("name")).output(literal("\", ")).output(placeholder("name", "CamelCase")).output(literal(")")));
		rules.add(rule().condition(all(all(allTypes("file"), allTypes("parameter")), trigger("parameter"))).output(literal("entityPart(new io.intino.alexandria.Resource(\"")).output(placeholder("name", "CamelCase")).output(literal("\", ")).output(placeholder("name")).output(literal("))")));
		rules.add(rule().condition(trigger("enumparameter")).output(literal("public enum ")).output(placeholder("class", "PascalCase")).output(literal(" {\n\t")).output(placeholder("value").multiple(", ")).output(literal("\n}")));
		rules.add(rule().condition(all(allTypes("list"), trigger("return"))).output(literal("return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), new com.google.gson.reflect.TypeToken<Array")).output(placeholder("value")).output(literal(">(){}.getType());")));
		rules.add(rule().condition(all(allTypes("set"), trigger("return"))).output(literal("return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), new com.google.gson.reflect.TypeToken<Hash")).output(placeholder("value")).output(literal(">(){}.getType());")));
		rules.add(rule().condition(all(allTypes("file"), trigger("return"))).output(literal("String filename = !response.headers().containsKey(\"Content-Disposition\") ? \"filename=content\":\n\tArrays.stream(response.headers().get(\"Content-Disposition\").split(\";\")).filter(c-> c.startsWith(\"filename\")).findFirst().orElse(null);\nreturn new io.intino.alexandria.Resource(filename.split(\"=\")[1], response.contentType(), response.contentAsStream());")));
		rules.add(rule().condition(all(all(not(allTypes("list")), not(attribute("value","void"))), trigger("return"))).output(literal("return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), ")).output(placeholder("value")).output(literal(".class);")));
		rules.add(rule().condition(trigger("return")));
		rules.add(rule().condition(trigger("response")).output(placeholder("value")));
		rules.add(rule().condition(allTypes("notification")).output(literal("public void listen")).output(placeholder("name", "PascalCase")).output(literal("(")).output(expression().output(placeholder("parameter", "signature").multiple(", ")).output(literal(", "))).output(literal("java.util.function.Consumer<String> listener) throws InternalServerError {\n\tRequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis)\n\t\t")).output(expression().output(literal(".")).output(placeholder("auth"))).output(literal("\n\t\t")).output(expression().output(literal(".")).output(placeholder("parameter").multiple("."))).output(literal("\n\t\t.build(RequestBuilder.Method.POST, \"")).output(placeholder("path")).output(literal("\");\n\ttry {\n\t\tthis.notifier.listen(listener, request.execute().content().trim());\n\t} catch (AlexandriaException e) {\n\t\tthrow new InternalServerError(e.message());\n\t}\n}\n\npublic void stopListen")).output(placeholder("name", "PascalCase")).output(literal("() {\n\tthis.notifier.close();\n}")));
		rules.add(rule().condition(all(allTypes("basic"), trigger("auth"))).output(literal("basicAuth(this.user, this.pasword)")));
		rules.add(rule().condition(all(allTypes("bearer"), trigger("auth"))).output(literal("bearerAuth(this.token)")));
		rules.add(rule().condition(all(allTypes("authentication", "basic"), trigger("parameter"))).output(literal("String user, String password")));
		rules.add(rule().condition(all(allTypes("authentication", "bearer"), trigger("parameter"))).output(literal("String token")));
		rules.add(rule().condition(all(allTypes("authentication", "withCertificate"), trigger("parameter"))).output(literal("URL certificate")));
		rules.add(rule().condition(all(allTypes("authentication", "withCertificate"), trigger("assign"))).output(literal("this.certificate = certificate;")));
		rules.add(rule().condition(all(allTypes("authentication", "basic"), trigger("assign"))).output(literal("this.user = user;\nthis.password = password;")));
		rules.add(rule().condition(all(allTypes("authentication", "bearer"), trigger("assign"))).output(literal("this.token = token;")));
		rules.add(rule().condition(all(allTypes("authentication", "withCertificate"), trigger("assign"))).output(literal("this.certificate = certificate;")));
		rules.add(rule().condition(all(all(allTypes("authentication"), allTypes("basic")), trigger("field"))).output(literal("private final String user;\nprivate final String password;")));
		rules.add(rule().condition(all(all(allTypes("authentication"), allTypes("bearer")), trigger("field"))).output(literal("private final String token;")));
		rules.add(rule().condition(all(allTypes("authentication", "withCertificate"), trigger("field"))).output(literal("private final URL certificate;")));
		rules.add(rule().condition(all(allTypes("parameter", "file"), trigger("signature"))).output(literal("io.intino.alexandria.Resource.InputStreamProvider ")).output(placeholder("name", "CamelCase")));
		rules.add(rule().condition(all(allTypes("parameter"), trigger("signature"))).output(placeholder("parameterType")).output(literal(" ")).output(placeholder("name", "CamelCase")));
		rules.add(rule().condition(all(allTypes("exceptionResponses"), trigger("throws"))).output(placeholder("exceptionResponse", "throws").multiple("\nelse ")));
		rules.add(rule().condition(all(allTypes("exceptionResponse"), trigger("throws"))).output(literal("if (e instanceof ")).output(placeholder("exceptionName")).output(literal(") throw ((")).output(placeholder("exceptionName")).output(literal(") e);")));
		rules.add(rule().condition(all(allTypes("exceptionResponses"), trigger("declaration"))).output(literal("throws ")).output(expression().output(placeholder("exceptionResponse", "declaration").multiple(", ")).output(literal(","))).output(literal(" InternalServerError")));
		rules.add(rule().condition(all(allTypes("exceptionResponse"), trigger("declaration"))).output(placeholder("exceptionName")));
		rules.add(rule().condition(all(allTypes("schemaImport"), trigger("schemaimport"))).output(literal("import ")).output(placeholder("package")).output(literal(".schemas.*;")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}