package io.intino.konos.builder.codegeneration.services.cli;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class CliCommandTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("command", "confirmation")).output(literal("package ")).output(placeholder("package", "validPackage")).output(literal(".cli.commands;\n\nimport io.intino.alexandria.cli.Cli;\nimport io.intino.alexandria.cli.Context;\nimport io.intino.alexandria.cli.Response;\nimport io.intino.alexandria.cli.command.MessageProperties;\nimport io.intino.alexandria.cli.response.Text;\nimport ")).output(placeholder("package", "validPackage")).output(literal(".")).output(placeholder("box", "FirstUpperCase")).output(literal("Box;\nimport ")).output(placeholder("package", "validPackage")).output(literal(".cli.commands.*;\n\npublic class ")).output(placeholder("option", "firstUpperCase")).output(literal("Command {\n    private TrooperBox box;\n\n    public ")).output(placeholder("option", "firstUpperCase")).output(literal("Command(")).output(placeholder("box", "FirstUpperCase")).output(literal("Box box) {\n        this.box = box;\n    }\n\n    public Response execute(MessageProperties properties, String command, String... args) {\n        Context context = properties.context();\n        Cli.CommandInfo lastCommand = context.lastCommand();\n        if (lastCommand == null) return new Text(\"Command not found\");\n        ")).output(placeholder("condition").multiple("\n")).output(literal("\n        return new Text(\"Command not found\");\n    }\n\n}")));
		rules.add(rule().condition(allTypes("command")).output(literal("package ")).output(placeholder("package", "validPackage")).output(literal(".cli.commands;\n\nimport io.intino.alexandria.cli.Command;\nimport io.intino.alexandria.cli.Response;\nimport io.intino.alexandria.cli.command.MessageProperties;\nimport io.intino.alexandria.cli.response.Line;\nimport io.intino.alexandria.cli.response.MessageData;\nimport ")).output(placeholder("package", "validPackage")).output(literal(".")).output(placeholder("box", "FirstUpperCase")).output(literal("Box;\nimport ")).output(placeholder("package", "validPackage")).output(literal(".actions.")).output(placeholder("name", "firstUppercase")).output(literal("Action;\n\nimport java.util.ArrayList;\nimport java.util.List;\n\npublic class ")).output(placeholder("name", "firstUppercase")).output(literal("Command implements Command {\n    private ")).output(placeholder("box", "FirstUpperCase")).output(literal("Box box;\n\n    public ")).output(placeholder("name", "firstUppercase")).output(literal("Command(")).output(placeholder("box", "FirstUpperCase")).output(literal("Box box) {\n        this.box = box;\n    }\n\n    ")).output(placeholder("response", "provider")).output(literal("\n    ")).output(placeholder("response", "definition").multiple("\n")).output(literal("\n\n    @Override\n    public ")).output(placeholder("response", "type")).output(literal(" execute(MessageProperties properties, String command, String... args) {\n        return ")).output(placeholder("execute")).output(literal(";\n    }\n\n    ")).output(placeholder("response", "method").multiple("\n")).output(literal("\n\n    private ")).output(placeholder("name", "firstUppercase")).output(literal("Action fill(")).output(placeholder("name", "firstUppercase")).output(literal("Action action, MessageProperties properties, String... args) {\n        action.box = this.box;\n        action.state = properties.context().state();\n        action.properties = properties;\n        ")).output(placeholder("parameter").multiple("\n")).output(literal("\n        return action;\n    }\n\n}")));
		rules.add(rule().condition(allTypes("execute", "multiline")).output(literal("new ")).output(placeholder("response", "type")).output(literal("(")).output(placeholder("response", "definitionDeclaration")).output(literal(", fill(new ")).output(placeholder("name", "firstUppercase")).output(literal("Action(), properties, args).execute())")));
		rules.add(rule().condition(allTypes("execute", "confirmation")).output(literal("new ")).output(placeholder("response", "type")).output(literal("(\"")).output(placeholder("question")).output(literal("\", List.of(\"")).output(placeholder("option").multiple("\", \"")).output(literal("\"), fill(new ")).output(placeholder("name", "firstUppercase")).output(literal("Action(), properties, args).execute())")));
		rules.add(rule().condition(allTypes("execute")).output(literal("new ")).output(placeholder("response", "type")).output(literal("(fill(new ")).output(placeholder("name", "firstUppercase")).output(literal("Action(), properties, args).execute())")));
		rules.add(rule().condition(allTypes("parameter", "list")).output(literal("action.")).output(placeholder("name")).output(literal(" = java.util.Arrays.asList(args);")));
		rules.add(rule().condition(allTypes("parameter")).output(literal("action.")).output(placeholder("name")).output(literal(" = args.length > ")).output(placeholder("index")).output(literal(" ? args[")).output(placeholder("index")).output(literal("] : null;")));
		rules.add(rule().condition(all(allTypes("response", "multiline"), trigger("type"))).output(literal("io.intino.alexandria.cli.response.MultiLine")));
		rules.add(rule().condition(all(allTypes("response", "attachment"), trigger("type"))).output(literal("io.intino.alexandria.cli.response.Attachment")));
		rules.add(rule().condition(all(allTypes("response", "confirmation"), trigger("type"))).output(literal("io.intino.alexandria.cli.response.Question")));
		rules.add(rule().condition(all(allTypes("response"), trigger("type"))).output(literal("io.intino.alexandria.cli.response.Text")));
		rules.add(rule().condition(all(allTypes("response", "confirmation"), trigger("method"))).output(placeholder("option", "method").multiple("\n")));
		rules.add(rule().condition(all(allTypes("response"), trigger("method"))));
		rules.add(rule().condition(all(allTypes("response", "multiline"), trigger("provider"))).output(literal("public static class MultiLineProvider extends io.intino.alexandria.cli.response.MultiLineProvider {\n    ")).output(placeholder("line", "declaration").multiple("\n")).output(literal("\n\n    ")).output(placeholder("line", "method").multiple("\n")).output(literal("\n    ")).output(placeholder("line", "class").multiple("\n")).output(literal("\n\n    @Override\n    protected MessageData data(String line) {\n        ")).output(placeholder("line", "data").multiple("\n")).output(literal("\n        return null;\n    }\n\n    @Override\n    protected List<MessageData> dataList(String line) {\n        ")).output(placeholder("line", "dataList").multiple("\n")).output(literal("\n        return null;\n    }\n}")));
		rules.add(rule().condition(all(allTypes("response", "multiline"), trigger("definition"))).output(placeholder("line", "definition").multiple("\n")));
		rules.add(rule().condition(all(allTypes("response", "multiline"), trigger("definitiondeclaration"))).output(literal("List.of(")).output(placeholder("line", "definitionDeclaration").multiple(", ")).output(literal(")")));
		rules.add(rule().condition(all(allTypes("line", "multiple"), trigger("declaration"))).output(literal("private List<MessageData> ")).output(placeholder("name", "firstLowerCase")).output(literal(" = new ArrayList<>();")));
		rules.add(rule().condition(all(allTypes("line"), trigger("declaration"))).output(literal("private MessageData ")).output(placeholder("name", "firstLowerCase")).output(literal(" = new MessageData();")));
		rules.add(rule().condition(all(allTypes("line", "multiple"), trigger("method"))).output(literal("public MultiLineProvider add")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("name", "firstUpperCase")).output(literal(" value) {\n    this.")).output(placeholder("name", "firstLowerCase")).output(literal(".add(value);\n    return this;\n}\n\npublic MultiLineProvider addAll")).output(placeholder("name", "firstUpperCase")).output(literal("(List<")).output(placeholder("name", "firstUpperCase")).output(literal("> values) {\n    this.")).output(placeholder("name", "firstLowerCase")).output(literal(".addAll(values);\n    return this;\n}")));
		rules.add(rule().condition(all(allTypes("line"), trigger("method"))).output(literal("public MultiLineProvider ")).output(placeholder("name", "firstLowerCase")).output(literal("Variable(String variable, String value) {\n    this.")).output(placeholder("name", "firstLowerCase")).output(literal(".add(variable, value);\n    return this;\n}")));
		rules.add(rule().condition(all(allTypes("line", "multiple"), trigger("class"))).output(literal("public static class ")).output(placeholder("name", "firstUpperCase")).output(literal(" extends MessageData {\n}")));
		rules.add(rule().condition(all(allTypes("line"), trigger("class"))));
		rules.add(rule().condition(all(allTypes("line", "multiple"), trigger("data"))));
		rules.add(rule().condition(all(allTypes("line"), trigger("data"))).output(literal("if (line.equals(\"")).output(placeholder("name")).output(literal("\")) return ")).output(placeholder("name", "firstLowerCase")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("line", "multiple"), trigger("datalist"))).output(literal("if (line.equals(\"")).output(placeholder("name")).output(literal("\")) return ")).output(placeholder("name", "firstLowerCase")).output(literal(";")));
		rules.add(rule().condition(all(allTypes("line"), trigger("datalist"))));
		rules.add(rule().condition(all(allTypes("line"), trigger("definition"))).output(literal("private static final Line ")).output(placeholder("name", "firstUpperCase")).output(literal("Line = new Line(\"")).output(placeholder("name")).output(literal("\", \"")).output(placeholder("content")).output(literal("\", ")).output(placeholder("addBreak")).output(literal(", ")).output(placeholder("multiple")).output(expression().output(literal(", \"")).output(placeholder("dependant")).output(literal("\""))).output(literal(");")));
		rules.add(rule().condition(all(allTypes("line"), trigger("definitiondeclaration"))).output(placeholder("name", "firstUpperCase")).output(literal("Line")));
		rules.add(rule().condition(allTypes("condition")).output(literal("if (lastCommand.name().equals(\"")).output(placeholder("command")).output(literal("\")) return new ")).output(placeholder("commandName", "firstUpperCase")).output(literal("Command(box).when")).output(placeholder("option", "firstUpperCase")).output(literal("(properties, lastCommand.name(), lastCommand.parameters().toArray(new String[0]));")));
		rules.add(rule().condition(allTypes("option")).output(literal("public io.intino.alexandria.cli.response.Text when")).output(placeholder("value", "firstUppercase")).output(literal("(MessageProperties properties, String command, String... args) {\n    return fill(new ")).output(placeholder("commandName", "firstUppercase")).output(literal("Action(), properties, args).when")).output(placeholder("value", "firstUppercase")).output(literal("();\n}")));
		rules.add(rule().condition(allTypes("multiple")).output(literal("new Line.Multiple(")).output(placeholder("value")).output(literal(", Line.Multiple.Arrangement.valueOf(\"")).output(placeholder("arrangement")).output(literal("\"))")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}