package io.intino.konos.builder.codegeneration.services.ui.templates;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class AbstractDisplaySkeletonTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("display", "exposed")).output(literal("package ")).output(placeholder("package")).output(literal(".ui.displays")).output(expression().output(literal(".")).output(placeholder("packageType")).output(literal("s"))).output(literal(";\n\nimport ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.notifiers.")).output(placeholder("name", "PascalCase")).output(literal("ProxyNotifier;\nimport io.intino.alexandria.ui.displays.ProxyDisplay;\nimport io.intino.alexandria.ui.services.push.UISession;\n\nimport java.util.HashMap;\nimport java.util.Map;\n\npublic class ")).output(placeholder("name", "PascalCase")).output(literal("Proxy extends ProxyDisplay<")).output(placeholder("name", "PascalCase")).output(literal("ProxyNotifier> {\n\n\tpublic ")).output(placeholder("name", "firstUpperCase")).output(literal("Proxy(io.intino.alexandria.ui.server.pages.Unit unit) {\n\t\tsuper(\"")).output(placeholder("name", "firstUpperCase")).output(literal("\", unit, \"/")).output(placeholder("name", "CamelCase", "lowercase")).output(literal("proxy\");\n\t}\n\n\t")).output(expression().output(placeholder("request", "exposed").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(placeholder("parameter", "method").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(placeholder("event", "method").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(allTypes("display")).output(literal("package ")).output(placeholder("package")).output(literal(".ui.displays")).output(expression().output(literal(".")).output(placeholder("packageType")).output(literal("s"))).output(literal(";\n\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.exceptions.*;\nimport io.intino.alexandria.ui.displays.components.*;\nimport ")).output(placeholder("package")).output(literal(".ui.*;\n")).output(placeholder("schemaImport")).output(literal("\nimport ")).output(placeholder("package", "validPackage")).output(literal(".")).output(placeholder("box", "firstUpperCase")).output(literal("Box;\n\n")).output(placeholder("templatesImport")).output(literal("\n")).output(placeholder("tablesImport")).output(literal("\n")).output(placeholder("listsImport")).output(literal("\n")).output(placeholder("magazinesImport")).output(literal("\n")).output(placeholder("mapsImport")).output(literal("\n")).output(placeholder("dynamicTablesImport")).output(literal("\n")).output(placeholder("blocksImport")).output(literal("\n")).output(placeholder("itemsImport")).output(literal("\n")).output(placeholder("rowsImport")).output(literal("\n")).output(placeholder("notifierImport")).output(literal("\n\npublic ")).output(expression().output(placeholder("abstract", "lowerCase"))).output(literal(" class ")).output(placeholder("abstract")).output(placeholder("name", "firstUpperCase")).output(placeholder("parametrized")).output(literal(" ")).output(placeholder("displayExtends")).output(expression().output(literal(" ")).output(placeholder("implements"))).output(literal(" {\n\t")).output(expression().output(placeholder("reference", "declaration").multiple("\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "declarations").multiple("\n"))).output(literal("\n\n\tpublic ")).output(placeholder("abstract")).output(placeholder("name", "firstUpperCase")).output(literal("(")).output(placeholder("abstractBox", "type")).output(literal(" box) {\n\t\tsuper(box);\n\t\tid(\"")).output(placeholder("id")).output(literal("\");\n\t}\n\n\t@Override\n\tpublic void init() {\n\t\tsuper.init();\n\t\t")).output(expression().output(placeholder("reference").multiple("\n"))).output(literal("\n\t\t")).output(expression().output(placeholder("componentReferences"))).output(literal("\n\t\t")).output(expression().output(placeholder("component", "initializations").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic void remove() {\n\t\tsuper.remove();\n\t\t")).output(expression().output(placeholder("component", "unregister").multiple("\n"))).output(literal("\n\t}\n\t")).output(placeholder("methods")).output(literal("\n\t")).output(expression().output(placeholder("component", "class").multiple("\n\n"))).output(literal("\n\t")).output(expression().output(placeholder("component", "method").multiple("\n\n"))).output(literal("\n}")));
		rules.add(rule().condition(allTypes("notifierImport", "table")).output(literal("import io.intino.alexandria.ui.displays.notifiers.TableNotifier;")));
		rules.add(rule().condition(allTypes("notifierImport", "dynamictable")).output(literal("import io.intino.alexandria.ui.displays.notifiers.DynamicTableNotifier;")));
		rules.add(rule().condition(allTypes("notifierImport", "item")).output(literal("import io.intino.alexandria.ui.displays.notifiers.ItemNotifier;")));
		rules.add(rule().condition(allTypes("notifierImport", "row")).output(literal("import io.intino.alexandria.ui.displays.notifiers.RowNotifier;")));
		rules.add(rule().condition(allTypes("notifierImport", "template", "exposed")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.notifiers.")).output(placeholder("name", "firstUpperCase")).output(literal("Notifier;")));
		rules.add(rule().condition(allTypes("notifierImport", "template")).output(literal("import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;")));
		rules.add(rule().condition(allTypes("notifierImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.notifiers.")).output(placeholder("name", "firstUpperCase")).output(literal("Notifier;")));
		rules.add(rule().condition(allTypes("parametrized", "generic")).output(literal("<DN extends ")).output(placeholder("name", "firstUpperCase")).output(literal("Notifier, ")).output(placeholder("abstractBox", "extension")).output(literal(">")));
		rules.add(rule().condition(allTypes("parametrized", "exposed")).output(literal("<DN extends ")).output(placeholder("name", "firstUpperCase")).output(literal("Notifier, ")).output(placeholder("abstractBox", "extension")).output(literal(">")));
		rules.add(rule().condition(allTypes("parametrized")).output(placeholder("abstractBox", "extensionTagged")));
		rules.add(rule().condition(allTypes("displayExtends", "generic")).output(literal("extends ")).output(placeholder("parent")).output(literal("<DN, ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends", "template", "exposed")).output(literal("extends io.intino.alexandria.ui.displays.components.Template<DN, ")).output(placeholder("modelClass")).output(literal(", ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends", "template")).output(literal("extends io.intino.alexandria.ui.displays.components.Template<TemplateNotifier, ")).output(placeholder("modelClass")).output(literal(", ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends", "table")).output(literal("extends io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(placeholder("name", "firstUpperCase")).output(literal("Row, ")).output(placeholder("itemClass")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends", "dynamictable")).output(literal("extends io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(placeholder("name", "firstUpperCase")).output(literal("Row, ")).output(placeholder("itemClass")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends", "collection")).output(literal("extends io.intino.alexandria.ui.displays.components.")).output(placeholder("type", "firstUpperCase")).output(placeholder("facet").multiple("")).output(literal("<")).output(placeholder("abstractBox", "type")).output(literal(", ")).output(placeholder("componentType")).output(literal(", ")).output(placeholder("itemClass")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends", "item")).output(literal("extends io.intino.alexandria.ui.displays.components.Item<ItemNotifier, ")).output(placeholder("itemClass")).output(literal(", ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends", "row")).output(literal("extends io.intino.alexandria.ui.displays.components.Row<RowNotifier, ")).output(placeholder("itemClass")).output(literal(", ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends", "dialog")).output(literal("extends io.intino.alexandria.ui.displays.components.Dialog<")).output(placeholder("name", "firstUpperCase")).output(literal("Notifier, ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("displayExtends")).output(literal("extends io.intino.alexandria.ui.displays.")).output(placeholder("type", "firstUpperCase")).output(literal("<")).output(placeholder("name", "firstUpperCase")).output(literal("Notifier, ")).output(placeholder("abstractBox", "type")).output(literal(">")));
		rules.add(rule().condition(allTypes("templatesImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.templates.*;")));
		rules.add(rule().condition(allTypes("tablesImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.tables.*;")));
		rules.add(rule().condition(allTypes("listsImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.lists.*;")));
		rules.add(rule().condition(allTypes("magazinesImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.magazines.*;")));
		rules.add(rule().condition(allTypes("mapsImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.maps.*;")));
		rules.add(rule().condition(allTypes("dynamicTablesImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.dynamictables.*;")));
		rules.add(rule().condition(allTypes("blocksImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.blocks.*;")));
		rules.add(rule().condition(allTypes("itemsImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.items.*;")));
		rules.add(rule().condition(allTypes("rowsImport")).output(literal("import ")).output(placeholder("package", "validPackage")).output(literal(".ui.displays.rows.*;")));
		rules.add(rule().condition(allTypes("componentReferences", "forRoot")).output(expression().output(placeholder("component", "rootReferences").multiple("\n"))));
		rules.add(rule().condition(allTypes("componentReferences")).output(expression().output(placeholder("component", "references").multiple("\n"))));
		rules.add(rule().condition(allTypes("attribute")).output(literal("public ")).output(placeholder("clazz")).output(literal(" ")).output(placeholder("name", "firstLowerCase")).output(literal(";")));
		rules.add(rule().condition(allTypes("methods", "dynamicloaded")).output(literal("@Override\npublic io.intino.alexandria.ui.displays.components.DynamicLoaded.LoadTime loadTime() {\n\treturn io.intino.alexandria.ui.displays.components.DynamicLoaded.LoadTime.valueOf(\"")).output(placeholder("loadTime")).output(literal("\");\n}\n\n@Override\npublic void showLoading() {\n\tnotifier.refreshLoading(true);\n}\n\n@Override\npublic void hideLoading() {\n\tnotifier.refreshLoading(false);\n}")));
		rules.add(rule().condition(all(allTypes("request"), trigger("exposed"))).output(literal("public void ")).output(placeholder("name")).output(literal("(")).output(expression().output(placeholder("parameter")).output(literal(" value"))).output(literal(") {\n\trequest(\"")).output(placeholder("name")).output(literal("\"")).output(expression().output(literal(", ")).output(placeholder("parameter", "parameterValue"))).output(literal(");\n}")));
		rules.add(rule().condition(trigger("parametervalue")).output(literal("value")));
		rules.add(rule().condition(all(allTypes("parameter"), trigger("method"))).output(literal("public void ")).output(placeholder("value", "firstLowerCase")).output(literal("(String value) {\n\tadd(\"")).output(placeholder("value")).output(literal("\", value);\n}")));
		rules.add(rule().condition(allTypes("parameter")).output(placeholder("value")));
		rules.add(rule().condition(all(allTypes("event"), trigger("method"))).output(literal("public void on")).output(placeholder("name", "firstUpperCase")).output(literal("(java.util.function.Consumer<Boolean> listener) {\n\tonMessage(\"")).output(placeholder("name", "firstLowerCase")).output(literal("\").then(listener);\n}")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}