package io.intino.konos.builder.codegeneration.services.rest;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.*;
import static io.intino.itrules.template.outputs.Outputs.*;

public class RestResourceTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("notification")).output(literal("package ")).output(placeholder("package")).output(literal(".rest.notifications;\n\nimport java.util.List;\nimport java.util.ArrayList;\nimport io.intino.alexandria.exceptions.*;\nimport ")).output(placeholder("package")).output(literal(".*;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.rest.Resource;\nimport io.intino.alexandria.http.pushservice.Client;\nimport io.intino.alexandria.http.pushservice.Session;\nimport io.intino.alexandria.http.pushservice.MessageCarrier;\nimport io.intino.alexandria.http.server.AlexandriaHttpManager;\nimport io.intino.alexandria.http.server.AlexandriaHttpNotifier;\nimport io.intino.alexandria.http.pushservice.PushService;\n\n")).output(placeholder("schemaImport")).output(literal("\n\npublic class ")).output(placeholder("name", "PascalCase")).output(literal("Notification implements Resource {\n\n\tprivate ")).output(placeholder("box", "FirstUpperCase")).output(literal("Box box;\n\tprivate AlexandriaHttpManager<?> manager;\n\n\tpublic ")).output(placeholder("name", "PascalCase")).output(literal("Notification(")).output(placeholder("box", "FirstUpperCase")).output(literal("Box box, AlexandriaHttpManager manager) {\n\t\tthis.box = box;\n\t\tthis.manager = manager;\n\t}\n\n\tpublic void execute() ")).output(expression().output(literal("throws ")).output(placeholder("throws").multiple(", "))).output(literal(" {\n\t\tSession session = manager.currentSession();\n\t\tString clientId = java.util.UUID.randomUUID().toString();\n\t\t")).output(placeholder("package", "validPackage")).output(literal(".actions.")).output(placeholder("name", "PascalCase")).output(literal("Action action = fill(new ")).output(placeholder("package", "validPackage")).output(literal(".actions.")).output(placeholder("name", "firstUpperCase")).output(literal("Action());\n\t\tmanager.pushService().onOpen(client -> {\n\t\t\taction.onOpen((Client)client, notifier(session, (Client)client));\n\t\t\treturn true;\n\t\t});\n\t\tmanager.pushService().onClose(clientId).execute((java.util.function.Consumer<Client>) action::onClose);\n\t\t")).output(expression().output(placeholder("returnType", "methodCall"))).output(literal("manager.baseUrl().replace(\"http\", \"ws\") + \"/_alexandria/push?id=\" + clientId")).output(expression().output(placeholder("returnType", "ending"))).output(literal(";\n\t}\n\n\tprivate ")).output(placeholder("package", "validPackage")).output(literal(".actions.")).output(placeholder("name", "PascalCase")).output(literal("Action fill(")).output(placeholder("package", "validPackage")).output(literal(".actions.")).output(placeholder("name", "PascalCase")).output(literal("Action action) {\n\t\taction.box = this.box;\n\t\taction.context = context();\n\t\t")).output(expression().output(placeholder("parameter", "assign").multiple("\n"))).output(literal("\n\t\treturn action;\n\t}\n\n\t")).output(expression().output(placeholder("returnType", "method"))).output(literal("\n\n\tprivate AlexandriaHttpNotifier notifier(Session session, Client client) {\n\t\treturn new AlexandriaHttpNotifier(new MessageCarrier(manager.pushService(), session, client));\n\t}\n\n\tprivate io.intino.alexandria.http.server.AlexandriaHttpContext context() {\n\t\tio.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);\n\t\t")).output(expression().output(placeholder("authenticationValidator", "put"))).output(literal("\n\t\tcontext.put(\"pathInfo\", manager.request().raw().getPathInfo());\n\t\tcontext.put(\"ip\", manager.ip());\n\t\treturn context;\n\t}\n}\n\n\n")));
		rules.add(rule().condition(allTypes("resource")).output(literal("package ")).output(placeholder("package")).output(literal(".rest.resources;\n\nimport java.util.List;\nimport java.util.Set;\nimport java.util.ArrayList;\nimport io.intino.alexandria.exceptions.*;\nimport ")).output(placeholder("package")).output(literal(".*;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.rest.*;\nimport io.intino.alexandria.http.server.AlexandriaHttpManager;\nimport io.intino.alexandria.http.pushservice.PushService;\n\n")).output(placeholder("schemaImport")).output(literal("\n\npublic class ")).output(placeholder("operation", "firstUpperCase")).output(placeholder("name", "PascalCase")).output(literal("Resource implements Resource {\n\t")).output(expression().output(placeholder("word", "declaration").multiple("\n"))).output(literal("\n\n\tprivate ")).output(placeholder("box", "FirstUpperCase")).output(literal("Box box;\n\tprivate AlexandriaHttpManager<PushService<?,?>> manager;\n\n\tpublic ")).output(placeholder("operation", "firstUpperCase")).output(placeholder("name", "PascalCase")).output(literal("Resource(")).output(placeholder("box", "FirstUpperCase")).output(literal("Box box, AlexandriaHttpManager manager) {\n\t\tthis.box = box;\n\t\tthis.manager = manager;\n\t}\n\n\tpublic void execute() throws AlexandriaException {\n\t\t")).output(expression().output(placeholder("returnType", "methodCall"))).output(literal("fill(new ")).output(placeholder("package", "validPackage")).output(literal(".actions.")).output(placeholder("operation", "firstUpperCase")).output(placeholder("name", "PascalCase")).output(literal("Action()).execute()")).output(expression().output(placeholder("returnType", "ending"))).output(literal(";\n\t}\n\n\tprivate ")).output(placeholder("package", "validPackage")).output(literal(".actions.")).output(placeholder("operation", "firstUpperCase")).output(placeholder("name", "PascalCase")).output(literal("Action fill(")).output(placeholder("package", "validPackage")).output(literal(".actions.")).output(placeholder("operation", "firstUpperCase")).output(placeholder("name", "PascalCase")).output(literal("Action action) throws AlexandriaException {\n\t\taction.box = this.box;\n\t\taction.context = context();\n\t\ttry {\n\t\t\t")).output(expression().output(placeholder("parameter", "assign").multiple("\n"))).output(literal("\n\t\t} catch (Throwable e) {\n\t\t\taction.onMalformedRequest(e);\n\t\t}\n\t\treturn action;\n\t}\n\n\t")).output(expression().output(placeholder("returnType", "method"))).output(literal("\n\n\tprivate io.intino.alexandria.http.server.AlexandriaHttpContext context() {\n\t\tio.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);\n\t\t")).output(placeholder("authenticationValidator", "put")).output(literal("\n\t\tcontext.put(\"pathInfo\", manager.request().raw().getPathInfo());\n\t\tcontext.put(\"ip\", manager.ip());\n\t\treturn context;\n\t}\n}")));
		rules.add(rule().condition(all(allTypes("word"), trigger("declaration"))).output(literal("public enum ")).output(placeholder("name", "PascalCase")).output(literal(" {\n\t")).output(placeholder("words").multiple(", ")).output(literal(";\n}")));
		rules.add(rule().condition(all(attribute("void"), trigger("methodcall"))));
		rules.add(rule().condition(all(allTypes("redirect"), trigger("methodcall"))).output(literal("redirect(")));
		rules.add(rule().condition(all(allTypes("response"), trigger("methodcall"))).output(literal("write(")));
		rules.add(rule().condition(all(attribute("void"), trigger("ending"))));
		rules.add(rule().condition(trigger("ending")).output(literal(")")));
		rules.add(rule().condition(all(attribute("void"), trigger("write"))));
		rules.add(rule().condition(all(allTypes("redirect"), trigger("method"))).output(literal("private void redirect(String url) {\n\tmanager.redirect(url);\n}")));
		rules.add(rule().condition(all(allTypes("response", "multipart"), trigger("method"))).output(literal("private void write(")).output(placeholder("value")).output(literal(" object) {\n\tmanager.write(object.content());\n}")));
		rules.add(rule().condition(all(allTypes("response", "file"), trigger("method"))).output(literal("private void write(")).output(placeholder("value")).output(literal(" object) {\n\tmanager.write(object);\n}")));
		rules.add(rule().condition(all(allTypes("response"), trigger("method"))).output(literal("private void write(")).output(placeholder("value")).output(literal(" object) {\n\tmanager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object)")).output(expression().output(literal(", \"")).output(placeholder("format")).output(literal("\""))).output(literal(");\n}")));
		rules.add(rule().condition(all(allTypes("parameter"), trigger("type"))).output(placeholder("parameterType")));
		rules.add(rule().condition(all(all(allTypes("parameter", "defaultvalue"), attribute("in","body")), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("OrDefault(\"")).output(placeholder("defaultValue")).output(literal("\"), ")).output(placeholder("parameterType")).output(literal(");")));
		rules.add(rule().condition(all(allTypes("parameter", "defaultvalue"), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("OrDefault(\"")).output(placeholder("name")).output(literal("\", \"")).output(placeholder("defaultValue")).output(literal("\"), ")).output(placeholder("parameterType")).output(literal(");")));
		rules.add(rule().condition(all(all(allTypes("parameter", "file", "list"), attribute("in","form")), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = manager.fromPartsAsResources();")));
		rules.add(rule().condition(all(all(allTypes("parameter", "required", "file"), attribute("in","form")), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("AsResourceOrElseThrow(\"")).output(placeholder("name")).output(literal("\", () -> new BadRequest(\"Parameter missed: ")).output(placeholder("name")).output(literal("\"));")));
		rules.add(rule().condition(all(all(allTypes("parameter", "file"), attribute("in","form")), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("AsResource(\"")).output(placeholder("name")).output(literal("\");")));
		rules.add(rule().condition(all(all(allTypes("parameter", "required"), attribute("in","form")), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("AsStringOrElseThrow(\"")).output(placeholder("name")).output(literal("\", () -> new BadRequest(\"Parameter missed: ")).output(placeholder("name")).output(literal("\")), ")).output(placeholder("parameterType")).output(literal(");")));
		rules.add(rule().condition(all(all(allTypes("parameter"), attribute("in","form")), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("AsString(\"")).output(placeholder("name")).output(literal("\"), ")).output(placeholder("parameterType")).output(literal(");")));
		rules.add(rule().condition(all(all(allTypes("parameter", "file"), attribute("in","body")), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = new io.intino.alexandria.Resource(\"")).output(placeholder("name")).output(literal("\", manager.fromBodyAsBytes());")));
		rules.add(rule().condition(all(all(allTypes("parameter"), attribute("in","body")), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("(), ")).output(placeholder("parameterType")).output(literal(");")));
		rules.add(rule().condition(all(allTypes("parameter", "required"), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("OrElseThrow(\"")).output(placeholder("name")).output(literal("\", () -> new BadRequest(\"Parameter missed: ")).output(placeholder("name")).output(literal("\")), ")).output(placeholder("parameterType")).output(literal(");")));
		rules.add(rule().condition(all(allTypes("parameter"), trigger("assign"))).output(literal("action.")).output(placeholder("name", "CamelCase")).output(literal(" = io.intino.alexandria.rest.RequestAdapter.adapt(manager.from")).output(placeholder("in", "firstUpperCase")).output(literal("(\"")).output(placeholder("name")).output(literal("\"), ")).output(placeholder("parameterType")).output(literal(");")));
		rules.add(rule().condition(all(allTypes("list"), trigger("parametertype"))).output(literal("new com.google.gson.reflect.TypeToken<java.util.List<")).output(placeholder("value")).output(literal(">>(){}.getType()")));
		rules.add(rule().condition(all(allTypes("authenticationValidator", "Custom"), trigger("put"))));
		rules.add(rule().condition(all(allTypes("authenticationValidator"), trigger("put"))).output(literal("context.put(\"Authorization\", manager.fromHeader(\"Authorization\") != null ? manager.fromHeader(\"Authorization\").replace(\"")).output(placeholder("type")).output(literal(" \", \"\") : null);")));
		rules.add(rule().condition(trigger("parametertype")).output(placeholder("value")).output(literal(".class")));
		rules.add(rule().condition(allTypes("schemaImport")).output(literal("import ")).output(placeholder("package")).output(literal(".schemas.*;")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}