package io.intino.konos.builder.codegeneration.ui.displays.components;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.ui.RendererWriter;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.dsl.CatalogComponents;
import io.intino.konos.dsl.Component;
import io.intino.konos.dsl.OtherComponents.Selector;
import io.intino.magritte.framework.Layer;

import java.util.List;

public class SelectorRenderer extends ComponentRenderer<Selector> {

	public SelectorRenderer(CompilationContext compilationContext, Selector component, RendererWriter provider) {
		super(compilationContext, component, provider);
	}

	@Override
	protected void fill(FrameBuilder builder) {
		super.fill(builder);
		if (element.isTabs()) builder.add("tabs");
		addBinding(builder);
		addAddressableMethod(builder);
	}

	@Override
	public FrameBuilder properties() {
		FrameBuilder result = super.properties();
		result.add("multipleSelection", element.multipleSelection() ? "true" : "false");
		if (element.isReadonly()) result.add("readonly", element.isReadonly());
		if (element.isFocused()) result.add("readonly", element.isFocused());
		addTabsProperties(result);
		addMenuProperties(result);
		addComboBoxProperties(result);
		addCollectionBoxProperties(result);
		addCheckBoxProperties(result);
		addRadioBoxProperties(result);
		addAddressableProperties(result);
		addToggleBoxProperties(result);
		return result;
	}

	private void addTabsProperties(FrameBuilder builder) {
		if (!element.isTabs()) return;
		Selector.Tabs.ScrollButtons scrollButtons = element.asTabs().scrollButtons();
		List<String> hiddenOptions = element.asTabs().componentList().stream().filter(Component::isOption).filter(o -> !o.visible()).map(Layer::name$).toList();
		if (!hiddenOptions.isEmpty()) hiddenOptions.forEach(o -> builder.add("hiddenOption", o));
		if (scrollButtons == Selector.Tabs.ScrollButtons.Off) return;
		builder.add("scrollButtons", scrollButtons);
	}

	private void addMenuProperties(FrameBuilder builder) {
		if (!element.isMenu()) return;
		Selector.Menu.Layout layout = element.asMenu().layout();
		if (layout == null) return;
		builder.add("layout", layout.name());
	}

	private void addComboBoxProperties(FrameBuilder builder) {
		if (!element.isComboBox()) return;
		Selector.ComboBox comboBox = element.asComboBox();
		builder.add("maxMenuHeight", comboBox.maxMenuHeight());
		String placeholder = comboBox.placeholder();
		if (placeholder != null && !placeholder.isEmpty()) builder.add("placeholder", placeholder);
		Selector.ComboBox.View view = comboBox.view();
		if (view != null && view != Selector.ComboBox.View.FieldView) builder.add("view", view.name());
	}

	private void addCollectionBoxProperties(FrameBuilder builder) {
		if (!element.isCollectionBox()) return;
		Selector.CollectionBox collectionBox = element.asCollectionBox();
		if (collectionBox.allowOther()) builder.add("allowOther", true);
		String placeholder = collectionBox.placeholder();
		if (placeholder != null && !placeholder.isEmpty()) builder.add("placeholder", placeholder);
	}

	private void addCheckBoxProperties(FrameBuilder builder) {
		if (!element.isCheckBox()) return;
		builder.add("layout", element.asCheckBox().layout().name());
	}

	private void addRadioBoxProperties(FrameBuilder builder) {
		if (!element.isRadioBox()) return;
		String selected = element.asRadioBox().selected();
		builder.add("layout", element.asRadioBox().layout().name());
		if (selected == null || selected.isEmpty()) return;
		builder.add("selected", selected);
	}

	private void addToggleBoxProperties(FrameBuilder builder) {
		if (!element.isToggleBox()) return;
		Selector.ToggleBox toggleBox = element.asToggleBox();
		String selected = toggleBox.selected();
		if (selected != null && !selected.isEmpty()) builder.add("selected", selected);
		Selector.ToggleBox.Layout layout = toggleBox.layout();
		builder.add("layout", layout.name());
		builder.add("size", toggleBox.size().name());
	}

	private void addBinding(FrameBuilder builder) {
		addCollectionBoxBinding(builder);
	}

	private void addCollectionBoxBinding(FrameBuilder builder) {
		if (!element.isCollectionBox()) return;
		Selector.CollectionBox collectionBox = element.asCollectionBox();
		CatalogComponents.Collection collection = collectionBox.source() != null ? collectionBox.source() : collectionBox.collection();
		if (collection == null) return;
		FrameBuilder binding = buildBaseFrame().add("binding").add("collectionbox");
		if (collectionBox.source() != null) binding.add("add");
		if (!isExposed(element)) binding.add("concreteBox", boxName());
		binding.add("name", nameOf(element));
		binding.add("collection", nameOf(collection));
		builder.add("binding", binding);
	}

	private void addAddressableMethod(FrameBuilder builder) {
		if (!element.isAddressable()) return;
		builder.add("methods", addressedMethod());
	}

	private FrameBuilder addressedMethod() {
		FrameBuilder result = addOwner(buildBaseFrame()).add("method").add(Selector.class.getSimpleName()).add("addressable");
		result.add("name", nameOf(element));
		return result;
	}

	private void addAddressableProperties(FrameBuilder builder) {
		if (!element.isAddressable()) return;
		Selector.Addressable addressable = element.asAddressable();
		builder.add("path", addressable.addressableResource() != null ? addressable.addressableResource().path() : "");
	}

	@Override
	protected String className(Class clazz) {
		return super.className(clazz).replace("selector", "");
	}
}
