/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.soap;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SoapOperationTemplate
extends Template {
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"operation"})).output(new Output[]{Outputs.literal((String)"package ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".soap.operations;\n\nimport java.util.List;\nimport java.util.ArrayList;\nimport io.intino.alexandria.exceptions.*;\nimport ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".*;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.http.server.AlexandriaHttpManager;\nimport io.intino.alexandria.http.pushservice.PushService;\n\n")}).output(new Output[]{Outputs.placeholder((String)"schemaImport", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\n\npublic class ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"Operation {\n\n\tprivate ")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Box box;\n\tprivate AlexandriaHttpManager<PushService<?,?>> manager;\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"authenticationValidator", (String[])new String[]{"field"})})}).output(new Output[]{Outputs.literal((String)"\n\n\tpublic ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"Operation(")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Box box, AlexandriaHttpManager manager) {\n\t\tthis.box = box;\n\t\tthis.manager = manager;\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"authenticationValidator", (String[])new String[]{"assign"})}).output(new Output[]{Outputs.literal((String)"\n\t}\n\n\tpublic void execute() ")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)"throws ")}).output(new Output[]{Outputs.placeholder((String)"throws", (String[])new String[0]).multiple(", ")})}).output(new Output[]{Outputs.literal((String)" {\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"returnType", (String[])new String[]{"methodCall"})}).output(new Output[]{Outputs.literal((String)"fill(new ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"validPackage"})}).output(new Output[]{Outputs.literal((String)".actions.")}).output(new Output[]{Outputs.placeholder((String)"operation", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Action()).execute()")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"returnType", (String[])new String[]{"ending"})})}).output(new Output[]{Outputs.literal((String)";\n\t}\n\n\tprivate ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"validPackage"})}).output(new Output[]{Outputs.literal((String)".actions.")}).output(new Output[]{Outputs.placeholder((String)"operation", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Action fill(")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"validPackage"})}).output(new Output[]{Outputs.literal((String)".actions.")}).output(new Output[]{Outputs.placeholder((String)"operation", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Action action) {\n\t\taction.box = this.box;\n\t\taction.context = context();\n\t\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"input", (String[])new String[]{"assign"})})}).output(new Output[]{Outputs.literal((String)"\n\t\treturn action;\n\t}\n\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"returnType", (String[])new String[]{"method"})})}).output(new Output[]{Outputs.literal((String)"\n\n\tprivate io.intino.alexandria.http.server.AlexandriaHttpContext context() {\n\t\tio.intino.alexandria.http.server.AlexandriaHttpContext context = new io.intino.alexandria.http.server.AlexandriaHttpContext(manager);\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"authenticationValidator", (String[])new String[]{"put"})}).output(new Output[]{Outputs.literal((String)"\n\t\tcontext.put(\"ip\", manager.ip());\n\t\treturn context;\n\t}\n}\n")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"methodcall")).output(new Output[]{Outputs.literal((String)"write(")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"ending")).output(new Output[]{Outputs.literal((String)")")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.attribute((String)"void"), (LogicalExpression)Predicates.trigger((String)"write"))));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"method")).output(new Output[]{Outputs.literal((String)"private void write(")}).output(new Output[]{Outputs.placeholder((String)"value", (String[])new String[]{"firstUpperCase", "ReturnTypeFormatter"})}).output(new Output[]{Outputs.literal((String)" object) {\n\tmanager.write(new io.intino.alexandria.Soap().writeEnvelope(object, \"")}).output(new Output[]{Outputs.placeholder((String)"xmlns", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"), \"text/xml\");\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"input"}), (LogicalExpression)Predicates.trigger((String)"assign"))).output(new Output[]{Outputs.literal((String)"action.")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"CamelCase"})}).output(new Output[]{Outputs.literal((String)" = new io.intino.alexandria.Soap().readEnvelope(manager.body()).body().schema(")}).output(new Output[]{Outputs.placeholder((String)"type", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".class);")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"authenticationValidator"}), (LogicalExpression)Predicates.trigger((String)"field"))).output(new Output[]{Outputs.literal((String)"io.intino.alexandria.http.security.")}).output(new Output[]{Outputs.placeholder((String)"type", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"AuthenticationValidator validator;")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"authenticationValidator"}), (LogicalExpression)Predicates.trigger((String)"assign"))).output(new Output[]{Outputs.literal((String)"this.validator = box.authenticationValidator();")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"authenticationValidator"}), (LogicalExpression)Predicates.trigger((String)"validate"))).output(new Output[]{Outputs.literal((String)"String auth = manager.fromHeader(\"Authorization\", String.class);\nif (auth == null || !validator.validate(auth.replace(\"Basic \", \"\"))) throw new Unauthorized(\"Credential not found\");")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"authenticationValidator"}), (LogicalExpression)Predicates.trigger((String)"put"))).output(new Output[]{Outputs.literal((String)"context.put(\"auth\", manager.fromHeader(\"Authorization\", String.class).replace(\"Basic \", \"\"));")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"parametertype")).output(new Output[]{Outputs.placeholder((String)"value", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".class")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"schemaImport"})).output(new Output[]{Outputs.literal((String)"import ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".schemas.*;")}));
        return rules;
    }

    public String render(Object object) {
        return new Engine((Template)this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine((Template)this).addAll(formatters).render(object);
    }
}

