/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RESTServiceTemplate
extends Template {
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"server"})).output(new Output[]{Outputs.literal((String)"package ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)";\n\nimport io.intino.alexandria.http.AlexandriaHttpServer;\nimport ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)".rest.resources.*;\nimport io.intino.alexandria.core.Box;\n\npublic class ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"Service {\n\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"authenticator", (String[])new String[]{"field"})})}).output(new Output[]{Outputs.literal((String)"\n\n\tpublic static AlexandriaHttpServer setup(AlexandriaHttpServer server, ")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Box box) {\n\t\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"authenticator", (String[])new String[]{"assign"})})}).output(new Output[]{Outputs.literal((String)"\n\t\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"authenticationWithCertificate", (String[])new String[0])})}).output(new Output[]{Outputs.literal((String)"\n\t\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"hasNotifications", (String[])new String[0])})}).output(new Output[]{Outputs.literal((String)"\n\t\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"notification", (String[])new String[0]).multiple("\n")})}).output(new Output[]{Outputs.literal((String)"\n\t\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"resource", (String[])new String[0]).multiple("\n")})}).output(new Output[]{Outputs.literal((String)"\n\n\t\treturn server;\n\t}\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"authenticator"}), (LogicalExpression)Predicates.trigger((String)"assign"))).output(new Output[]{Outputs.literal((String)"authenticator = new ")}).output(new Output[]{Outputs.placeholder((String)"service", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"ServiceAuthenticator(box);")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"authenticator"}), (LogicalExpression)Predicates.trigger((String)"field"))).output(new Output[]{Outputs.literal((String)"private static ")}).output(new Output[]{Outputs.placeholder((String)"service", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"ServiceAuthenticator authenticator;")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"authenticationWithCertificate"})).output(new Output[]{Outputs.literal((String)"server.secure(new io.intino.alexandria.http.security.DefaultSecurityManager(new java.io.File(\"")}).output(new Output[]{Outputs.placeholder((String)"file", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"), \"")}).output(new Output[]{Outputs.placeholder((String)"password", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"));")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"notification")).output(new Output[]{Outputs.literal((String)"server.route(\"")}).output(new Output[]{Outputs.placeholder((String)"path", (String[])new String[]{"format"})}).output(new Output[]{Outputs.literal((String)"\").post(manager -> new ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".rest.notifications.")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"Notification(box, manager).execute());")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"resource"})).output(new Output[]{Outputs.literal((String)"server.route(")}).output(new Output[]{Outputs.placeholder((String)"path", (String[])new String[]{"format"})}).output(new Output[]{Outputs.literal((String)")")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"authenticate", (String[])new String[0])})}).output(new Output[]{Outputs.literal((String)".")}).output(new Output[]{Outputs.placeholder((String)"method", (String[])new String[]{"firstlowerCase"})}).output(new Output[]{Outputs.literal((String)"(manager -> new ")}).output(new Output[]{Outputs.placeholder((String)"operation", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"Resource(box, manager).execute());")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"bearer"}), (LogicalExpression)Predicates.trigger((String)"authenticate"))).output(new Output[]{Outputs.literal((String)".before(manager -> { if (manager.fromHeader(\"Authorization\") == null || !authenticator.isAuthenticated(manager.fromHeader(\"Authorization\").replace(\"Bearer \", \"\"))) throw new io.intino.alexandria.exceptions.Unauthorized(\"Credential not found\");})")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"basic"}), (LogicalExpression)Predicates.trigger((String)"authenticate"))).output(new Output[]{Outputs.literal((String)".before(manager -> { if (manager.fromHeader(\"Authorization\") == null || !authenticator.isAuthenticated(manager.fromHeader(\"Authorization\").replace(\"Basic \", \"\"))) throw new io.intino.alexandria.exceptions.Unauthorized(\"Credential not found\");})")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"custom"}), (LogicalExpression)Predicates.trigger((String)"authenticate"))).output(new Output[]{Outputs.literal((String)".before(manager -> { if (!authenticator.isAuthenticated(manager.request().queryParams().stream().collect(java.util.stream.Collectors.toMap(p -> p, p -> manager.request().queryParams(p))))) throw new io.intino.alexandria.exceptions.Unauthorized(\"Credential not found\");})")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"path"}), (LogicalExpression)Predicates.trigger((String)"format"))).output(new Output[]{Outputs.literal((String)"\"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"custom", (String[])new String[0]).multiple("")})}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"custom")).output(new Output[]{Outputs.literal((String)".replace(\"{")}).output(new Output[]{Outputs.placeholder((String)"value", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"}\", box.configuration().get(\"")}).output(new Output[]{Outputs.placeholder((String)"value", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\"))")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"hasnotifications")).output(new Output[]{Outputs.literal((String)"if (!io.intino.alexandria.http.AlexandriaHttpServerBuilder.isUI()) server.route(\"/_alexandria/push\").push(new io.intino.alexandria.http.pushservice.PushService());")}));
        return rules;
    }

    public String render(Object object) {
        return new Engine((Template)this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine((Template)this).addAll(formatters).render(object);
    }
}

