/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.agenda;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AgendaServiceTemplate
extends Template {
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"service"})).output(new Output[]{Outputs.literal((String)"package ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)";\n\nimport ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"validPackage"})}).output(new Output[]{Outputs.literal((String)".")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"Box;\nimport ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"validPackage"})}).output(new Output[]{Outputs.literal((String)".agenda.*;\nimport io.intino.alexandria.http.AlexandriaHttpServer;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.scheduler.AlexandriaScheduler;\nimport org.apache.commons.io.FileUtils;\nimport io.intino.alexandria.Json;\n\n")}).output(new Output[]{Outputs.placeholder((String)"schemaImport", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\nimport org.quartz.*;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.nio.file.Files;\nimport java.time.Instant;\nimport java.time.temporal.ChronoUnit;\nimport java.util.*;\nimport java.util.function.Predicate;\nimport java.util.stream.Collectors;\n\nimport static io.intino.alexandria.Json.fromString;\nimport static org.quartz.CronScheduleBuilder.cronSchedule;\nimport static org.quartz.JobBuilder.newJob;\nimport static org.quartz.TriggerBuilder.newTrigger;\n\n@SuppressWarnings(\"unchecked\")\npublic class AgendaService {\n\tpublic static final String BaseUri = \"")}).output(new Output[]{Outputs.placeholder((String)"baseUri", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"/\";\n\tprivate static final Map<String, File> sources = new HashMap<>();\n\tprivate static final Map<String, Instant> timeouts = new HashMap<>();\n\tprivate final ")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"Box box;\n\tprivate final File root;\n\n\tpublic AgendaService(")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"Box box) {\n\t\tthis.box = box;\n\t\tthis.root = ")}).output(new Output[]{Outputs.placeholder((String)"rootPath", (String[])new String[]{"customizeDirectory"})}).output(new Output[]{Outputs.literal((String)";\n\t}\n\n\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"getter"}).multiple("\n\n")}).output(new Output[]{Outputs.literal((String)"\n\n\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"class"}).multiple("\n\n")}).output(new Output[]{Outputs.literal((String)"\n\n\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"execute"}).multiple("\n\n")}).output(new Output[]{Outputs.literal((String)"\n\n\tpublic AlexandriaHttpServer<?> setup(AlexandriaHttpServer<?> server, AlexandriaScheduler scheduler) {\n\t\tloadFutures();\n\t\tstartTimers(scheduler);\n\t\tstartService(server);\n\t\treturn server;\n\t}\n\n\tpublic Create create() {\n\t\treturn new Create();\n\t}\n\n\tpublic Remove remove() {\n\t\treturn new Remove();\n\t}\n\n\tprivate void startTimers(AlexandriaScheduler scheduler) {\n\t\ttry {\n\t\t\tJobDetail job = newJob(AgendaServiceTrigger.class).withIdentity(\"AgendaServiceTrigger\").build();\n\t\t\tjob.getJobDataMap().put(\"box\", box);\n\t\t\tscheduler.scheduleJob(job, Set.of(newTrigger().withIdentity(\"AgendaServiceTrigger\").withSchedule(cronSchedule(\"0 0/1 * 1/1 * ? *\")).build()), true);\n\t\t} catch (SchedulerException e) {\n\t\t\tLogger.error(e);\n\t\t}\n\t}\n\n\tprivate void startService(AlexandriaHttpServer<?> server) {\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"route"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n\t}\n\n\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"register"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n\n\tprivate void loadFutures() {\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"load"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n\t}\n\n\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"private"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n\n\tprivate static String read(File file) {\n\t\ttry {\n\t\t\treturn Files.readString(file.toPath());\n\t\t} catch (IOException e) {\n\t\t\tLogger.error(e);\n\t\t\treturn \"\";\n\t\t}\n\t}\n\n\tprivate void write(Object schema, File file) {\n\t\ttry {\n\t\t\tFiles.writeString(file.toPath(), Json.toString(schema));\n\t\t} catch (IOException e) {\n\t\t\tLogger.error(e);\n\t\t}\n\t}\n\n\tpublic class Create {\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"createMethod"}).multiple("\n\n")}).output(new Output[]{Outputs.literal((String)"\n\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"createClass"}).multiple("\n\n")}).output(new Output[]{Outputs.literal((String)"\n\t}\n\n\tpublic class Remove {\n\t\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"removeMethod"}).multiple("\n\n")}).output(new Output[]{Outputs.literal((String)"\n\t}\n\n\tpublic static class Option {\n\t\tpublic String id = UUID.randomUUID().toString();\n\t}\n\n\tpublic static class AgendaServiceTrigger implements Job {\n\t\tpublic void execute(JobExecutionContext context) throws JobExecutionException {\n\t\t\t")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"Box box = (")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"PascalCase"})}).output(new Output[]{Outputs.literal((String)"Box) context.getMergedJobDataMap().get(\"box\");\n\t\t\tfinal Instant instant = Instant.now().truncatedTo(ChronoUnit.MINUTES);\n\t\t\ttimeouts.forEach((k, v) -> {\n\t\t\t\tif (instant.equals(v)) {\n\t\t\t\t\t")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"timeout"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t}\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"future"}), (LogicalExpression)Predicates.trigger((String)"class"))).output(new Output[]{Outputs.literal((String)"public class ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Futures {\n\tpublic List<")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"> all(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"predicateSignature"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)") {\n\t\treturn ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"Files().stream()\n\t\t\t\t.filter(f -> ")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"test"}).multiple(" && ")}).output(new Output[]{Outputs.literal((String)")\n\t\t\t\t.map(f -> load")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(f)).collect(Collectors.toList());\n\t}\n\n\tpublic ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"signature"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)") {\n\t\treturn load")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"File(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"names"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)"));\n\t}\n\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"option", (String[])new String[]{"execute"}).multiple("\n")})}).output(new Output[]{Outputs.literal((String)"\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"register")).output(new Output[]{Outputs.literal((String)"private void register")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema schema) {\n\tFile file = ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"File(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"schemaParameter"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)");\n\tregister(schema, file);\n\twrite(schema, file);\n}\n\nprivate static void register(")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema schema, File file) {\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"option", (String[])new String[]{"putOption"}).multiple("\n")})}).output(new Output[]{Outputs.literal((String)"\n\tsources.put(schema.timeout().id, file);\n\ttimeouts.put(\"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"#\" + schema.timeout().id, schema.timeout().on());\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"load")).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"Files().forEach(file -> register(fromString(read(file), ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema.class), file));")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"route")).output(new Output[]{Outputs.literal((String)"server.route(BaseUri + Abstract")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)".URI.Path + \":id\").post(manager -> execute")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(manager.fromPath(\"id\")));")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"ifoption")).output(new Output[]{Outputs.literal((String)"if (\"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\".equalsIgnoreCase(option)) {\n\tfuture.schema().")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"(new ")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema.")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"optionParameter", (String[])new String[]{"argIndex"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)"));\n\tfuture.")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"();\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"putoption")).output(new Output[]{Outputs.literal((String)"sources.put(schema.")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"().id, file);")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"private")).output(new Output[]{Outputs.literal((String)"private void clean(")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" future) {\n\tfuture.uri().ids().forEach(i -> {\n\t\tfinal File file = sources.remove(i);\n\t\tif (file != null && file.exists()) file.delete();\n\t});\n\tString id = future.schema().timeout().id;\n\tfinal File file = sources.remove(id);\n\tif (file != null && file.exists()) file.delete();\n}\n\nprivate Collection<File> ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"Files() {\n\tFile directory = new File(root, \"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"camelCaseToKebabCase"})}).output(new Output[]{Outputs.literal((String)"/\");\n\tdirectory.mkdirs();\n\treturn FileUtils.listFiles(directory, new String[]{\"json\"}, true);\n}\n\nprivate File ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"File(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"signature"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)") {\n\tFile directory = new File(root, \"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"camelCaseToKebabCase"})}).output(new Output[]{Outputs.literal((String)"/\");\n\tdirectory.mkdirs();\n\treturn new File(directory, ")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"names"}).multiple(" + \"##\" + ")}).output(new Output[]{Outputs.literal((String)" + \".json\");\n}\n\nprivate ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" load")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(File file) {\n\tif (!file.exists()) return null;\n\tfinal ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" future = new ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(box);\n\tfuture.schema(fromString(read(file), ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema.class));\n\treturn future;\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"option"}), (LogicalExpression)Predicates.trigger((String)"execute"))).output(new Output[]{Outputs.literal((String)"public void ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)" ")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"FirstLowerCase"})}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)", ")}).output(new Output[]{Outputs.placeholder((String)"optionParameter", (String[])new String[]{"signature"}).multiple(", ")})}).output(new Output[]{Outputs.literal((String)") {\n\texecute(")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"FirstLowerCase"})}).output(new Output[]{Outputs.literal((String)", \"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"\"")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)", ")}).output(new Output[]{Outputs.placeholder((String)"optionParameter", (String[])new String[]{"names"}).multiple(", ")})}).output(new Output[]{Outputs.literal((String)");\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"future"}), (LogicalExpression)Predicates.trigger((String)"execute"))).output(new Output[]{Outputs.literal((String)"private void execute")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(String id) {\n\tfinal File file = sources.get(id);\n\tif (file == null) return;\n\tfinal ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" future = load")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(file);\n\tfinal String option = future.uri().option(id);\n\texecute(future, option);\n}\n\nprivate void execute(")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" future, String option, String... params) {\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"option", (String[])new String[]{"ifOption"}).multiple("\nelse ")})}).output(new Output[]{Outputs.literal((String)"\n\t")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.placeholder((String)"hasOption", (String[])new String[]{"else"})}).output(new Output[]{Outputs.literal((String)" ")})}).output(new Output[]{Outputs.literal((String)"\n\tfuture.timeout();\n\tclean(future);\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"else")).output(new Output[]{Outputs.literal((String)"else")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"getter")).output(new Output[]{Outputs.literal((String)"public ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Futures ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"() {\n\treturn new ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Futures();\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"removemethod")).output(new Output[]{Outputs.literal((String)"public boolean ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"signature"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)") {\n\tfinal File file = ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"File(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"names"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)");\n\tfinal ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)" = AgendaService.this.load")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(file);\n\tif (")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)" != null) timeouts.remove(\"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"#\" + ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)".schema().timeout().id);\n\tfor (String key : new ArrayList<>(sources.keySet()))\n\t\tif (sources.get(key).equals(file)) sources.remove(key);\n\tif (file.exists()) return file.delete();\n\treturn false;\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"createmethod")).output(new Output[]{Outputs.literal((String)"public ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"signature"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)") {\n\treturn new ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"names"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)");\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"timeout")).output(new Output[]{Outputs.literal((String)"if (k.startsWith(\"")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"#\")) box.agenda().execute")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(k.split(\"#\")[1]);")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"predicatesignature")).output(new Output[]{Outputs.literal((String)"Predicate<")}).output(new Output[]{Outputs.placeholder((String)"type", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"> ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"signature")).output(new Output[]{Outputs.placeholder((String)"type", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)" ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"names")).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"argindex")).output(new Output[]{Outputs.literal((String)"params[")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"]")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"Boolean"}), (LogicalExpression)Predicates.trigger((String)"test"))).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".test(Boolean.valueOf(f.getName().split(\"##\")[")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"]))")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"Double"}), (LogicalExpression)Predicates.trigger((String)"test"))).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".test(Double.parseDouble(f.getName().split(\"##\")[")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"]))\n")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"Integer"}), (LogicalExpression)Predicates.trigger((String)"test"))).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".test(Integer.parseInt(f.getName().split(\"##\")[")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"]))\n")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"test")).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".test(f.getName().split(\"##\")[")}).output(new Output[]{Outputs.placeholder((String)"index", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"])")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"schemaparameter")).output(new Output[]{Outputs.literal((String)"schema.")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"()")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"fluid")).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)")")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"optioncreate")).output(new Output[]{Outputs.literal((String)"public ")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"optionParameter", (String[])new String[]{"signature"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)") {\n\tschema.")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstLowerCase"})}).output(new Output[]{Outputs.literal((String)"(new ")}).output(new Output[]{Outputs.placeholder((String)"future", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema.")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"optionParameter", (String[])new String[]{"names"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)"));\n\treturn this;\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"createclass")).output(new Output[]{Outputs.literal((String)"public class ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" {\n\tprivate final ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema schema;\n\n\tpublic ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"signature"}).multiple(", ")}).output(new Output[]{Outputs.literal((String)") {\n\t\tschema = new ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema()")}).output(new Output[]{Outputs.expression((Output[])new Output[0]).output(new Output[]{Outputs.literal((String)".")}).output(new Output[]{Outputs.placeholder((String)"parameter", (String[])new String[]{"fluid"}).multiple(".")})}).output(new Output[]{Outputs.literal((String)";\n\t}\n\n\t")}).output(new Output[]{Outputs.placeholder((String)"option", (String[])new String[]{"optionCreate"}).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n\n\tpublic ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)" timeout(Instant timeout) {\n\t\tschema.timeout(new ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Schema.Timeout(timeout.truncatedTo(ChronoUnit.MINUTES)));\n\t\treturn this;\n\t}\n\n\tpublic void save() {\n\t\tregister")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"(schema);\n\t}\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"schemaImport"})).output(new Output[]{Outputs.literal((String)"import ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".schemas.*;")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"archetype"}), (LogicalExpression)Predicates.trigger((String)"customizedirectory"))).output(new Output[]{Outputs.literal((String)"new ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".Archetype(box.configuration().home()).")}).output(new Output[]{Outputs.placeholder((String)"path", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)".root()")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.all((LogicalExpression)Predicates.allTypes((String[])new String[]{"custom"}), (LogicalExpression)Predicates.trigger((String)"customizedirectory"))).output(new Output[]{Outputs.literal((String)"new File(box.configuration().get(\"")}).output(new Output[]{Outputs.placeholder((String)"path", (String[])new String[]{"customParameter"})}).output(new Output[]{Outputs.literal((String)"\"))")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.trigger((String)"customizedirectory")).output(new Output[]{Outputs.literal((String)"new java.io.File(\"")}).output(new Output[]{Outputs.placeholder((String)"path", (String[])new String[]{"customParameter"})}).output(new Output[]{Outputs.literal((String)"\")")}));
        return rules;
    }

    public String render(Object object) {
        return new Engine((Template)this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine((Template)this).addAll(formatters).render(object);
    }
}

