/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.analytic;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.analytic.ContinuousAxisTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Axis;
import java.io.File;
import java.util.List;

public class ContinuousAxisRenderer {
    private final CompilationContext context;
    private final File gen;

    public ContinuousAxisRenderer(CompilationContext context, File gen) {
        this.context = context;
        this.gen = gen;
    }

    public void render(Axis.Continuous axis) {
        FrameBuilder fb = new FrameBuilder(new String[]{"continuous"});
        this.addAxisBasicInfo(fb, axis);
        this.setRanges(fb, axis);
        Commons.writeFrame(new File(this.gen, "axes"), StringFormatters.pascalCase().format((Object)axis.name$()).toString(), new ContinuousAxisTemplate().render(fb.toFrame(), Formatters.all));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(axis), Commons.javaFile(new File(this.gen, "axes"), StringFormatters.pascalCase().format((Object)axis.name$()).toString()).getAbsolutePath()));
    }

    private void setRanges(FrameBuilder fb, Axis.Continuous axis) {
        List<Axis.Continuous.Range> ranges = axis.rangeList();
        for (int i = 0; i < ranges.size(); ++i) {
            this.addRange(fb, i, ranges.get(i));
        }
    }

    private void addRange(FrameBuilder fb, int index, Axis.Continuous.Range range) {
        FrameBuilder rangeFb = new FrameBuilder(new String[]{"range"}).add("index", (Object)index);
        if (range.isLowerBound()) {
            rangeFb.add("lower").add("bound", (Object)range.asLowerBound().lowerBound());
        } else if (range.isUpperBound()) {
            rangeFb.add("upper").add("bound", (Object)range.asUpperBound().upperBound());
        } else if (range.isBound()) {
            rangeFb.add("lower", (Object)range.asBound().lowerBound()).add("upper", (Object)range.asBound().upperBound());
        }
        fb.add("range", (Object)rangeFb);
        if (range.label() != null) {
            rangeFb.add("label", (Object)range.label());
        }
    }

    private void addAxisBasicInfo(FrameBuilder fb, Axis.Continuous axis) {
        fb.add("package", (Object)this.context.packageName()).add("name", (Object)StringFormatters.camelCase().format((Object)axis.name$()).toString()).add("label", (Object)axis.label()).add("rangeSize", (Object)axis.rangeList().size());
    }
}

