/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.mounter;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datahub.mounter.IMounterTemplate;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterFactoryTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Datamart;
import io.intino.konos.dsl.KonosGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MounterFactoryRenderer {
    private final CompilationContext context;
    private final List<Datamart.Mounter> mounters;
    private final File genMounters;

    public MounterFactoryRenderer(CompilationContext context, KonosGraph graph) {
        this.context = context;
        this.mounters = graph.datamartList().stream().map(Datamart::mounterList).flatMap(Collection::stream).collect(Collectors.toList());
        this.genMounters = new File(context.gen(Target.Service), "mounters");
    }

    public void execute() throws KonosException {
        if (this.mounters.isEmpty()) {
            return;
        }
        CompilationContext.DataHubManifest manifest = this.context.dataHubManifest();
        if (manifest == null) {
            throw new KonosException("Required Data hub declaration in artifact to instance subscribers");
        }
        FrameBuilder builder = this.baseFrame("factory");
        Map<String, List<Datamart.Mounter>> map = this.map(this.mounters, manifest);
        for (String event : map.keySet()) {
            builder.add("event", (Object)this.baseFrame("event").add("eventType", (Object)event).add("type", (Object)event.substring(event.lastIndexOf(".") + 1)).add("mounter", map.get(event).stream().map(m -> this.baseFrame("mounter").add("datamart", (Object)m.core$().owner().name()).add("name", (Object)m.name$()).toFrame()).toArray(Frame[]::new)));
        }
        this.context.classes().put(Datamart.Mounter.class.getSimpleName() + "#MounterFactory", "mounters.mounterFactory");
        Frame object = builder.toFrame();
        Commons.writeFrame(this.genMounters, "MounterFactory", new MounterFactoryTemplate().render(object, Formatters.all));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.mounters.get(0)), Commons.javaFile(this.genMounters, "MounterFactory").getAbsolutePath()));
        Commons.writeFrame(this.genMounters, "Mounter", new IMounterTemplate().render(object, Formatters.all));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.mounters.get(0)), Commons.javaFile(this.genMounters, "Mounter").getAbsolutePath()));
    }

    private Map<String, List<Datamart.Mounter>> map(List<Datamart.Mounter> mounters, CompilationContext.DataHubManifest manifest) {
        HashMap<String, List<Datamart.Mounter>> mountersByRequire = new HashMap<String, List<Datamart.Mounter>>();
        for (Datamart.Mounter mounter : mounters) {
            mounter.asEvent().requireList().forEach(r -> {
                String key = manifest.tankClasses.get(r.tank());
                if (key == null) {
                    return;
                }
                if (!mountersByRequire.containsKey(key)) {
                    mountersByRequire.put(key, new ArrayList());
                }
                ((List)mountersByRequire.get(key)).add(mounter);
            });
        }
        return mountersByRequire;
    }

    private FrameBuilder baseFrame(String name) {
        return new FrameBuilder(new String[]{name}).add("box", (Object)this.context.boxName()).add("package", (Object)this.context.packageName());
    }
}

