/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.accessible;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.accessor.ui.accessible.AccessibleRendererWriter;
import io.intino.konos.builder.codegeneration.services.ui.ServiceRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.ui.I18nRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayListRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.dsl.Service;
import java.io.File;

public class UiAccessibleAccessorRenderer
extends Renderer {
    private final Service.UI service;
    private final File destination;

    public UiAccessibleAccessorRenderer(CompilationContext compilationContext, Service.UI service, File destination) {
        super(compilationContext);
        this.service = service;
        this.destination = destination;
        this.destination.mkdirs();
    }

    @Override
    public void render() throws KonosException {
        this.context.serviceDirectory(new File(this.context.configuration().moduleDirectory().getParentFile(), Formatters.camelCaseToKebabCase().format((Object)this.service.name$()).toString()));
        new ServiceRenderer(this.context, this.service, Target.AccessibleAccessor, this.destination()).execute();
        new DisplayListRenderer(this.context, this.service, new AccessibleRendererWriter(this.context, this.destination())).execute();
        new I18nRenderer(this.context, this.service, Target.AccessibleAccessor, this.destination()).execute();
    }

    private File destination() {
        return new File(this.destination, this.packageName().replace(".", File.separator));
    }
}

