/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.accessible;

import io.intino.itrules.Engine;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.UiRendererWriter;
import io.intino.konos.builder.codegeneration.services.ui.templates.AbstractDesktopSkeletonTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.AbstractDisplaySkeletonTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.ComponentTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewNotifierTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.dsl.Display;
import io.intino.konos.dsl.PassiveView;
import io.intino.konos.dsl.Template;
import io.intino.magritte.framework.Layer;
import java.io.File;

public class AccessibleRendererWriter
extends UiRendererWriter {
    private final File destination;

    public AccessibleRendererWriter(CompilationContext context, File destination) {
        super(context, Target.AccessibleAccessor);
        this.destination = destination;
    }

    @Override
    public boolean write(Layer element, String type, FrameBuilder builder) {
        if (!element.i$(Display.Accessible.class)) {
            return true;
        }
        if (!builder.is("accessible")) {
            return true;
        }
        this.writeDisplay(element, type, builder);
        return true;
    }

    @Override
    public boolean writeNotifier(PassiveView element, FrameBuilder builder) {
        if (!element.i$(Display.Accessible.class)) {
            return true;
        }
        if (!builder.is("accessible")) {
            return true;
        }
        File notifierFile = Commons.javaFile(CodeGenerationHelper.displayNotifiersFolder(this.destination, this.target), this.nameOfPassiveViewFile(element, builder.toFrame(), "Notifier"));
        if (!this.context.cache().isModified(element) && notifierFile.exists()) {
            return true;
        }
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Notifier");
        if (!this.hasConcreteNotifier(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayNotifiersFolder(this.destination, this.target), element, name, new PassiveViewNotifierTemplate().render(frame, Formatters.all));
        return true;
    }

    @Override
    public boolean writeRequester(PassiveView element, FrameBuilder builder) {
        return true;
    }

    @Override
    public boolean writePushRequester(PassiveView element, FrameBuilder builder) {
        return true;
    }

    public Template template(Layer layer, FrameBuilder builder) {
        if (layer.i$(Template.Desktop.class)) {
            return Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new AbstractDesktopSkeletonTemplate()});
        }
        return Template.compose((Template)new ComponentTemplate(), (Template[])new Template[]{new AbstractDisplaySkeletonTemplate()});
    }

    private void writeDisplay(Layer element, String type, FrameBuilder builder) {
        Template template = this.template(element, builder);
        if (template == null) {
            return;
        }
        String newDisplay = this.displayName(element, this.isAccessible(builder));
        this.writeFrame(CodeGenerationHelper.displayFolder(this.destination, type, this.target), element, newDisplay, new Engine(template).addAll(Formatters.all).render((Object)builder.add("gen").toFrame()));
    }
}

