/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import cottons.utils.StringHelper;
import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.helpers.Commons;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class Formatters {
    public static Map<String, Formatter> all = new HashMap<String, Formatter>();

    public static Formatter validName() {
        return value -> StringHelper.snakeCaseToCamelCase((String)value.toString().replace(".", "-"));
    }

    public static Formatter camelCaseToKebabCase() {
        return value -> Formatters.camelCaseTo(value.toString(), "-");
    }

    public static Formatter camelCaseToSnakeCase() {
        return value -> Formatters.camelCaseTo(value.toString(), "_");
    }

    private static String camelCaseTo(String value, String separator) {
        if (value.isEmpty()) {
            return value;
        }
        StringBuilder result = new StringBuilder(String.valueOf(Character.toLowerCase(value.charAt(0))));
        for (int i = 1; i < value.length(); ++i) {
            result.append(Character.isUpperCase(value.charAt(i)) ? separator + Character.toLowerCase(value.charAt(i)) : Character.valueOf(value.charAt(i)));
        }
        return result.toString();
    }

    public static Formatter escapeHtml() {
        return value -> StringEscapeUtils.escapeHtml((String)((String)value));
    }

    public static Formatter returnType() {
        return value -> value.equals("Void") ? "void" : value;
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public static Formatter typeFormatter() {
        return value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        };
    }

    public static Formatter slashToCamel() {
        return o -> StringHelper.snakeCaseToCamelCase((String)o.toString().replace("|", "_"));
    }

    public static Formatter returnTypeFormatter() {
        return value -> {
            if (value.equals("Void")) {
                return "void";
            }
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        };
    }

    public static Formatter quoted() {
        return value -> "\"" + value.toString() + "\"";
    }

    public static Formatter validPackage() {
        return value -> value.toString().replace("-", "").toLowerCase();
    }

    private static Formatter subPath() {
        return value -> {
            String path = value.toString();
            return path.contains(":") ? path.substring(0, path.indexOf(":")) : path;
        };
    }

    public static Formatter shortType() {
        return value -> {
            String type = value.toString();
            String[] s = type.split("\\.");
            return s[s.length - 1];
        };
    }

    public static Frame customize(String name, String value) {
        FrameBuilder builder = new FrameBuilder(new String[]{name});
        builder.add("name", (Object)value);
        builder.add("custom", Commons.extractParameters(value).toArray(String[]::new));
        return builder.toFrame();
    }

    private static Formatter customParameter() {
        return value -> value.toString().substring(1, value.toString().length() - 1);
    }

    private static Formatter dotsWithUnderscore() {
        return value -> value.toString().replaceAll("\\.", "_");
    }

    static {
        all.put("validname", Formatters.validName());
        all.put("camelCaseToKebabCase", Formatters.camelCaseToKebabCase());
        all.put("camelCaseToSnakeCase", Formatters.camelCaseToSnakeCase());
        all.put("escapeHtml", Formatters.escapeHtml());
        all.put("returnType", Formatters.returnType());
        all.put("returnTypeFormatter", Formatters.returnTypeFormatter());
        all.put("validPackage", Formatters.validPackage());
        all.put("subpath", Formatters.subPath());
        all.put("shortType", Formatters.shortType());
        all.put("quoted", Formatters.quoted());
        all.put("customParameter", Formatters.customParameter());
        all.put("dotsWithUnderscore", Formatters.dotsWithUnderscore());
        all.put("slashToCamelCase", Formatters.slashToCamel());
        all.put("typeFormat", Formatters.typeFormatter());
    }
}

