package io.intino.konos.builder.codegeneration.accessor.ui.android.templates;

import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;

import java.util.ArrayList;
import java.util.List;

import static io.intino.itrules.template.condition.predicates.Predicates.allTypes;
import static io.intino.itrules.template.outputs.Outputs.*;

public class ThemeTemplate extends Template {

	public List<Rule> ruleSet() {
		List<Rule> rules = new ArrayList<>();
		rules.add(rule().condition(allTypes("theme")).output(literal("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<resources>\n    <style name=\"AppTheme\" parent=\"")).output(placeholder("type")).output(literal("\"/>\n    <style name=\"FullScreenDialog\" parent=\"AppTheme\">\n        <item name=\"android:windowFullscreen\">true</item>\n        <item name=\"android:windowAnimationStyle\">@android:style/Animation.Dialog</item>\n    </style>\n    ")).output(placeholder("format").multiple("\n")).output(literal("\n</resources>")));
		rules.add(rule().condition(allTypes("type", "Normal")).output(literal("Theme.Material3.Light")));
		rules.add(rule().condition(allTypes("type", "Dark")).output(literal("Theme.Material3.Dark")));
		rules.add(rule().condition(allTypes("format")).output(literal("<style name=\"")).output(placeholder("name")).output(literal("\">\n    ")).output(expression().output(literal("<item name=\"android:textSize\"")).output(literal(">")).output(placeholder("defaultTextSize")).output(literal("</item")).output(literal(">"))).output(literal("\n    ")).output(placeholder("attribute").multiple("\n")).output(literal("\n</style>")));
		rules.add(rule().condition(allTypes("attribute", "sizeable")).output(literal("<item name=\"android:")).output(placeholder("topName")).output(literal("\">")).output(placeholder("left")).output(literal("</item>\n<item name=\"android:")).output(placeholder("rightName")).output(literal("\">")).output(placeholder("right")).output(literal("</item>\n<item name=\"android:")).output(placeholder("bottomName")).output(literal("\">")).output(placeholder("bottom")).output(literal("</item>\n<item name=\"android:")).output(placeholder("leftName")).output(literal("\">")).output(placeholder("left")).output(literal("</item>")));
		rules.add(rule().condition(allTypes("attribute")).output(literal("<item name=\"android:")).output(placeholder("name")).output(literal("\">")).output(placeholder("value")).output(literal("</item>")));
		rules.add(rule().condition(allTypes("colors")).output(literal("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<resources>\n    <color name=\"white\">#FFFFFF</color>\n    <color name=\"grey\">#D3D3D3</color>\n    <color name=\"yellow\">#FFFF00</color>\n    <color name=\"fuchsia\">#FF00FF</color>\n    <color name=\"red\">#FF0000</color>\n    <color name=\"silver\">#C0C0C0</color>\n    <color name=\"gray\">#808080</color>\n    <color name=\"olive\">#808000</color>\n    <color name=\"purple\">#800080</color>\n    <color name=\"maroon\">#800000</color>\n    <color name=\"aqua\">#00FFFF</color>\n    <color name=\"lime\">#00FF00</color>\n    <color name=\"teal\">#008080</color>\n    <color name=\"green\">#008000</color>\n    <color name=\"blue\">#0000FF</color>\n    <color name=\"navy\">#000080</color>\n    <color name=\"black\">#000000</color>\n    <color name=\"White\">#FFFFFF</color>\n    <color name=\"Ivory\">#FFFFF0</color>\n    <color name=\"LightYellow\">#FFFFE0</color>\n    <color name=\"Yellow\">#FFFF00</color>\n    <color name=\"Snow\">#FFFAFA</color>\n    <color name=\"FloralWhite\">#FFFAF0</color>\n    <color name=\"LemonChiffon\">#FFFACD</color>\n    <color name=\"Cornsilk\">#FFF8DC</color>\n    <color name=\"Seashell\">#FFF5EE</color>\n    <color name=\"LavenderBlush\">#FFF0F5</color>\n    <color name=\"PapayaWhip\">#FFEFD5</color>\n    <color name=\"BlanchedAlmond\">#FFEBCD</color>\n    <color name=\"MistyRose\">#FFE4E1</color>\n    <color name=\"Bisque\">#FFE4C4</color>\n    <color name=\"Moccasin\">#FFE4B5</color>\n    <color name=\"NavajoWhite\">#FFDEAD</color>\n    <color name=\"PeachPuff\">#FFDAB9</color>\n    <color name=\"Gold\">#FFD700</color>\n    <color name=\"Pink\">#FFC0CB</color>\n    <color name=\"LightPink\">#FFB6C1</color>\n    <color name=\"Orange\">#FFA500</color>\n    <color name=\"LightSalmon\">#FFA07A</color>\n    <color name=\"DarkOrange\">#FF8C00</color>\n    <color name=\"Coral\">#FF7F50</color>\n    <color name=\"HotPink\">#FF69B4</color>\n    <color name=\"Tomato\">#FF6347</color>\n    <color name=\"OrangeRed\">#FF4500</color>\n    <color name=\"DeepPink\">#FF1493</color>\n    <color name=\"Fuchsia\">#FF00FF</color>\n    <color name=\"Magenta\">#FF00FF</color>\n    <color name=\"Red\">#FF0000</color>\n    <color name=\"OldLace\">#FDF5E6</color>\n    <color name=\"LightGoldenrodYellow\">#FAFAD2</color>\n    <color name=\"Linen\">#FAF0E6</color>\n    <color name=\"AntiqueWhite\">#FAEBD7</color>\n    <color name=\"Salmon\">#FA8072</color>\n    <color name=\"GhostWhite\">#F8F8FF</color>\n    <color name=\"MintCream\">#F5FFFA</color>\n    <color name=\"WhiteSmoke\">#F5F5F5</color>\n    <color name=\"Beige\">#F5F5DC</color>\n    <color name=\"Wheat\">#F5DEB3</color>\n    <color name=\"SandyBrown\">#F4A460</color>\n    <color name=\"Azure\">#F0FFFF</color>\n    <color name=\"Honeydew\">#F0FFF0</color>\n    <color name=\"AliceBlue\">#F0F8FF</color>\n    <color name=\"Khaki\">#F0E68C</color>\n    <color name=\"LightCoral\">#F08080</color>\n    <color name=\"PaleGoldenrod\">#EEE8AA</color>\n    <color name=\"Violet\">#EE82EE</color>\n    <color name=\"DarkSalmon\">#E9967A</color>\n    <color name=\"Lavender\">#E6E6FA</color>\n    <color name=\"LightCyan\">#E0FFFF</color>\n    <color name=\"BurlyWood\">#DEB887</color>\n    <color name=\"Plum\">#DDA0DD</color>\n    <color name=\"Gainsboro\">#DCDCDC</color>\n    <color name=\"Crimson\">#DC143C</color>\n    <color name=\"PaleVioletRed\">#DB7093</color>\n    <color name=\"Goldenrod\">#DAA520</color>\n    <color name=\"Orchid\">#DA70D6</color>\n    <color name=\"Thistle\">#D8BFD8</color>\n    <color name=\"LightGrey\">#D3D3D3</color>\n    <color name=\"Tan\">#D2B48C</color>\n    <color name=\"Chocolate\">#D2691E</color>\n    <color name=\"Peru\">#CD853F</color>\n    <color name=\"IndianRed\">#CD5C5C</color>\n    <color name=\"MediumVioletRed\">#C71585</color>\n    <color name=\"Silver\">#C0C0C0</color>\n    <color name=\"DarkKhaki\">#BDB76B</color>\n    <color name=\"RosyBrown\">#BC8F8F</color>\n    <color name=\"MediumOrchid\">#BA55D3</color>\n    <color name=\"DarkGoldenrod\">#B8860B</color>\n    <color name=\"FireBrick\">#B22222</color>\n    <color name=\"PowderBlue\">#B0E0E6</color>\n    <color name=\"LightSteelBlue\">#B0C4DE</color>\n    <color name=\"PaleTurquoise\">#AFEEEE</color>\n    <color name=\"GreenYellow\">#ADFF2F</color>\n    <color name=\"LightBlue\">#ADD8E6</color>\n    <color name=\"DarkGray\">#A9A9A9</color>\n    <color name=\"Brown\">#A52A2A</color>\n    <color name=\"Sienna\">#A0522D</color>\n    <color name=\"YellowGreen\">#9ACD32</color>\n    <color name=\"DarkOrchid\">#9932CC</color>\n    <color name=\"PaleGreen\">#98FB98</color>\n    <color name=\"DarkViolet\">#9400D3</color>\n    <color name=\"MediumPurple\">#9370DB</color>\n    <color name=\"LightGreen\">#90EE90</color>\n    <color name=\"DarkSeaGreen\">#8FBC8F</color>\n    <color name=\"SaddleBrown\">#8B4513</color>\n    <color name=\"DarkMagenta\">#8B008B</color>\n    <color name=\"DarkRed\">#8B0000</color>\n    <color name=\"BlueViolet\">#8A2BE2</color>\n    <color name=\"LightSkyBlue\">#87CEFA</color>\n    <color name=\"SkyBlue\">#87CEEB</color>\n    <color name=\"Gray\">#808080</color>\n    <color name=\"Olive\">#808000</color>\n    <color name=\"Purple\">#800080</color>\n    <color name=\"Maroon\">#800000</color>\n    <color name=\"Aquamarine\">#7FFFD4</color>\n    <color name=\"Chartreuse\">#7FFF00</color>\n    <color name=\"LawnGreen\">#7CFC00</color>\n    <color name=\"MediumSlateBlue\">#7B68EE</color>\n    <color name=\"LightSlateGray\">#778899</color>\n    <color name=\"SlateGray\">#708090</color>\n    <color name=\"OliveDrab\">#6B8E23</color>\n    <color name=\"SlateBlue\">#6A5ACD</color>\n    <color name=\"DimGray\">#696969</color>\n    <color name=\"MediumAquamarine\">#66CDAA</color>\n    <color name=\"CornflowerBlue\">#6495ED</color>\n    <color name=\"CadetBlue\">#5F9EA0</color>\n    <color name=\"DarkOliveGreen\">#556B2F</color>\n    <color name=\"Indigo\">#4B0082</color>\n    <color name=\"MediumTurquoise\">#48D1CC</color>\n    <color name=\"DarkSlateBlue\">#483D8B</color>\n    <color name=\"SteelBlue\">#4682B4</color>\n    <color name=\"RoyalBlue\">#4169E1</color>\n    <color name=\"Turquoise\">#40E0D0</color>\n    <color name=\"MediumSeaGreen\">#3CB371</color>\n    <color name=\"LimeGreen\">#32CD32</color>\n    <color name=\"DarkSlateGray\">#2F4F4F</color>\n    <color name=\"SeaGreen\">#2E8B57</color>\n    <color name=\"ForestGreen\">#228B22</color>\n    <color name=\"LightSeaGreen\">#20B2AA</color>\n    <color name=\"DodgerBlue\">#1E90FF</color>\n    <color name=\"MidnightBlue\">#191970</color>\n    <color name=\"Aqua\">#00FFFF</color>\n    <color name=\"Cyan\">#00FFFF</color>\n    <color name=\"SpringGreen\">#00FF7F</color>\n    <color name=\"Lime\">#00FF00</color>\n    <color name=\"MediumSpringGreen\">#00FA9A</color>\n    <color name=\"DarkTurquoise\">#00CED1</color>\n    <color name=\"DeepSkyBlue\">#00BFFF</color>\n    <color name=\"DarkCyan\">#008B8B</color>\n    <color name=\"Teal\">#008080</color>\n    <color name=\"Green\">#008000</color>\n    <color name=\"DarkGreen\">#006400</color>\n    <color name=\"Blue\">#0000FF</color>\n    <color name=\"MediumBlue\">#0000CD</color>\n    <color name=\"DarkBlue\">#00008B</color>\n    <color name=\"Navy\">#000080</color>\n    <color name=\"Black\">#000000</color>\n</resources>")));
		return rules;
	}

	public String render(Object object) {
		return new io.intino.itrules.Engine(this).render(object);
	}

	public String render(Object object, java.util.Map<String, io.intino.itrules.Formatter> formatters) {
		return new io.intino.itrules.Engine(this).addAll(formatters).render(object);
	}
}