/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.dsl.rules;

import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.model.rules.MogramRule;
import java.util.List;

public class CheckFileParameter
implements MogramRule {
    private Cause cause;

    public boolean accept(Mogram node) {
        List<Mogram> files = node.components().stream().filter(n -> this.isParameter((Mogram)n) && n.appliedFacets().stream().anyMatch(f -> f.type().equals("File"))).toList();
        if (!(files.isEmpty() || this.parameterInForm(files.get(0)) || this.parameterInBody(files.get(0)))) {
            this.cause = Cause.FileParameterNotInForm;
            return false;
        }
        return true;
    }

    public String errorMessage() {
        return this.cause.message;
    }

    private boolean isParameter(Mogram component) {
        return component.type().equals("Service.REST.Resource.Parameter");
    }

    private boolean parameterInForm(Mogram node) {
        return "form".equals(this.parameter(node, "in").values().get(0).toString());
    }

    private boolean parameterInBody(Mogram node) {
        return "body".equals(this.parameter(node, "in").values().get(0).toString());
    }

    private Parameter parameter(Mogram node, String name) {
        return node.parameters().stream().filter(v -> v.name().equals(name)).findFirst().orElse(null);
    }

    private static enum Cause {
        FileParameterNotInForm("File parameters only can be added in form");

        private final String message;

        private Cause(String message) {
            this.message = message;
        }
    }
}

