/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.utils;

import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.dsl.KonosGraph;
import io.intino.magritte.builder.StashBuilder;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.loaders.ClassFinder;
import io.intino.magritte.framework.stores.ResourcesStore;
import io.intino.magritte.io.model.Stash;
import io.intino.tara.Language;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import tara.dsl.Konos;

public class GraphLoader {
    private Stash[] stashes;

    public KonosGraph loadGraph(CompilerConfiguration configuration, List<File> srcFiles) {
        ClassFinder.clear();
        Charset charset = Charset.forName(configuration.sourceEncoding());
        if (!srcFiles.isEmpty()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StashBuilder stashBuilder = new StashBuilder(srcFiles.stream().collect(Collectors.toMap(f -> f, f -> charset)), (Language)new Konos(), configuration.module(), new PrintStream(out));
            this.stashes = stashBuilder.build();
            configuration.project();
            configuration.out().print(out.toString(StandardCharsets.UTF_8).replaceAll("%%rc.*/%rc\n", ""));
            if (this.stashes == null) {
                return null;
            }
            return this.loadGraph(configuration, this.stashes);
        }
        return this.loadGraph(configuration, new Stash[0]);
    }

    public Stash[] stashes() {
        return this.stashes;
    }

    private KonosGraph loadGraph(CompilerConfiguration configuration, Stash ... stashes) {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GraphLoader.class.getClassLoader());
        KonosGraph graph = KonosGraph.load((Store)this.store(configuration), stashes);
        if (graph == null) {
            return null;
        }
        graph.init(configuration.module());
        Thread.currentThread().setContextClassLoader(currentLoader);
        return graph;
    }

    private ResourcesStore store(final CompilerConfiguration configuration) {
        return new ResourcesStore(){

            public URL resourceFrom(String path) {
                try {
                    return new File(configuration.resDirectory().getPath() + File.separator + path).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        };
    }
}

