/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.cli;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CliTemplate
extends Template {
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"cli", "service"})).output(new Output[]{Outputs.literal((String)"package ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)";\n\nimport io.intino.alexandria.cli.CliManager;\nimport io.intino.alexandria.cli.schemas.BotTalk;\nimport io.intino.alexandria.http.AlexandriaSpark;\nimport ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)".")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Box;\n\npublic class ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"Service {\n\n    private static ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"ServiceAuthenticator authenticator;\n\n    public static void setup(AlexandriaSpark spark, ")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Box box, ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)" cli) {\n    \tauthenticator = new ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"ServiceAuthenticator(box);\n        spark.route(\"/cli/")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"camelCaseToSnakeCase", "lowerCase"})}).output(new Output[]{Outputs.literal((String)"\")\n                .before(manager -> { if (manager.fromHeader(\"Authorization\") == null || !authenticator.isAuthenticated(manager.fromHeader(\"Authorization\").replace(\"Bearer \", \"\"))) throw new io.intino.alexandria.exceptions.Unauthorized(\"Credential not found\");})\n                .post(manager -> manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(new CliManager(cli, io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromBody(), BotTalk.class)).execute(manager.fromHeader(\"Authorization\").replace(\"Bearer \", \"\")))));\n    }\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"cli", "authenticator"})).output(new Output[]{Outputs.literal((String)"package ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)";\n\npublic class ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"ServiceAuthenticator {\n \tprivate ")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Box box;\n\n \tpublic ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"ServiceAuthenticator(")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Box box) {\n\t\tthis.box = box;\n\t}\n\n\tpublic boolean isAuthenticated(String token) {\n\t\treturn false;\n\t}\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"cli"})).output(new Output[]{Outputs.literal((String)"package ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)";\n\nimport io.intino.alexandria.cli.Cli;\nimport io.intino.alexandria.cli.command.MessageProperties;\nimport io.intino.alexandria.cli.response.Text;\nimport ")}).output(new Output[]{Outputs.placeholder((String)"package", (String[])new String[]{"ValidPackage"})}).output(new Output[]{Outputs.literal((String)".cli.commands.*;\n\nimport java.io.IOException;\nimport java.util.Arrays;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\nimport static java.util.Collections.emptyList;\n\npublic class ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)" extends Cli {\n\n    public ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"pascalCase"})}).output(new Output[]{Outputs.literal((String)"(")}).output(new Output[]{Outputs.placeholder((String)"box", (String[])new String[]{"validname", "FirstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Box box) {\n        super();\n        add(\"help\", \"h\", \"Show this help\", emptyList(), emptyList(), \"\", (properties, command, args) -> new Text(help(properties)));\n        ")}).output(new Output[]{Outputs.placeholder((String)"command", (String[])new String[0]).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n        ")}).output(new Output[]{Outputs.placeholder((String)"confirmation", (String[])new String[0]).multiple("\n")}).output(new Output[]{Outputs.literal((String)"\n    }\n\n    @Override\n    protected String initialState() {\n        return \"")}).output(new Output[]{Outputs.placeholder((String)"initialState", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\";\n    }\n\n    private String help(MessageProperties properties) {\n        return this.commandsInfoByState(contexts().get(properties.token()).state()).keySet().stream()\n                .map((c) -> new StringBuilder().append(formatCommand(c, this.commandsInfoByState(contexts().get(properties.token()).state()).get(c))))\n                .collect(Collectors.joining(\"\\n\"));\n    }\n\n    private static String formatCommand(String command, CommandInfo info) {\n        return \"`\" + command.substring(command.lastIndexOf(\"$\") + 1) + \"|\" + info.abbr() + helpParameters(info.parameters()) + \"` \" + info.description();\n    }\n\n    private static String helpParameters(List<String> parameters) {\n        return parameters.isEmpty() ? \"\" : \" <\" + String.join(\"> <\", parameters) + \">\";\n    }\n}")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"confirmation"})).output(new Output[]{Outputs.literal((String)"addQuestionOption(\"")}).output(new Output[]{Outputs.placeholder((String)"option", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\", (properties, command, args) -> new ")}).output(new Output[]{Outputs.placeholder((String)"option", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Command(box).execute(properties, command, args));")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"command"})).output(new Output[]{Outputs.literal((String)"add(\"")}).output(new Output[]{Outputs.placeholder((String)"command", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\", \"")}).output(new Output[]{Outputs.placeholder((String)"abbreviation", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\", \"")}).output(new Output[]{Outputs.placeholder((String)"description", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\", ")}).output(new Output[]{Outputs.placeholder((String)"parameters", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)", ")}).output(new Output[]{Outputs.placeholder((String)"preconditions", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)", \"")}).output(new Output[]{Outputs.placeholder((String)"postcondition", (String[])new String[0])}).output(new Output[]{Outputs.literal((String)"\", (properties, command, args) -> new ")}).output(new Output[]{Outputs.placeholder((String)"name", (String[])new String[]{"firstUpperCase"})}).output(new Output[]{Outputs.literal((String)"Command(box).execute(properties, command, args));")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"list", "empty"})).output(new Output[]{Outputs.literal((String)"emptyList()")}));
        rules.add(this.rule().condition((LogicalExpression)Predicates.allTypes((String[])new String[]{"list"})).output(new Output[]{Outputs.literal((String)"List.of(\"")}).output(new Output[]{Outputs.placeholder((String)"item", (String[])new String[0]).multiple("\", \"")}).output(new Output[]{Outputs.literal((String)"\")")}));
        return rules;
    }

    public String render(Object object) {
        return new Engine((Template)this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine((Template)this).addAll(formatters).render(object);
    }
}

